/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pullup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ide.Context;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberTableModel;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveUpDownDialog;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.util.JotListCellRenderer;

public class PullUpDialog
extends MoveUpDownDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "PULL_UP_PREF_KEY";
    private DefaultComboBoxModel _targetModel;
    private JComboBox _targetComboBox;
    private boolean useSuperMembers;

    public PullUpDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
    }

    public boolean init() {
        boolean ret = false;
        if (this.buildTargetModel()) {
            this.setPreferredSize(new Dimension(420, 240));
            JComponent targetComponent = this.createTargetComponent();
            JLabel targetLabel = new JLabel();
            JComponent focusableComponent = GraphicsUtils.getFocusableComponentOrChild((Component)targetComponent, (boolean)true);
            ResourceUtils.resLabel((JLabel)targetLabel, (Component)focusableComponent, (String)RefactoringArb.getString(344));
            this._members = this.createTable();
            JScrollPane scrollPane = new JScrollPane(this._members);
            scrollPane.getViewport().setBackground(this._members.getBackground());
            JLabel membersLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)membersLabel, (Component)this._members, (String)RefactoringArb.getString(175));
            Insets insets = new Insets(2, 2, 2, 2);
            this.add((Component)targetLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)targetComponent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)membersLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)scrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            ret = true;
        }
        return ret;
    }

    protected boolean canClose() {
        SourceClass targetClass = this.getTarget();
        this.useSuperMembers = this.confirmCanProceedWithExistingMembers((JavaClass)targetClass);
        return this.useSuperMembers;
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(42);
    }

    private boolean buildTargetModel() {
        SourceClass sourceSourceClass;
        boolean ret = false;
        Context context = this.getContext();
        ArrayList classes = PullUpController.getPossibleTargets(context, sourceSourceClass = this.getSourceSourceClass());
        if (classes.isEmpty()) {
            Util.showRefactoringErrorMessage(42, 313);
        } else {
            Object[] items = classes.toArray(new Object[classes.size()]);
            this._targetModel = new DefaultComboBoxModel<Object>(items);
            ret = true;
        }
        return ret;
    }

    public SourceClass getTarget() {
        SourceClass target = null;
        if (this._targetModel != null) {
            target = (SourceClass)this._targetModel.getSelectedItem();
        }
        return target;
    }

    protected Collection getMoveableInterfaces() {
        ArrayList interfaces = new ArrayList(super.getMoveableInterfaces());
        SourceClass target = this.getTarget();
        if (target != null && target.isInterface()) {
            int i = interfaces.size() - 1;
            while (i >= 0) {
                JavaType javaType = (JavaType)interfaces.get(i);
                if (javaType.isAssignableFrom((JavaType)target)) {
                    interfaces.remove(i);
                }
                --i;
            }
        }
        return interfaces;
    }

    protected ComboBoxModel getTargetModel() {
        return this._targetModel;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dpullmembersup_html";
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        List sourceMethods = sourceClass.getSourceMethods();
        MultiMap memberDependencies = new MultiMap();
        int i = 0;
        while (i < sourceMethods.size()) {
            SourceMethod sourceMethod = (SourceMethod)sourceMethods.get(i);
            HashSet methodDependencies = this.calculateDependencies(sourceMethod.getEnclosingClass(), (SourceElement)sourceMethod.getBlock());
            for (SourceElement sourceElement : methodDependencies) {
                memberDependencies.add((Object)sourceElement, (Object)sourceMethod);
            }
            ++i;
        }
        Collection sourceFieldVariables = sourceClass.getSourceFieldVariables();
        for (SourceFieldVariable sourceFieldVariable : sourceFieldVariables) {
            SourceExpression initializer = sourceFieldVariable.getInitializer();
            HashSet initializerDependencies = this.calculateDependencies(sourceClass, (SourceElement)initializer);
            for (SourceElement sourceElement : initializerDependencies) {
                memberDependencies.add((Object)sourceElement, (Object)sourceFieldVariable);
            }
        }
        return memberDependencies;
    }

    protected JComponent createTargetComponent() {
        this._targetComboBox = new JComboBox(this._targetModel);
        this._targetComboBox.setRenderer(new JotListCellRenderer());
        this._targetComboBox.addActionListener(this);
        return this._targetComboBox;
    }

    public void actionPerformed(ActionEvent e) {
        MoveMemberTableModel tableModel = this.createTableModel();
        this._members.setModel(tableModel);
        this.updateTableColumns(this._members);
        if (this.getTarget().isInterface()) {
            ArrayList entries = tableModel.getEntries();
            int i = 0;
            while (i < entries.size()) {
                MoveMemberEntry moveMemberEntry = (MoveMemberEntry)entries.get(i);
                moveMemberEntry.setEnabled(2, false);
                moveMemberEntry.setEnabled(3, false);
                ++i;
            }
        }
    }

    public boolean isUseSuperMembers() {
        return this.useSuperMembers;
    }
}

