/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pushdown;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.criteria.PushDownCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveMemberMethodEntry;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.oprs.movemember.pushdown.PushDownDialog;

public class PushDownController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            if (sourceClass != null) {
                canHandle = PushDownController.canPushDown(sourceClass);
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                        canHandle = PushDownController.canPushDown(sourceSourceClass);
                    }
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    public static boolean canPushDown(SourceClass sourceClass) {
        SourceFile containingSourceFile;
        URL url;
        boolean ret = false;
        if (!sourceClass.isAnnotation() && !sourceClass.isAnonymous() && PullUpController.hasMembersToMove(sourceClass) && Util.canRefactor(url = (containingSourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            ret = true;
        }
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        SourceClass srcSourceClass = ElementAt.getSourceClassAt(context, false, false);
        if (srcSourceClass != null) {
            PushDownController.whenPushDown(context, srcSourceClass, (SourceMember)null);
        } else {
            Element element = context.getElement();
            if (element instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                SourceClass sourceSourceClass = Patch.getMainClass(javaManager.getSourceFile(javaSourceNode.getURL()));
                if (sourceSourceClass != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                    PushDownController.whenPushDown(context, sourceSourceClass, (SourceMember)null);
                }
            }
        }
        return true;
    }

    private static int fixMethodModifiers(int modifiers) {
        if (BitField.isSet((int)modifiers, (int)2) || Util.isPackagePrivate(modifiers)) {
            modifiers = BitField.unset((int)modifiers, (int)2);
            modifiers = BitField.set((int)modifiers, (int)4);
        }
        return modifiers;
    }

    public static void whenPushDown(Context context, SourceClass sourceclass, SourceMember preselectedMember) {
        PushDownDialog pushDownDialog = new PushDownDialog(context, sourceclass);
        if (pushDownDialog.init() && pushDownDialog.runDialog() && pushDownDialog.isValidOperation()) {
            try {
                PushDownController.whenPushDown(context, sourceclass, pushDownDialog);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void whenPushDown(Context context, SourceClass srcSourceClass, PushDownDialog pushDownDialog) {
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            MoveMemberMethodEntry[] methodEntries = pushDownDialog.getPulledMethodEntries();
            SourceFieldVariable[] fields = pushDownDialog.getPulledFields();
            ArrayList existingSubMembers = pushDownDialog.getExistingSubMembers();
            SourceClass[] subClasses = pushDownDialog.getSubClasses();
            int i = 0;
            while (i < subClasses.length) {
                SourceClass subClass = subClasses[i];
                SourceClassBody targetBody = subClass.getSourceBody();
                SourceFile targetSourceFile = subClass.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)targetSourceFile);
                SourceFactory targetFactory = targetSourceFile.getFactory();
                int j = 0;
                while (j < methodEntries.length) {
                    MoveMemberMethodEntry methodEntry = methodEntries[j];
                    SourceMethod srcMethod = methodEntry.getMethod();
                    if (!PushDownController.methodExistsInSubClass(subClass, srcMethod)) {
                        int modifiers = srcMethod.getModifiers();
                        int fixedModifiers = PushDownController.fixMethodModifiers(modifiers);
                        SourceMethod targetMethod = (SourceMethod)srcMethod.cloneSelf(targetSourceFile);
                        targetMethod.setModifiers(fixedModifiers);
                        targetMethod.addSelf((SourceElement)targetBody);
                    }
                    ++j;
                }
                int j2 = 0;
                while (j2 < fields.length) {
                    SourceFieldVariable sourceFieldVariable = fields[j2];
                    if (!existingSubMembers.contains(subClass.getName() + "." + sourceFieldVariable.getName())) {
                        int fixedModifiers = PushDownController.fixMethodModifiers(sourceFieldVariable.getModifiers());
                        SourceFieldVariable targetFieldVariable = (SourceFieldVariable)sourceFieldVariable.cloneSelf(targetSourceFile);
                        targetFieldVariable.setModifiers(fixedModifiers);
                        SourceFieldDeclaration fieldDeclaration = targetFactory.createFieldDeclaration(targetFieldVariable);
                        fieldDeclaration.addSelf((SourceElement)targetBody);
                    }
                    ++j2;
                }
                ++i;
            }
            boolean introducedAbstractMethods = false;
            int i2 = 0;
            while (i2 < methodEntries.length) {
                MoveMemberMethodEntry methodEntry = methodEntries[i2];
                SourceMethod srcMethod = methodEntry.getMethod();
                refactoringCommandSupport.beginTransaction((SourceElement)srcMethod);
                if (methodEntry.isAbstract()) {
                    if (!srcMethod.isAbstract()) {
                        refactoringCommandSupport.beginTransaction((SourceElement)srcMethod);
                        SourceBlock sourceBlock = srcMethod.getBlock();
                        sourceBlock.removeSelf();
                        srcMethod.addModifiers(1024);
                        introducedAbstractMethods = true;
                    }
                } else {
                    srcMethod.removeSelf();
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < fields.length) {
                SourceFieldVariable sourceFieldVariable = fields[i3];
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFieldVariable);
                sourceFieldVariable.removeSelf();
                ++i3;
            }
            if (introducedAbstractMethods && !srcSourceClass.isAbstract()) {
                refactoringCommandSupport.beginTransaction((SourceElement)srcSourceClass);
                srcSourceClass.addModifiers(1024);
            }
            ClassDescription[] subclassDescriptions = new ClassDescription[subClasses.length];
            int i4 = 0;
            while (i4 < subClasses.length) {
                SourceClass subClass = subClasses[i4];
                subclassDescriptions[i4] = ClassDescription.createClassDescription((JavaClass)subClass);
                ++i4;
            }
            MethodDescription[] methodDescriptions = new MethodDescription[methodEntries.length];
            boolean[] abstractMethods = new boolean[methodDescriptions.length];
            int i5 = 0;
            while (i5 < methodEntries.length) {
                MoveMemberMethodEntry methodEntry = methodEntries[i5];
                SourceMethod sourceMethod = methodEntry.getMethod();
                methodDescriptions[i5] = new MethodDescription((JavaMethod)sourceMethod);
                abstractMethods[i5] = methodEntry.isAbstract();
                ++i5;
            }
            FieldDescription[] fieldDescriptions = new FieldDescription[fields.length];
            int i6 = 0;
            while (i6 < fields.length) {
                SourceFieldVariable sourceFieldVariable = fields[i6];
                fieldDescriptions[i6] = new FieldDescription((JavaField)sourceFieldVariable);
                ++i6;
            }
            PushDownCriteria criteria = new PushDownCriteria(ClassDescription.createClassDescription((JavaClass)srcSourceClass), subclassDescriptions, methodDescriptions, abstractMethods, fieldDescriptions);
            BasicOperation searchOperation = new BasicOperation(context, criteria);
            refactoringCommandSupport.setSearchOperation(searchOperation);
            refactoringCommandSupport.commit(context, RefactoringArb.getString(224));
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
    }

    private static boolean methodExistsInSubClass(SourceClass subClass, SourceMethod srcMethod) {
        Collection methods = subClass.getMethods(srcMethod.getName());
        for (JavaMethod method : methods) {
            if (!method.getSignature().equals(srcMethod.getSignature()) || !subClass.equals((Object)method.getOwningClass())) continue;
            return true;
        }
        return false;
    }
}

