/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.movemember.pushdown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.movemember.MoveUpDownDialog;

public class PushDownDialog
extends MoveUpDownDialog {
    public static final String PREFERENCE_KEY = "PUSH_DOWN_PREF_KEY";
    private SourceClass[] _subClasses;
    private boolean _validOperation;
    private ArrayList existingSubMembers;

    private void $init$() {
        this._validOperation = true;
        this.existingSubMembers = new ArrayList();
    }

    public PushDownDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context, sourceClass);
        this.$init$();
    }

    public boolean init() {
        this.setPreferredSize(new Dimension(420, 240));
        this._members = this.createTable();
        JScrollPane scrollPane = new JScrollPane(this._members);
        scrollPane.getViewport().setBackground(this._members.getBackground());
        JLabel membersLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)membersLabel, (Component)this._members, (String)RefactoringArb.getString(175));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)membersLabel, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        return true;
    }

    public SourceClass[] getSubClasses() {
        if (this._subClasses == null) {
            Context context = this.getContext();
            SourceClass sourceSourceClass = this.getSourceSourceClass();
            this._subClasses = Patch.getSubClasses(context, sourceSourceClass);
        }
        return this._subClasses;
    }

    protected boolean canClose() {
        boolean canClose = true;
        SourceClass[] subClasses = this.getSubClasses();
        if (subClasses.length > 0) {
            int i = 0;
            while (i < subClasses.length) {
                SourceClass subClass = subClasses[i];
                ArrayList existingMembers_i = this.getExistingMembers((JavaClass)subClass, true);
                this.existingSubMembers.addAll(existingMembers_i);
                ++i;
            }
            if (!this.existingSubMembers.isEmpty()) {
                String message = RefactoringArb.getString(334);
                JList<Object> list = new JList<Object>(this.existingSubMembers.toArray(new Object[this.existingSubMembers.size()]));
                JLabel label = new JLabel();
                ResourceUtils.resLabel((JLabel)label, list, (String)message);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "North");
                panel.add((Component)new JScrollPane(list), "Center");
                IdeMainWindow mainWindow = Ide.getMainWindow();
                JEWTDialog dlg = new JEWTDialog((Frame)mainWindow, this.getTitle(), 3);
                dlg.setOKButtonText(RefactoringArb.getString(27));
                dlg.setContent((Component)panel);
                dlg.setResizable(true);
                if (!WizardLauncher.runDialog((JDialog)dlg)) {
                    canClose = false;
                }
            }
        } else {
            Util.showRefactoringErrorMessage(this.getTitle(), RefactoringArb.getString(313));
            this.setValidOperation(false);
        }
        return canClose;
    }

    protected String getDialogTitle() {
        return RefactoringArb.getString(224);
    }

    protected ComboBoxModel getTargetModel() {
        return null;
    }

    public boolean isValidOperation() {
        return this._validOperation;
    }

    public void setValidOperation(boolean validOperation) {
        this._validOperation = validOperation;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dpushmembersdown_html";
    }

    protected MultiMap calculateDependencies(SourceClass sourceClass) {
        return this.calculateDownDependencies(sourceClass);
    }

    public ArrayList getExistingSubMembers() {
        return this.existingSubMembers;
    }
}

