/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class RenameClassDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_CLASS_DEFAULTS";
    private SourceClass _sourceClass;
    private String _oldName;

    public RenameClassDialog(Context context, SourceClass sourceClass) {
        super(context, PREFERENCE_KEY);
        this._sourceClass = sourceClass;
        this._oldName = this._sourceClass.getName();
        int dollarPos = this._oldName.lastIndexOf(36);
        if (dollarPos >= 0) {
            Assert.check((boolean)sourceClass.isMemberClass());
            this._oldName = this._oldName.substring(dollarPos + 1);
        }
        this.setOldName(this._oldName);
    }

    public boolean runDialog() {
        SourceFile owningFile;
        URL url;
        URL parent;
        URL newUrl;
        String platformPathName;
        boolean ret = super.runDialog();
        if (ret && (platformPathName = URLFileSystem.getPlatformPathName((URL)(newUrl = URLFactory.newURL((URL)(parent = URLFileSystem.getParent((URL)(url = (owningFile = this._sourceClass.getOwningSourceFile()).getURL()))), (String)(this.getNewName() + ".java"))))).length() > 255) {
            Util.showRefactoringErrorMessage(246, 278);
            ret = false;
        }
        return ret;
    }

    protected String getTitle() {
        String oldClassName = this._sourceClass.getName();
        String title = MessageFormat.format(RefactoringArb.getString(246), oldClassName);
        return title;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String className = this.getNewName();
            Project project = this.getContext().getProject();
            String packageName = this._sourceClass.getPackageName();
            boolean isValid = false;
            String message = null;
            if (!this._oldName.equals(className)) {
                NameValidation nameValidation = NameValidation.validateClassName(this._sourceClass, project, packageName, className, true);
                isValid = nameValidation.isValid();
                message = nameValidation.getMessage();
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }
}

