/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.MoveFilesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameVariableCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigController;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveController;
import oracle.jdevimpl.refactoring.oprs.move.MoveFilesOperation;
import oracle.jdevimpl.refactoring.oprs.rename.RenameClassDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenamePackageDialog;
import oracle.jdevimpl.refactoring.oprs.rename.RenameVariableDialog;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldDialog;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodDialog;

public class RenameController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle;
        block6: {
            block7: {
                canHandle = false;
                if (context == null || context.getWorkspace() == null || context.getProject() == null) break block6;
                ElementAt elementAt = ElementAt.findElementAt(context);
                if (elementAt == null) break block7;
                int type = elementAt.getElementType();
                switch (type) {
                    case 3: 
                    case 4: 
                    case 7: {
                        JavaMember javaMember = (JavaMember)elementAt.getJavaElement();
                        canHandle = RenameController.canRenameMember(context, javaMember);
                        break block6;
                    }
                    case 1: 
                    case 2: {
                        canHandle = RenameController.canRename(context, elementAt);
                        break block6;
                    }
                    case 5: {
                        SourceElement sourceElement = elementAt.getSourceElement();
                        SourceFile sourceFile = sourceElement.getOwningSourceFile();
                        URL url = sourceFile.getURL();
                        canHandle = Util.canRefactor(url);
                        break block6;
                    }
                    case 6: {
                        canHandle = RenameController.canRenamePackage();
                        break block6;
                    }
                    default: {
                        return false;
                    }
                }
            }
            canHandle = this.whenRenameSelection(context, false);
        }
        action.setEnabled(canHandle);
        return true;
    }

    private boolean whenRenameSelection(Context context, boolean doit) {
        Element selected;
        boolean canHandle = false;
        Element[] selection = context.getSelection();
        if (selection != null && selection.length == 1 && (selected = selection[0]) instanceof Node) {
            Node node = (Node)selected;
            URL url = node.getURL();
            canHandle = Util.canRefactor(url);
            if (doit) {
                RenameController.whenRenameUrl(context, url, false);
            }
        }
        return canHandle;
    }

    private static boolean canRename(Context context, ElementAt elementAt) {
        JavaElement javaElement = elementAt.getJavaElement();
        boolean ret = RenameController.canRename(context, javaElement);
        return ret;
    }

    private static boolean canRename(Context context, JavaElement javaElement) {
        boolean ret = false;
        SourceElement sourceElement = javaElement.getSourceElement();
        if (sourceElement != null) {
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            URL url = sourceFile.getURL();
            ret = Util.canRefactor(context, url);
        }
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        block10: {
            block9: {
                ElementAt elementAt = ElementAt.findElementAt(context);
                if (elementAt == null) break block9;
                int type = elementAt.getElementType();
                switch (type) {
                    case 3: {
                        SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                        this.handleRenameMethod(context, sourceMethod);
                        break block10;
                    }
                    case 4: 
                    case 7: {
                        SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)elementAt.getSourceElement();
                        this.handleRenameField(context, sourceMemberVariable);
                        break block10;
                    }
                    case 1: {
                        SourceClass sourceClass = (SourceClass)elementAt.getSourceElement();
                        this.handleRenameClass(context, sourceClass);
                        break block10;
                    }
                    case 5: {
                        SourceVariable sourceVariable = (SourceVariable)elementAt.getSourceElement();
                        this.handleRenameVariable(context, sourceVariable);
                        break block10;
                    }
                    case 2: {
                        SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                        if (sourceMethod != null) {
                            SourceClass declaringClass = sourceMethod.getEnclosingClass();
                            this.handleRenameClass(context, declaringClass);
                        }
                        break block10;
                    }
                    case 6: {
                        JavaPackage javaPackage = elementAt.getJavaPackage();
                        this.handleRenamePackage(context, javaPackage);
                        break block10;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.whenRenameSelection(context, true);
        }
        return true;
    }

    protected boolean handleRenameMethod(Context context, SourceMethod sourceMethod) {
        SourceMethod realMethod;
        if (sourceMethod != null && (realMethod = MetSigController.confirmSourceMethod(sourceMethod)) != null) {
            return RenameController.whenRenameMethod(context, realMethod);
        }
        return false;
    }

    protected boolean handleRenameField(Context context, SourceMemberVariable sourceMemberVariable) {
        if (sourceMemberVariable != null) {
            return RenameController.whenRenameField(context, sourceMemberVariable);
        }
        return false;
    }

    protected boolean handleRenameClass(Context context, SourceClass sourceClass) {
        if (sourceClass != null) {
            return RenameController.whenRenameClass(context, sourceClass);
        }
        return false;
    }

    protected boolean handleRenameVariable(Context context, SourceVariable sourceVariable) {
        if (sourceVariable != null) {
            SourceFile sourceFile = sourceVariable.getOwningSourceFile();
            return RenameController.whenRenameVariable(context, sourceVariable, sourceFile);
        }
        return false;
    }

    protected boolean handleRenamePackage(Context context, JavaPackage javaPackage) {
        if (javaPackage != null) {
            return RenameController.whenRenamePackage(context, javaPackage);
        }
        return false;
    }

    private static boolean checkCanRefactor(SourceElement element) {
        if (Util.canRefactor(element)) {
            return true;
        }
        SourceFile owningSourceFile = element.getOwningSourceFile();
        URL url = owningSourceFile.getURL();
        String message = MessageFormat.format(RefactoringArb.getString(332), URLFileSystem.getPlatformPathName((URL)url));
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message);
        return false;
    }

    public static boolean canRenameClass(Context context, SourceClass sourceClass) {
        return RenameController.canRename(context, (JavaElement)sourceClass);
    }

    public static boolean whenRenameClass(Context context, SourceClass sourceClass) {
        RenameClassDialog renameToDialog;
        boolean runRefactor = false;
        if (RenameController.checkCanRefactor((SourceElement)sourceClass) && (renameToDialog = new RenameClassDialog(context, sourceClass)).runDialog()) {
            int beginIndex;
            String newName = renameToDialog.getNewName();
            boolean searchInComments = renameToDialog.isSearchInComments();
            boolean searchInNonJavaFiles = renameToDialog.isSearchInNonJavaFiles();
            String packageName = sourceClass.getPackageName();
            String oldName = sourceClass.getName();
            String oldFqName = sourceClass.getQualifiedName();
            String newFqName = oldFqName.substring(0, oldFqName.length() - oldName.length()) + newName;
            String shortTitle = MessageFormat.format(RefactoringArb.getString(246), oldFqName);
            String longTitle = MessageFormat.format(RefactoringArb.getString(262), oldFqName, newFqName);
            MoveClassesCriteria criteria = new MoveClassesCriteria(searchInComments, searchInNonJavaFiles, longTitle, shortTitle);
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            SourceClass reSearchedClass = javaManager.getSourceClass(oldFqName);
            if (reSearchedClass == null) {
                SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
                criteria.hintMisplacedFile(owningSourceFile);
            }
            if ((beginIndex = packageName.length()) > 0) {
                ++beginIndex;
            }
            criteria.addClassMove(javaManager, packageName, oldFqName.substring(beginIndex), packageName, newFqName.substring(beginIndex));
            MoveClassesOperation searchOperation = new MoveClassesOperation(context, criteria);
            Util.setOperationHints((SearchOperationImpl)searchOperation, (JavaClass)sourceClass, false);
            boolean preview = renameToDialog.hasPreview();
            ((SearchOperationImpl)searchOperation).runRefactoring(preview);
            runRefactor = true;
        }
        return runRefactor;
    }

    public static boolean canRenameMethod(Context context, SourceMethod sourceMethod) {
        return RenameController.canRenameMember(context, (JavaMember)sourceMethod);
    }

    public static boolean whenRenameMethod(Context context, SourceMethod sourceMethod) {
        boolean runRefactor = false;
        RenameMethodDialog renameMethodDialog = new RenameMethodDialog(context, sourceMethod);
        if (renameMethodDialog.runDialog()) {
            String newName = renameMethodDialog.getNewName();
            boolean searchInComments = renameMethodDialog.isSearchInComments();
            boolean searchInNonJavaFiles = renameMethodDialog.isSearchInNonJavaFiles();
            MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
            RenameMethodCriteria criteria = new RenameMethodCriteria(methodDescription, newName, searchInComments, searchInNonJavaFiles);
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            Util.setOperationHints(searchOperation, (JavaMember)sourceMethod, false);
            boolean preview = renameMethodDialog.hasPreview();
            searchOperation.runRefactoring(preview);
            runRefactor = true;
        }
        return runRefactor;
    }

    public static boolean canRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        return RenameController.canRenameMember(context, (JavaMember)sourceFieldVariable);
    }

    public static boolean whenRenameField(Context context, SourceMemberVariable sourceMemberVariable) {
        RenameFieldDialog renameToDialog;
        JavaType resolvedType;
        boolean runRefactor = false;
        SourceTypeReference sourceType = sourceMemberVariable.getSourceType();
        JavaType javaType = resolvedType = sourceType != null ? sourceType.getResolvedType() : sourceMemberVariable.getResolvedType();
        if (resolvedType != null && (renameToDialog = new RenameFieldDialog(context, sourceMemberVariable)).runDialog()) {
            String newName = renameToDialog.getNewName();
            boolean searchInComments = renameToDialog.isSearchInComments();
            boolean searchNonJavaFiles = renameToDialog.isSearchInNonJavaFiles();
            boolean preview = renameToDialog.hasPreview();
            RenameController.renameField(context, sourceMemberVariable, newName, searchInComments, searchNonJavaFiles, true, preview);
            runRefactor = true;
        }
        return runRefactor;
    }

    private static boolean whenRenameVariable(Context context, SourceVariable sourceVariable, SourceFile sourceFile) {
        boolean runRefactor = false;
        RenameVariableDialog renameVariableDialog = new RenameVariableDialog(context, sourceVariable);
        if (renameVariableDialog.runDialog()) {
            String newName = renameVariableDialog.getNewName();
            boolean searchInComments = renameVariableDialog.isSearchInComments();
            RenameVariableCriteria criteria = new RenameVariableCriteria(sourceVariable, sourceFile, newName, searchInComments);
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            boolean hasPreview = renameVariableDialog.hasPreview();
            searchOperation.runRefactoring(hasPreview);
            runRefactor = true;
        }
        return runRefactor;
    }

    public static boolean canRenamePackage() {
        return true;
    }

    public static boolean whenRenamePackage(Context context, JavaPackage javaPackage) {
        String oldPackageName;
        RenamePackageDialog renameToDialog;
        boolean runRefactor = false;
        if (RenameController.checkCanRenamePackage(context, javaPackage) && (renameToDialog = new RenamePackageDialog(context, oldPackageName = javaPackage.getName())).runDialog()) {
            String newPkgName = renameToDialog.getNewName();
            boolean searchInComments = renameToDialog.isSearchInComments();
            boolean searchInNonJavaFiles = renameToDialog.isSearchInNonJavaFiles();
            String shortTitle = MessageFormat.format(RefactoringArb.getString(246), oldPackageName);
            String longTitle = MessageFormat.format(RefactoringArb.getString(262), oldPackageName, newPkgName);
            MoveClassesCriteria moveClassesCriteria = new MoveClassesCriteria(searchInComments, searchInNonJavaFiles, longTitle, shortTitle);
            Project project = context.getProject();
            String oldPackagePath = oldPackageName.replace('.', '/');
            String newPackagePath = newPkgName.replace('.', '/');
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
            URLPath javaRootDirs = projectContent.getJavaRootDirs();
            URL[] entries = javaRootDirs.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL entry = entries[i];
                URL sourceUrl = URLFactory.newDirURL((URL)entry, (String)oldPackagePath);
                if (URLFileSystem.exists((URL)sourceUrl)) {
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    moveClassesCriteria.addDirectoryMove(javaManager, entry, oldPackagePath, project, entry, newPackagePath);
                }
                ++i;
            }
            MoveClassesOperation searchOperation = new MoveClassesOperation(context, moveClassesCriteria);
            boolean preview = renameToDialog.hasPreview();
            ((SearchOperationImpl)searchOperation).runRefactoring(preview);
            runRefactor = true;
        }
        return runRefactor;
    }

    private static boolean checkCanRenamePackage(Context context, JavaPackage javaPackage) {
        return MoveController.checkCanRefactorPackage(context, javaPackage, RefactoringArb.getString(312));
    }

    private static boolean canRenameMember(Context context, JavaMember javaMember) {
        JavaClass owningClass;
        SourceClass sourceClass;
        boolean ret = false;
        if (RenameController.canRename(context, (JavaElement)javaMember) && !(sourceClass = (SourceClass)(owningClass = javaMember.getOwningClass()).getSourceElement()).isAnonymous()) {
            ret = true;
        }
        return ret;
    }

    public static boolean renameField(Context context, SourceMemberVariable sourceFieldVariable, String newFieldName, boolean searchInComments, boolean searchNonJavaFiles, boolean renameAccessors, boolean preview) {
        SourceMethod getter = null;
        SourceMethod setter = null;
        MethodDescription getterDescription = null;
        MethodDescription setterDescription = null;
        String newGetterName = null;
        String newSetterName = null;
        if (renameAccessors) {
            String baseName = RenameController.getBaseName(sourceFieldVariable.getName());
            JavaClass owningClass = sourceFieldVariable.getOwningClass();
            JavaType resolvedType = sourceFieldVariable.getResolvedType();
            getter = RenameController.getGetter(owningClass, resolvedType, baseName);
            setter = RenameController.getSetter(owningClass, resolvedType, baseName);
            if (Ide.getIdeArgs().getCreateUI() && (getter != null || setter != null)) {
                int result = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(299), (String)RefactoringArb.getString(150), null);
                switch (result) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        getter = null;
                        setter = null;
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
            if (getter != null) {
                String getterName = getter.getName();
                String getterPrefix = getterName.substring(0, getterName.length() - baseName.length());
                newGetterName = getterPrefix + RenameController.getBaseName(newFieldName);
                getterDescription = new MethodDescription((JavaMethod)getter);
            }
            if (setter != null) {
                String setterName = setter.getName();
                String setterPrefix = setterName.substring(0, setterName.length() - baseName.length());
                newSetterName = setterPrefix + RenameController.getBaseName(newFieldName);
                setterDescription = new MethodDescription((JavaMethod)setter);
            }
        }
        FieldDescription fieldDescription = new FieldDescription((JavaField)sourceFieldVariable);
        RenameFieldCriteria criteria = new RenameFieldCriteria(fieldDescription, newFieldName, getterDescription, newGetterName, setterDescription, newSetterName, searchInComments, searchNonJavaFiles);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        ArrayList<Object> sourceMembers = new ArrayList<Object>();
        sourceMembers.add(sourceFieldVariable);
        if (getter != null) {
            sourceMembers.add(getter);
        }
        if (setter != null) {
            sourceMembers.add(setter);
        }
        JavaMember[] javaMembers = sourceMembers.toArray(new JavaMember[sourceMembers.size()]);
        Util.setOperationHints(searchOperation, javaMembers);
        boolean ret = searchOperation.runRefactoring(preview);
        return ret;
    }

    private static String getBaseName(String fieldName) {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        String fieldPrefix = codingStyleOptions.getFieldPrefix();
        String fieldSuffix = codingStyleOptions.getFieldSuffix();
        if (fieldPrefix != null && fieldName.startsWith(fieldPrefix)) {
            fieldName = fieldName.substring(fieldPrefix.length());
        }
        if (fieldSuffix != null && fieldName.endsWith(fieldSuffix)) {
            fieldName = fieldName.substring(0, fieldName.length() - fieldSuffix.length());
        }
        fieldName = Character.toUpperCase(fieldName.charAt(0)) + (fieldName.length() > 0 ? fieldName.substring(1) : "");
        return fieldName;
    }

    private static SourceMethod getGetter(JavaClass owningClass, JavaType javaType, String baseName) {
        if (javaType != null) {
            PrimitiveType booleanType = PrimitiveType.lookupPrimitive((String)"boolean");
            Collection declaredMethods = owningClass.getDeclaredMethods();
            for (JavaMethod javaMethod : declaredMethods) {
                JavaType returnType;
                String methodName;
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod == null || !(methodName = sourceMethod.getName()).endsWith(baseName) || !sourceMethod.getParameters().isEmpty() || !ModelUtil.areEqual((Object)(returnType = sourceMethod.getReturnType()), (Object)javaType)) continue;
                String[] prefixes = !booleanType.equals((Object)returnType) ? new String[]{"get"} : new String[]{"is", "has", "get"};
                int i = 0;
                while (i < prefixes.length) {
                    String prefix = prefixes[i];
                    if (methodName.startsWith(prefix) && methodName.length() == prefix.length() + baseName.length()) {
                        return sourceMethod;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private static SourceMethod getSetter(JavaClass owningClass, JavaType javaType, String baseName) {
        if (javaType != null) {
            PrimitiveType voidType = PrimitiveType.lookupPrimitive((String)"void");
            Collection declaredMethods = owningClass.getDeclaredMethods("set" + baseName);
            for (JavaMethod javaMethod : declaredMethods) {
                JavaType returnType;
                SourceVariable parameter;
                JavaType paramType;
                List sourceParameters;
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod == null || (sourceParameters = sourceMethod.getSourceParameters()).size() != 1 || !javaType.equals((Object)(paramType = (parameter = (SourceVariable)sourceParameters.get(0)).getResolvedType())) || !(returnType = sourceMethod.getReturnType()).equals((Object)voidType)) continue;
                return sourceMethod;
            }
        }
        return null;
    }

    public static void whenRenameUrl(Context context, URL url, boolean preview) {
        URL newUrl;
        URLChooser urlChooser = new URLChooser();
        DialogUtil.initURLChooser((URLChooser)urlChooser, (Context)context);
        urlChooser.setSelectedURL(url);
        URLFilter[] filters = urlChooser.getChooseableURLFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i].accept(url)) {
                urlChooser.setURLFilter(filters[i]);
            }
            ++i;
        }
        int returnVal = urlChooser.showSaveDialog((Component)Ide.getMainWindow(), "Rename File");
        if (returnVal == 0 && (newUrl = urlChooser.getSelectedURL()) != null) {
            RenameController.doRenameUrl(context, url, newUrl, preview);
        }
    }

    public static void doRenameUrl(Context context, URL oldUrl, URL newUrl, boolean preview) {
        MoveFilesCriteria moveFilesCriteria = new MoveFilesCriteria("Rename File", "Rename File");
        moveFilesCriteria.moveUrl(oldUrl, newUrl);
        MoveFilesOperation operation = new MoveFilesOperation(context, moveFilesCriteria);
        boolean ret = operation.runRefactoring(preview);
        Node node = context.getNode();
        if (!ret) {
            URLFileSystem.renameTo((URL)oldUrl, (URL)newUrl);
        }
    }
}

