/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public abstract class RenameDialog
extends BaseDialog {
    private static final int PREF_COMMENTS = 1;
    private static final int PREF_NON_JAVA_FILES = 2;
    private static final int PREF_PREVIEW = 4;
    protected JTextField _textField;
    private JCheckBox _searchInComments;
    private JCheckBox _searchNonJavaFiles;
    private JCheckBox _preview;

    public RenameDialog(Context context, String preferenceKey) {
        super(preferenceKey, context);
        this.init();
    }

    public String getNewName() {
        return this._textField.getText();
    }

    public boolean isSearchInComments() {
        return this._searchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchNonJavaFiles != null && this._searchNonJavaFiles.isSelected();
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.isSearchInComments());
        settings.setBit(2, this.isSearchInNonJavaFiles());
        settings.setBit(4, this.hasPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._textField;
    }

    protected int getDefaultPreferences() {
        return 2;
    }

    private void init() {
        JLabel renameToLbl = new JLabel();
        this._textField = new JTextField(30);
        this.updateOnChanges(this._textField);
        ResourceUtils.resLabel((JLabel)renameToLbl, (Component)this._textField, (String)RefactoringArb.getString(317));
        String commentsLabel = RefactoringArb.getString(337);
        String searchNonJavaFilesLabel = RefactoringArb.getString(323);
        String previewLabel = RefactoringArb.getString(41);
        this._searchInComments = new JCheckBox(StringUtils.stripMnemonic((String)commentsLabel));
        Util.setMnemonic(this._searchInComments, commentsLabel);
        if (this.useSearchNonJavaFiles()) {
            this._searchNonJavaFiles = new JCheckBox(StringUtils.stripMnemonic((String)searchNonJavaFilesLabel));
            Util.setMnemonic(this._searchNonJavaFiles, searchNonJavaFilesLabel);
        }
        this._preview = new JCheckBox(StringUtils.stripMnemonic((String)previewLabel));
        Util.setMnemonic(this._preview, previewLabel);
        JLabel message = new JLabel();
        message.setPreferredSize(this._preview.getPreferredSize());
        this.setMessageLabel(message);
        CopyableInteger data = this.getSettings();
        this._searchInComments.setSelected(data.isBitSet(1));
        if (this._searchNonJavaFiles != null) {
            this._searchNonJavaFiles.setSelected(data.isBitSet(2));
        }
        this._preview.setSelected(data.isBitSet(4));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)renameToLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._searchInComments, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        if (this._searchNonJavaFiles != null) {
            this.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    protected void setOldName(String oldName) {
        this._textField.setText(oldName);
        this._textField.setCaretPosition(0);
        this._textField.setSelectionEnd(oldName.length());
    }

    protected boolean useSearchNonJavaFiles() {
        return true;
    }
}

