/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.RefactoringArb;

public class RenameFileDialog
implements ActionListener,
ItemListener,
KeyListener {
    private JEWTDialog dialog;
    private JTextField _newName;
    private JCheckBox _updateReferences;
    private JCheckBox _searchInComments;
    private JCheckBox _searchOtherFileTypes;
    private JCheckBox _preview;
    private JButton _browseButton;
    private Context _context;
    private URL _url;
    private String _oldPathName;

    public RenameFileDialog(Context context, URL url) {
        this._context = context;
        this._url = url;
    }

    public boolean run() {
        JLabel newNameLabel = new JLabel();
        this._newName = new JTextField();
        ResourceUtils.resLabel((JLabel)newNameLabel, (Component)this._newName, (String)RefactoringArb.getString(268));
        this._newName.addKeyListener(this);
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)"&Browse");
        this._browseButton.addActionListener(this);
        this._updateReferences = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._updateReferences, (String)"Update &References");
        this._updateReferences.addItemListener(this);
        this._searchInComments = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchInComments, (String)RefactoringArb.getString(8));
        this._searchInComments.addItemListener(this);
        this._searchOtherFileTypes = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._searchOtherFileTypes, (String)RefactoringArb.getString(273));
        this._searchOtherFileTypes.addItemListener(this);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(260));
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)newNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        panel.add((Component)this._newName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        panel.add((Component)this._browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this._searchInComments, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this._searchOtherFileTypes, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this._preview, new GridBagConstraints(0, 3, 3, 1, 0.0, 1.0, 18, 0, insets, 0, 0));
        IdeMainWindow mainWindow = Ide.getMainWindow();
        this.dialog = new JEWTDialog((Frame)mainWindow, this.isDirectory() ? RefactoringArb.getString(238) : RefactoringArb.getString(208), 7);
        this.dialog.setContent((Component)panel);
        this.dialog.setOKButtonEnabled(false);
        this.dialog.setInitialFocus((Component)this._newName);
        this.dialog.setResizable(true);
        this.dialog.setPreferredSize(500, 200);
        String fileName = URLFileSystem.getPlatformPathName((URL)this._url);
        this._newName.setText(fileName);
        this._oldPathName = this._newName.getText();
        HelpUtils.setHelpID((JComponent)((JComponent)this.dialog.getContent()), (String)"f1_idedrenamefile_html");
        boolean ret = this.dialog.runDialog();
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._browseButton) {
            URL selectedURL;
            URLChooser urlChooser = new URLChooser();
            DialogUtil.initURLChooser((URLChooser)urlChooser, (Context)this._context);
            urlChooser.setSelectionScope(this.isDirectory() ? 1 : 0);
            int answer = urlChooser.showSaveDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(363));
            if (answer == 0 && (selectedURL = urlChooser.getSelectedURL()) != null) {
                String newName = URLFileSystem.getPlatformPathName((URL)selectedURL);
                this._newName.setText(newName);
            }
        }
    }

    private boolean isDirectory() {
        return URLFileSystem.isDirectory((URL)this._url);
    }

    public void itemStateChanged(ItemEvent e) {
    }

    @Deprecated
    public boolean isRefactoring() {
        return this._updateReferences.isSelected();
    }

    public boolean isPreview() {
        return this._preview.isSelected();
    }

    public String getNewName() {
        return this._newName.getText();
    }

    public boolean isSearchInComments() {
        return this._searchInComments.isSelected();
    }

    public boolean isSearchOtherFileTypes() {
        return this._searchOtherFileTypes.isSelected();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source.equals(this._newName) && this._oldPathName != null) {
            if (!this._oldPathName.equals(this._newName.getText())) {
                this.dialog.setOKButtonEnabled(true);
            } else {
                this.dialog.setOKButtonEnabled(false);
            }
        }
    }
}

