/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;

public class RenamePackageDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_PACKAGE_DEFAULTS";
    private String _oldPkgName;

    public RenamePackageDialog(Context context, String pkgName) {
        super(context, PREFERENCE_KEY);
        this._oldPkgName = pkgName;
        this.setOldName(pkgName);
        ClassPickerFactory.attach(this._textField, context, 2);
    }

    protected String getTitle() {
        return MessageFormat.format(RefactoringArb.getString(246), this._oldPkgName);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String text = this.getNewName();
            if (text.length() == 0) {
                isValid = false;
            } else if (this._oldPkgName.equals(text)) {
                isValid = false;
            } else if (text.endsWith(".")) {
                isValid = false;
            } else if (!NamingUtil.isPackageIdentifier((String)text)) {
                message = RefactoringArb.getString(84);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)text)) {
                message = RefactoringArb.getString(84);
                isValid = false;
            } else if (this.isPackageAlreadyPresent(text)) {
                message = MessageFormat.format(RefactoringArb.getString(207), text);
            } else if (RenamePackageDialog.hasUpperCase(text)) {
                message = RefactoringArb.getString(131);
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }

    private boolean isPackageAlreadyPresent(String text) {
        Context context = this.getContext();
        return RenamePackageDialog.isPackageAlreadyPresent(context, text);
    }

    public static boolean isPackageAlreadyPresent(Context context, String text) {
        Project project = context.getProject();
        URLPath sourcePath = PathsConfiguration.getInstance((Project)project).getSourcePath();
        for (URL url : sourcePath) {
            URL subURL = URLFactory.newURL((URL)url, (String)text);
            if (!URLFileSystem.exists((URL)subURL)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUpperCase(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

