/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename;

import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;

public class RenameVariableDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_VARIABLE_DEFAULTS";
    private SourceVariable _sourceVariable;

    public RenameVariableDialog(Context context, SourceVariable sourceVariable) {
        super(context, PREFERENCE_KEY);
        this._sourceVariable = sourceVariable;
        String nameBefore = this.getNameBefore();
        this.setOldName(nameBefore);
    }

    private String getNameBefore() {
        return this._sourceVariable.getName();
    }

    protected String getTitle() {
        return MessageFormat.format(RefactoringArb.getString(246), this.getNameBefore());
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String text = this.getNewName();
            if (text.length() == 0) {
                isValid = false;
            } else if (this.getNameBefore().equals(text)) {
                isValid = false;
            } else if (!NamingUtil.isJavaIdentifier((String)text)) {
                message = RefactoringArb.getString(73);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)text)) {
                message = RefactoringArb.getString(73);
                isValid = false;
            } else if (!VariableNaming.canIntroduceVariable((SourceElement)this._sourceVariable, text)) {
                message = MessageFormat.format(RefactoringArb.getString(190), text);
                isValid = false;
            } else if (Character.isUpperCase(text.charAt(0))) {
                message = RefactoringArb.getString(28);
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drenamevar_html";
    }

    protected boolean useSearchNonJavaFiles() {
        return false;
    }
}

