/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class RenameFieldDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_FIELD_DEFAULTS";
    private SourceMemberVariable _sourceMemberVariable;

    public RenameFieldDialog(Context context, SourceMemberVariable sourceMemberVariable) {
        super(context, PREFERENCE_KEY);
        this._sourceMemberVariable = sourceMemberVariable;
        String oldName = this._sourceMemberVariable.getName();
        this.setOldName(oldName);
    }

    protected String getTitle() {
        String oldFieldName = this._sourceMemberVariable.getName();
        String title = MessageFormat.format(RefactoringArb.getString(246), oldFieldName);
        return title;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String text = this.getNewName();
            if (text.length() == 0) {
                isValid = false;
            } else if (this._sourceMemberVariable.getName().equals(text)) {
                isValid = false;
            } else if (!NamingUtil.isJavaIdentifier((String)text)) {
                message = RefactoringArb.getString(252);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)text)) {
                message = RefactoringArb.getString(252);
                isValid = false;
            } else if (RenameFieldDialog.isFieldAlreadyPresent((JavaType)this._sourceMemberVariable.getEnclosingClass(), text)) {
                message = MessageFormat.format(RefactoringArb.getString(163), text);
                isValid = false;
            } else {
                boolean isConstant;
                boolean bl = isConstant = this._sourceMemberVariable.isStatic() && this._sourceMemberVariable.isFinal();
                if (isConstant) {
                    if (!NameValidation.isGoodConstantName(text)) {
                        message = RefactoringArb.getString(113);
                    }
                } else {
                    boolean isUppercase = Character.isUpperCase(text.charAt(0));
                    if (isUppercase) {
                        message = RefactoringArb.getString(336);
                    }
                }
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }

    private static boolean isFieldAlreadyPresent(JavaType fromClass, String fieldName) {
        if (RenameFieldDialog.isFieldAlreadyPresent(fromClass, fromClass, fieldName)) {
            return true;
        }
        Set hierarchy = fromClass.getHierarchy();
        for (JavaType javaType : hierarchy) {
            if (!RenameFieldDialog.isFieldAlreadyPresent(fromClass, javaType, fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldAlreadyPresent(JavaType fromClass, JavaType inClass, String fieldName) {
        Collection declaredFields = inClass.getDeclaredFields();
        for (JavaField javaField : declaredFields) {
            String inPackage;
            String fromPackage;
            if (!javaField.getName().equals(fieldName)) continue;
            int modifiers = javaField.getModifiers();
            if (BitField.isSet((int)modifiers, (int)1) || BitField.isSet((int)modifiers, (int)4)) {
                return true;
            }
            return BitField.isSet((int)modifiers, (int)2) ? fromClass == inClass : (fromPackage = fromClass.getPackageName()).equals(inPackage = inClass.getPackageName());
        }
        return false;
    }
}

