/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.search.Scope;

public class RenameFieldURLHandler
extends URLRefactoringHandler {
    public static final int USAGE_DEF = 201;
    public static final int USAGE_ACCESS = 202;
    public static final int USAGE_DOC_REF = 4;
    public static final int USAGE_COMMENT = 2000;

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483545: {
                RenameFieldCriteria criteria = (RenameFieldCriteria)searchCriteria;
                FieldDescription fieldDescription = criteria.getFieldDescription();
                MethodDescription getterDescription = criteria.getGetterDescription();
                MethodDescription setterDescription = criteria.getSetterDescription();
                ArrayList<Project> arrayList = new ArrayList<Project>();
                Project[] fieldProjects = RenameFieldURLHandler.getIncludedProjects(searchOperation, fieldDescription, Scope.createDummyScope());
                arrayList.addAll(Arrays.asList(fieldProjects));
                if (getterDescription != null) {
                    Project[] gettersProjects = RenameMethodURLHandler.getIncludedProjects(searchOperation, getterDescription, Scope.createDummyScope());
                    arrayList.addAll(Arrays.asList(gettersProjects));
                }
                if (setterDescription != null) {
                    Project[] settersProjects = RenameMethodURLHandler.getIncludedProjects(searchOperation, setterDescription, Scope.createDummyScope());
                    arrayList.addAll(Arrays.asList(settersProjects));
                }
                ret = arrayList.toArray(new Project[arrayList.size()]);
                break;
            }
            case 3: {
                SearchFieldCriteria fieldCriteria = (SearchFieldCriteria)searchCriteria;
                FieldDescription fieldDescription = fieldCriteria.getFieldDescription();
                Scope scope = fieldCriteria.getScope();
                ret = RenameFieldURLHandler.getIncludedProjects(searchOperation, fieldDescription, scope);
                break;
            }
        }
        return ret;
    }

    private static Project[] getIncludedProjects(SearchOperation searchOperation, FieldDescription fieldDescription, Scope scope) {
        Project[] ret;
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaField javaField = fieldDescription.getJavaField((JavaProvider)javaManager);
        if (javaField.isPrivate()) {
            ret = new Project[]{project};
        } else {
            JavaClass owningClass = javaField.getOwningClass();
            String fqClassName = owningClass.getQualifiedName();
            ret = RenameFieldURLHandler.getIncludedProjects(context, scope, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483545: {
                HashSet setterUrls;
                HashSet getterUrls;
                RenameFieldCriteria renameFieldCriteria = (RenameFieldCriteria)searchCriteria;
                MethodDescription getterDescription = renameFieldCriteria.getGetterDescription();
                MethodDescription setterDescription = renameFieldCriteria.getSetterDescription();
                String fqClassName = renameFieldCriteria.getFqClassName();
                String fieldName = renameFieldCriteria.getMemberNameBefore();
                Scope scope = Scope.createDummyScope();
                urls = RenameFieldURLHandler.chooseURLs(searchOperation, project, progressIndicator, fqClassName, fieldName, false, scope);
                if (getterDescription != null && (getterUrls = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, getterDescription, false, scope)) != null) {
                    urls.addAll(getterUrls);
                }
                if (setterDescription == null || (setterUrls = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, setterDescription, false, scope)) == null) break;
                urls.addAll(setterUrls);
                break;
            }
            case 3: {
                SearchFieldCriteria fieldCriteria = (SearchFieldCriteria)searchCriteria;
                String fqClassName = fieldCriteria.getFqClassName();
                String fieldName = fieldCriteria.getFieldName();
                Scope scope = fieldCriteria.getScope();
                urls = RenameFieldURLHandler.chooseURLs(searchOperation, project, progressIndicator, fqClassName, fieldName, fieldCriteria.isSearchInLibraries(), scope);
                break;
            }
        }
        return urls;
    }

    private static HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator, String fqClassName, String fieldName, boolean includeLibraries, Scope scope) {
        HashSet urls = null;
        urls = JavaURLHelper.getJavaURLsContaining(searchOperation, project, new String[]{fieldName}, includeLibraries, false, scope, progressIndicator);
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483545: {
                RenameFieldCriteria criteria = (RenameFieldCriteria)searchOperation.getCriteria();
                FieldDescription fieldDescription = criteria.getFieldDescription();
                MethodDescription getterDescription = criteria.getGetterDescription();
                MethodDescription setterDescription = criteria.getSetterDescription();
                usageModel = new UsageModel();
                UsageModel[] usageModels = new UsageModel[3];
                UsageModel fieldUsages = RenameFieldURLHandler.findUsages(project, urls, progressIndicator, fieldDescription, true);
                usageModel.addAll(fieldUsages);
                usageModels[0] = fieldUsages;
                if (getterDescription != null) {
                    UsageModel getterUsages = RenameMethodURLHandler.findUsages(project, urls, progressIndicator, getterDescription, true, true, criteria.isSearchInComments(), false, false, true);
                    usageModel.addAll(getterUsages);
                    usageModels[1] = getterUsages;
                }
                if (setterDescription != null) {
                    UsageModel setterUsages = RenameMethodURLHandler.findUsages(project, urls, progressIndicator, setterDescription, true, true, criteria.isSearchInComments(), false, false, true);
                    usageModel.addAll(setterUsages);
                    usageModels[2] = setterUsages;
                }
                searchOperation.setProperty(project.getLongLabel(), usageModels);
                break;
            }
            case 3: {
                SearchFieldCriteria searchFieldCriteria = (SearchFieldCriteria)searchOperation.getCriteria();
                FieldDescription fieldDescription = searchFieldCriteria.getFieldDescription();
                usageModel = RenameFieldURLHandler.findUsages(project, urls, progressIndicator, fieldDescription, searchFieldCriteria.isSearchInComments());
                break;
            }
        }
        return usageModel;
    }

    public static UsageModel findUsages(Project project, URL[] urls, ProgressIndicator progressIndicator, FieldDescription fieldDescription, boolean searchComments) {
        UsageModel usageModel = new UsageModel();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            String step = UsageArb.format(7, urls.length - i);
            progressIndicator.setProgressStepText(step);
            RenameFieldURLHandler.findUsages(project, url, fieldDescription, searchComments, usageModel);
            ++i;
        }
        return usageModel;
    }

    public static void findUsages(Project project, URL url, FieldDescription fieldDescription, boolean searchComments, UsageModel usageModel) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaField javaField = fieldDescription.getJavaField((JavaProvider)javaManager);
        SourceMemberVariable sourceFieldVariable = (SourceMemberVariable)javaField.getSourceElement();
        String fieldName = javaField.getName();
        Pattern pattern = null;
        SourceFile sourceFile = javaManager.getSourceFile(url);
        if (sourceFile != null) {
            List elements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{20, 66, 68});
            int j = 0;
            while (j < elements.size()) {
                SourceElement sourceElement = (SourceElement)elements.get(j);
                block0 : switch (sourceElement.getSymbolKind()) {
                    case 20: {
                        SourceName sourceName = (SourceName)sourceElement;
                        if (!fieldName.equals(sourceName.getName())) break;
                        SourceElement parent = sourceName.getParent();
                        switch (parent.getSymbolKind()) {
                            case 49: 
                            case 57: {
                                SourceExpression sourceExpression = (SourceExpression)parent;
                                JavaHasType resolvedObject = sourceExpression.getResolvedObject();
                                if (resolvedObject == null || !resolvedObject.equals(javaField)) break block0;
                                SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 202);
                                usageModel.addUsageEntry(entry);
                                break block0;
                            }
                            case 10: {
                                SourceFieldVariable field = (SourceFieldVariable)parent;
                                if (field == null || sourceFieldVariable == null || !field.equals(sourceFieldVariable)) break block0;
                                SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 201);
                                usageModel.addUsageEntry(entry);
                                break block0;
                            }
                            case 7: {
                                SourceEnumConstant enumConstant = (SourceEnumConstant)parent;
                                if (enumConstant == null || !enumConstant.equals(sourceFieldVariable)) break block0;
                                SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 201);
                                usageModel.addUsageEntry(entry);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 66: {
                        JavaHasType resolvedObject;
                        SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                        String text = sourceDocReference.getDocText();
                        if (text != null && text.endsWith(fieldName) && fieldDescription.equals(resolvedObject = sourceDocReference.getResolvedObject())) {
                            SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 4);
                            usageModel.addUsageEntry(entry);
                        }
                        elements.removeAll(sourceDocReference.getChildren());
                        break;
                    }
                    case 68: {
                        SourceDocTextFragment sourceDocTextFragment;
                        String text;
                        if (!searchComments || (text = (sourceDocTextFragment = (SourceDocTextFragment)sourceElement).getText()).indexOf(fieldName) == -1) break;
                        if (pattern == null) {
                            pattern = Pattern.compile("\\b(" + fieldName + ")\\b");
                        }
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            int from = matcher.start(1);
                            int to = matcher.end(1);
                            SourceElementEntry usageEntry = new SourceElementEntry(project, (SourceElement)sourceDocTextFragment, 2000);
                            SourceElementHandle sourceElementHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                            Object[] userObject = new Object[]{sourceElementHandle, new Integer(from), new Integer(to)};
                            usageEntry.setUserObject(userObject);
                            usageModel.addUsageEntry(usageEntry);
                        }
                        break;
                    }
                }
                ++j;
            }
        }
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        refactoringCommandSupport.setSearchOperation(searchOperation);
        RenameFieldCriteria criteria = (RenameFieldCriteria)searchOperation.getCriteria();
        String newMemberName = criteria.getMemberNameAfter();
        String fqClassName = criteria.getFieldDescription().getFqClassName();
        UsageModel[] usageModels = (UsageModel[])searchOperation.getProperty(project.getLongLabel());
        UsageModel fieldUsages = usageModels[0];
        UsageModel getterUsages = usageModels[1];
        UsageModel setterUsages = usageModels[2];
        try {
            MethodDescription setterDescription;
            ArrayList usageEntries = fieldUsages.getUsageEntries();
            MultiMap docTextFragments = new MultiMap();
            int i = 0;
            while (i < usageEntries.size()) {
                SourceElementEntry entry = (SourceElementEntry)usageEntries.get(i);
                if (entry.isIncluded()) {
                    SourceElement sourceElement = entry.getSourceElementOrThrow();
                    switch (entry.getUsageType()) {
                        case 201: {
                            SourceName sourceName = (SourceName)sourceElement;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            sourceName.setValue(newMemberName);
                            break;
                        }
                        case 202: {
                            SourceName sourceName = (SourceName)sourceElement;
                            SourceFactory factory = sourceName.getOwningSourceFile().getFactory();
                            SourceElement parent = sourceName.getParent();
                            if (parent.getSymbolKind() == 57) {
                                FieldDescription description = criteria.getFieldDescription();
                                JavaField field = description.getJavaField();
                                if (field.isStatic()) {
                                    CallerContext context = CallerContext.createContext((SourceElement)sourceElement);
                                    JavaHasType hasType = context.resolveExpressionName(newMemberName);
                                    if (field.equals(hasType)) {
                                        refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                                        sourceName.setValue(newMemberName);
                                        break;
                                    }
                                    SourceSimpleNameExpression lhs = factory.createSimpleNameExpression(field.getOwningClass().getName());
                                    SourceDotExpression dotExpr = factory.createDotReference((SourceExpression)lhs, newMemberName);
                                    refactoringCommandSupport.beginTransaction(parent);
                                    parent.replaceSelf((SourceElement)dotExpr);
                                    break;
                                }
                                CallerContext context = CallerContext.createContext((SourceElement)sourceElement);
                                JavaHasType hasType = context.resolveExpressionName(newMemberName);
                                if (field.equals(hasType)) {
                                    sourceName.setValue(newMemberName);
                                    break;
                                }
                                SourceSimpleNameExpression lhs = factory.createSimpleNameExpression("this");
                                SourceDotExpression dotExpr = factory.createDotReference((SourceExpression)lhs, newMemberName);
                                refactoringCommandSupport.beginTransaction(parent);
                                parent.replaceSelf((SourceElement)dotExpr);
                                break;
                            }
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                            sourceName.setValue(newMemberName);
                            break;
                        }
                        case 4: {
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocReference);
                            SourceFile owningSourceFile = sourceDocReference.getOwningSourceFile();
                            SourceFactory factory = owningSourceFile.getFactory();
                            SourceDocReference newSourceDocReference = factory.createDocMemberReference(fqClassName, newMemberName);
                            sourceDocReference.replaceSelf((SourceElement)newSourceDocReference);
                            break;
                        }
                        case 2000: {
                            Object[] userObjects = (Object[])entry.getUserObject();
                            SourceElementHandle sourceElementHandle = (SourceElementHandle)userObjects[0];
                            SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                            if (sourceDocTextFragment == null) break;
                            refactoringCommandSupport.beginTransaction((SourceElement)sourceDocTextFragment);
                            docTextFragments.add((Object)sourceDocTextFragment, (Object)userObjects);
                            break;
                        }
                    }
                }
                ++i;
            }
            RenameMethodURLHandler.renameMemberInComments(docTextFragments, newMemberName);
            MethodDescription getterDescription = criteria.getGetterDescription();
            if (getterDescription != null) {
                String newGetterName = criteria.getGetterNameAfter();
                RenameMethodURLHandler.doChanges(getterUsages, refactoringCommandSupport, getterDescription, newGetterName);
            }
            if ((setterDescription = criteria.getSetterDescription()) != null) {
                String newSetterName = criteria.getSetterNameAfter();
                RenameMethodURLHandler.doChanges(setterUsages, refactoringCommandSupport, setterDescription, newSetterName);
            }
            ret = refactoringCommandSupport.commit(searchOperation.getContext(), RefactoringArb.getString(150));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

