/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.oprs.rename.RenameDialog;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class RenameMethodDialog
extends RenameDialog {
    public static final String PREFERENCE_KEY = "RENAME_METHOD_DEFAULTS";
    private SourceMethod _sourceMethod;

    public RenameMethodDialog(Context context, SourceMethod sourceMethod) {
        super(context, PREFERENCE_KEY);
        this._sourceMethod = sourceMethod;
        String oldName = this._sourceMethod.getName();
        this.setOldName(oldName);
    }

    protected String getTitle() {
        String oldMethodName = this._sourceMethod.getName();
        String title = MessageFormat.format(RefactoringArb.getString(249), oldMethodName);
        return title;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String text = this.getNewName();
            if (this._sourceMethod.getName().equals(text)) {
                isValid = false;
            } else {
                NameValidation nameValidation = NameValidation.validateMethodForRename(this._sourceMethod, this.getNewName());
                message = nameValidation.getMessage();
                isValid = nameValidation.isValid();
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected String getHelpTopicID() {
        return "f1_jrf_drename_html";
    }
}

