/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.member;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ide.util.MultiMap;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.Scope;

public class RenameMethodURLHandler
extends URLRefactoringHandler {
    private static final int USAGE_SOURCE_NAME = 1000;
    private static final int USAGE_STATIC_IMPORT = 1001;
    private static final int USAGE_DOC_REFERENCE = 1002;
    private static final int USAGE_DOC_FRAGMENT = 1003;
    private static final int USAGE_ANNOTATION = 1004;

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483546: {
                RenameMethodCriteria criteria = (RenameMethodCriteria)searchCriteria;
                MethodDescription methodDescription = criteria.getMethodDescription();
                ret = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription, Scope.createDummyScope());
                break;
            }
            case 2: {
                SearchMethodCriteria criteria = (SearchMethodCriteria)searchCriteria;
                MethodDescription methodDescription = criteria.getMethodDescription();
                ret = RenameMethodURLHandler.getIncludedProjects(searchOperation, methodDescription, criteria.getScope());
                break;
            }
        }
        return ret;
    }

    static Project[] getIncludedProjects(SearchOperation searchOperation, MethodDescription methodDescription, Scope scope) {
        Project[] ret;
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
        if (javaMethod.isPrivate()) {
            ret = new Project[]{project};
        } else {
            String fqClassName = javaMethod.getOwningClass().getQualifiedName();
            ret = RenameMethodURLHandler.getIncludedProjects(context, scope, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483546: {
                RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchCriteria;
                MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
                urls = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription, false, Scope.createDummyScope());
                break;
            }
            case 2: {
                SearchMethodCriteria criteria = (SearchMethodCriteria)searchCriteria;
                MethodDescription methodDescription = criteria.getMethodDescription();
                urls = RenameMethodURLHandler.chooseUrls(searchOperation, project, progressIndicator, methodDescription, criteria.isSearchInLibraries(), criteria.getScope());
                break;
            }
        }
        return urls;
    }

    static HashSet chooseUrls(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean includeLibraries, Scope scope) {
        HashSet urls = null;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
        JavaClass owningClass = javaMethod.getOwningClass();
        String methodName = javaMethod.getName();
        String[] keywords = owningClass.isAnnotation() && "value".equals(methodName) ? new String[]{owningClass.getName()} : new String[]{methodName};
        urls = JavaURLHelper.getJavaURLsContaining(searchOperation, project, keywords, includeLibraries, false, scope, progressIndicator);
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483546: {
                RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchOperation.getCriteria();
                MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
                boolean includeComments = renameMethodCriteria.isSearchInComments();
                usageModel = RenameMethodURLHandler.findUsages(project, urls, progressIndicator, methodDescription, true, true, includeComments, false, false, true);
                break;
            }
            case 2: {
                SearchMethodCriteria criteria = (SearchMethodCriteria)searchOperation.getCriteria();
                MethodDescription methodDescription = criteria.getMethodDescription();
                boolean includeInvocation = criteria.isIncludeInvocation();
                boolean includeDeclaration = criteria.isIncludeDeclaration();
                boolean includeComments = criteria.isSearchInComments();
                boolean includeOverloaded = criteria.isOverloadedMethods();
                usageModel = RenameMethodURLHandler.findUsages(project, urls, progressIndicator, methodDescription, includeInvocation, includeDeclaration, includeComments, includeOverloaded, true, false);
                break;
            }
        }
        return usageModel;
    }

    static UsageModel findUsages(Project project, URL[] urls, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean includeInvocation, boolean includeDeclaration, boolean includeComments, boolean includeOverloaded, boolean includeOverridden, boolean includeSelf) {
        UsageModel usageModel = new UsageModel();
        int i = 0;
        while (i < urls.length && !progressIndicator.isUserCancelled()) {
            URL url = urls[i];
            String step = UsageArb.format(7, urls.length - i);
            progressIndicator.setProgressStepText(step);
            RenameMethodURLHandler.findUsages(project, url, methodDescription, includeInvocation, includeDeclaration, includeComments, includeOverloaded, includeOverridden, includeSelf, usageModel);
            ++i;
        }
        return usageModel;
    }

    public static void findUsages(Project project, URL url, MethodDescription methodDescription, boolean includeInvocation, boolean includeDeclaration, boolean includeComments, boolean includeOverloaded, boolean includeOverridden, boolean includeSelf, UsageModel usageModel) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
        String methodName = javaMethod.getName();
        Collection parameters = javaMethod.getParameters();
        JavaType[] parameterTypes = null;
        JavaClass owningClass = javaMethod.getOwningClass();
        HashSet knownInvalidMethods = new HashSet();
        HashSet<JavaMethod> knownMatchingMethods = new HashSet<JavaMethod>();
        if (includeOverloaded || includeOverridden) {
            Collection methods = owningClass.getMethods(methodName);
            if (!includeOverridden || !includeOverloaded) {
                parameterTypes = javaMethod.getParameterTypes();
            }
            for (JavaMethod method : methods) {
                if (!(includeOverridden && includeOverloaded || includeOverridden && CommonUtilities.matchMethod((JavaMethod)method, (JavaType[])parameterTypes)) && (!includeOverloaded || CommonUtilities.matchMethod((JavaMethod)method, (JavaType[])parameterTypes))) continue;
                knownMatchingMethods.add(method);
            }
        } else {
            knownMatchingMethods.add(javaMethod);
        }
        boolean isAnnotation = owningClass.isAnnotation();
        Pattern pattern = null;
        SourceFile sourceFile = javaManager.getSourceFile(url);
        if (sourceFile != null) {
            List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{20, 3, 14, 66, 68, 1});
            int j = 0;
            while (j < sourceElements.size()) {
                SourceElement sourceElement = (SourceElement)sourceElements.get(j);
                switch (sourceElement.getSymbolKind()) {
                    case 20: {
                        JavaMethod methodErasure;
                        JavaMethod resolvedMethod;
                        JavaHasType lhs;
                        SourceElement parent;
                        SourceName sourceName;
                        String thatName;
                        if (!includeInvocation || !methodName.equals(thatName = (sourceName = (SourceName)sourceElement).getName()) || (parent = sourceName.getParent()).getSymbolKind() != 53) break;
                        SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)parent;
                        if (!includeOverloaded && !javaMethod.isVarargs() && parameters.size() != sourceMethodCallExpression.getArgumentCount() || owningClass.isFinal() && (lhs = sourceMethodCallExpression.getResolvedLhs()) != null && !owningClass.getName().equals(lhs.getUnresolvedType().getSimplifiedName()) || (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) == null || !knownMatchingMethods.contains(methodErasure = resolvedMethod.getMethodErasure()) && !RenameMethodURLHandler.isSameMethod(methodErasure, knownMatchingMethods, knownInvalidMethods)) break;
                        SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                        entry.setUsageTypeCode(1);
                        usageModel.addUsageEntry(entry);
                        break;
                    }
                    case 3: {
                        SourceMethod sourceMethod;
                        JavaMethod thatMethod;
                        SourceClass sourceClass;
                        if (!includeDeclaration || !(sourceClass = (SourceClass)sourceElement).isSubtypeOf((JavaType)owningClass) || !includeSelf && sourceClass.equals((Object)owningClass)) break;
                        if (includeOverloaded) {
                            for (JavaMethod thatMethod2 : sourceClass.getMethods(methodName)) {
                                SourceMethod sourceMethod2 = (SourceMethod)thatMethod2.getSourceElement();
                                if (sourceMethod2 == null || !sourceClass.equals((Object)sourceMethod2.getOwningClass())) continue;
                                SourceName sourceName = sourceMethod2.getNameElement();
                                SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                                entry.setUsageTypeCode(0);
                                usageModel.addUsageEntry(entry);
                            }
                            break;
                        }
                        if (parameterTypes == null) {
                            parameterTypes = javaMethod.getParameterTypes();
                        }
                        if ((thatMethod = sourceClass.getMethod(methodName, parameterTypes)) == null || (sourceMethod = (SourceMethod)thatMethod.getSourceElement()) == null || !sourceClass.equals((Object)sourceMethod.getOwningClass())) break;
                        SourceName sourceName = sourceMethod.getNameElement();
                        SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 1000);
                        entry.setUsageTypeCode(0);
                        usageModel.addUsageEntry(entry);
                        break;
                    }
                    case 14: {
                        SourceName sourceName;
                        String name;
                        SourceImport sourceImport;
                        if (!includeInvocation || !(sourceImport = (SourceImport)sourceElement).isStatic() || !(name = (sourceName = sourceImport.getNameElement()).getName()).endsWith(methodName)) break;
                        sourceFile.compile();
                        Collection importedElements = sourceImport.getImportedElements();
                        for (JavaElement javaElement : importedElements) {
                            if (javaElement.getElementKind() != 8) continue;
                            JavaMethod importedMethod = (JavaMethod)javaElement;
                            boolean matchesMethod = includeOverloaded ? javaMethod.getName().equals(importedMethod.getName()) : importedMethod.equals((Object)javaMethod);
                            if (!matchesMethod) continue;
                            SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceName, 1001);
                            usageModel.addUsageEntry(entry);
                        }
                        break;
                    }
                    case 66: {
                        JavaMember resolvedMember;
                        SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                        String text = null;
                        try {
                            text = sourceDocReference.getText();
                        }
                        catch (ExpiredTextBufferException e) {
                            Assert.println((String)(sourceFile.getURL() + " textbuffer expired."));
                            text = "";
                        }
                        if (text.indexOf(methodName) != -1 && (resolvedMember = sourceDocReference.getResolvedMember()) != null && resolvedMember.getElementKind() == 8) {
                            JavaMethod resolvedMethod = (JavaMethod)resolvedMember;
                            if ((includeOverloaded || parameters.size() == resolvedMethod.getParameters().size()) && (knownMatchingMethods.contains(resolvedMethod) || RenameMethodURLHandler.isSameMethod(resolvedMethod, knownMatchingMethods, knownInvalidMethods))) {
                                SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 1002);
                                usageModel.addUsageEntry(entry);
                            }
                        }
                        sourceElements.removeAll(sourceDocReference.getChildren());
                        break;
                    }
                    case 68: {
                        SourceDocTextFragment sourceDocTextFragment;
                        String text;
                        if (!includeComments || (text = (sourceDocTextFragment = (SourceDocTextFragment)sourceElement).getText()).indexOf(methodName) == -1) break;
                        if (pattern == null) {
                            pattern = Pattern.compile("\\b(" + methodName + ")\\b");
                        }
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            int from = matcher.start(1);
                            int to = matcher.end(1);
                            int startOffset = sourceDocTextFragment.getStartOffset();
                            UsageEntry usageEntry = new UsageEntry(project, url, startOffset + from, to - from, 1003, 1);
                            SourceElementHandle docTextFragmentHandle = new SourceElementHandle((SourceElement)sourceDocTextFragment);
                            Object[] userObject = new Object[]{docTextFragmentHandle, new Integer(from), new Integer(to)};
                            usageEntry.setUserObject(userObject);
                            usageModel.addUsageEntry(usageEntry);
                        }
                        break;
                    }
                    case 1: {
                        if (!isAnnotation) break;
                        SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                        SourceListExpression argumentList = sourceAnnotation.getArgumentList();
                        List children = argumentList.getChildren();
                        int k = 0;
                        while (k < children.size()) {
                            SourceExpression sourceExpression = (SourceExpression)children.get(k);
                            switch (sourceExpression.getSymbolKind()) {
                                case 48: {
                                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression;
                                    SourceExpression firstOperand = sourceAssignmentExpression.getFirstOperand();
                                    if (firstOperand == null || !methodName.equals(firstOperand.getText())) break;
                                    SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceExpression, 1004);
                                    usageModel.addUsageEntry(entry);
                                    break;
                                }
                                default: {
                                    if (!"value".equals(methodName)) break;
                                    SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceExpression, 1004);
                                    usageModel.addUsageEntry(entry);
                                    break;
                                }
                            }
                            ++k;
                        }
                        break;
                    }
                }
                ++j;
            }
        }
    }

    private static boolean isSameMethod(JavaMethod foundMethod, HashSet knownMatchingMethods, HashSet knownInvalidMethods) {
        if (knownMatchingMethods.contains(foundMethod.getSourceElement())) {
            return true;
        }
        if (!knownInvalidMethods.contains(foundMethod)) {
            Collection overriddenMethods = foundMethod.getOverriddenMethods();
            for (JavaMethod overriddenMethod : overriddenMethods) {
                if (!knownMatchingMethods.contains(overriddenMethod)) continue;
                knownMatchingMethods.add(foundMethod);
                return true;
            }
            knownInvalidMethods.addAll(overriddenMethods);
        }
        return false;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        RenameMethodCriteria renameMethodCriteria = (RenameMethodCriteria)searchCriteria;
        MethodDescription methodDescription = renameMethodCriteria.getMethodDescription();
        String memberNameAfter = renameMethodCriteria.getMemberNameAfter();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            RenameMethodURLHandler.doChanges(usageModel, refactoringCommandSupport, methodDescription, memberNameAfter);
            refactoringCommandSupport.setSearchOperation(searchOperation);
            Context context = searchOperation.getContext();
            ret = refactoringCommandSupport.commit(context, RefactoringArb.getString(137));
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    static void doChanges(UsageModel usageModel, RefactoringCommandSupport refactoringCommandSupport, MethodDescription methodDescription, String memberNameAfter) {
        String fqClassName = methodDescription.getFqClassName();
        ArrayList usageEntries = usageModel.getUsageEntries();
        MultiMap docTextFragments = new MultiMap();
        int i = 0;
        while (i < usageEntries.size()) {
            BaseUsageEntry baseUsageEntry = (BaseUsageEntry)usageEntries.get(i);
            if (baseUsageEntry.isIncluded()) {
                block0 : switch (baseUsageEntry.getUsageType()) {
                    case 1000: {
                        SourceElementEntry entry = (SourceElementEntry)baseUsageEntry;
                        SourceName sourceName = (SourceName)entry.getSourceElementOrThrow();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                        sourceName.setText(memberNameAfter);
                        break;
                    }
                    case 1001: {
                        SourceElementEntry entry = (SourceElementEntry)baseUsageEntry;
                        SourceName sourceName = (SourceName)entry.getSourceElementOrThrow();
                        refactoringCommandSupport.beginTransaction((SourceElement)sourceName);
                        sourceName.setText(fqClassName + '.' + memberNameAfter);
                        break;
                    }
                    case 1002: {
                        SourceElementEntry entry = (SourceElementEntry)baseUsageEntry;
                        SourceDocReference sourceDocReference = (SourceDocReference)entry.getSourceElementOrThrow();
                        SourceFile owningSourceFile = sourceDocReference.getOwningSourceFile();
                        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                        SourceFactory factory = owningSourceFile.getFactory();
                        SourceDocReference newSourceDocReference = factory.createDocReference(fqClassName, memberNameAfter, methodDescription.getParameterTypes());
                        sourceDocReference.replaceSelf((SourceElement)newSourceDocReference);
                        break;
                    }
                    case 1003: {
                        UsageEntry usageEntry = (UsageEntry)baseUsageEntry;
                        Object userObject = usageEntry.getUserObject();
                        Object[] userObjects = (Object[])userObject;
                        SourceElementHandle sourceElementHandle = (SourceElementHandle)userObjects[0];
                        SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElementHandle.getElement();
                        if (sourceDocTextFragment == null) break;
                        docTextFragments.add((Object)sourceDocTextFragment, (Object)userObjects);
                        break;
                    }
                    case 1004: {
                        SourceElementEntry entry = (SourceElementEntry)baseUsageEntry;
                        SourceExpression sourceExpression = (SourceExpression)entry.getSourceElementOrThrow();
                        SourceFile owningSourceFile = sourceExpression.getOwningSourceFile();
                        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                        SourceFactory factory = owningSourceFile.getFactory();
                        SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(memberNameAfter);
                        switch (sourceExpression.getSymbolKind()) {
                            case 48: {
                                SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)sourceExpression;
                                SourceExpression firstOperand = sourceAssignmentExpression.getFirstOperand();
                                if ("value".equals(memberNameAfter)) {
                                    SourceExpression secondOperand = sourceAssignmentExpression.getSecondOperand();
                                    SourceElement exprClone = secondOperand.cloneSelf(owningSourceFile);
                                    sourceExpression.replaceSelf(exprClone);
                                    break block0;
                                }
                                firstOperand.replaceSelf((SourceElement)simpleNameExpression);
                                break block0;
                            }
                        }
                        SourceExpression exprClone = (SourceExpression)sourceExpression.cloneSelf(owningSourceFile);
                        SourceAssignmentExpression assignment = factory.createAssignment(6, (SourceExpression)simpleNameExpression, exprClone);
                        sourceExpression.replaceSelf((SourceElement)assignment);
                        break;
                    }
                }
            }
            ++i;
        }
        RenameMethodURLHandler.renameMemberInComments(docTextFragments, memberNameAfter);
    }

    static void renameMemberInComments(MultiMap docTextFragments, String memberNameAfter) {
        Set keys = docTextFragments.keySet();
        for (SourceDocTextFragment sourceDocTextFragment : keys) {
            String oldText = sourceDocTextFragment.getText();
            StringBuffer newText = new StringBuffer(oldText);
            List userObjects = docTextFragments.get((Object)sourceDocTextFragment);
            Collections.sort(userObjects, new 1());
            int i = 0;
            while (i < userObjects.size()) {
                Object[] objects = (Object[])userObjects.get(i);
                int from = (Integer)objects[1];
                int to = (Integer)objects[2];
                newText.replace(from, to, memberNameAfter);
                ++i;
            }
            SourceFile owningSourceFile = sourceDocTextFragment.getOwningSourceFile();
            SourceFactory factory = owningSourceFile.getFactory();
            SourceDocTextFragment newDocTextFragment = factory.createDocTextFragment(newText.toString());
            sourceDocTextFragment.replaceSelf((SourceElement)newDocTextFragment);
        }
    }

    public static UsageModel searchMethod(Project project, URL[] urls, ProgressIndicator progressIndicator, MethodDescription methodDescription, boolean includeComments) {
        return RenameMethodURLHandler.findUsages(project, urls, progressIndicator, methodDescription, true, true, includeComments, false, false, true);
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Object[] objects1 = (Object[])o1;
            Object[] objects2 = (Object[])o2;
            int from1 = (Integer)objects1[1];
            int from2 = (Integer)objects2[1];
            return from2 - from1;
        }
    }
}

