/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.rename.variable;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.criteria.RenameVariableCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchVariableCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;

public class FindRenameVariableURLHandler
extends TextChangeBasedRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 6 || searchType == -2147483542) {
            Context context = searchOperation.getContext();
            Project project = context.getProject();
            ret = new Project[]{project};
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet<URL> urls = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation)) {
            URL url = this.getURL(searchOperation);
            urls = new HashSet<URL>(1);
            urls.add(url);
        }
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        SearchVariableCriteria criteria;
        UsageModel ret = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation) && (criteria = (SearchVariableCriteria)searchOperation.getCriteria()).isValid()) {
            SourceBlock sourceBlock;
            boolean isParameter;
            ret = new UsageModel();
            SourceVariable sourceVariable = criteria.getVariable();
            String variableName = sourceVariable.getName();
            boolean bl = isParameter = sourceVariable.getSymbolKind() == 13;
            if (isParameter) {
                SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
                sourceBlock = sourceMethod.getBlock();
                SourceDocComment docComment = sourceMethod.getDocComment();
                if (docComment != null) {
                    Collection inlineTags = docComment.findTags("@param");
                    for (SourceDocTag sourceDocTag : inlineTags) {
                        String parameterName;
                        SourceDocReference sourceDocReference;
                        if (!sourceDocTag.isParameter() || (sourceDocReference = sourceDocTag.getReference()) == null || !variableName.equals(parameterName = sourceDocReference.getParameterName())) continue;
                        SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceDocReference, 0);
                        ret.addUsageEntry(entry);
                    }
                }
            } else {
                sourceBlock = (SourceBlock)Util.getAncestorOfClass(SourceBlock.class, (SourceElement)sourceVariable);
            }
            if (sourceBlock != null) {
                List simpleNameExprs = SourceElementAsList.asList((SourceElement)sourceBlock, (int)57);
                for (SourceSimpleNameExpression sourceSimpleNameExpression : simpleNameExprs) {
                    JavaHasType resolvedObject;
                    String name = sourceSimpleNameExpression.getName();
                    if (!variableName.equals(name) || (resolvedObject = sourceSimpleNameExpression.getResolvedObject()) == null || !resolvedObject.equals(sourceVariable)) continue;
                    SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)sourceSimpleNameExpression, 1);
                    ret.addUsageEntry(entry);
                }
            }
            URL url = urls[0];
            if (criteria.isSearchInComments()) {
                int startOffset = sourceBlock.getStartOffset();
                int endOffset = sourceBlock.getEndOffset();
                this.scanComments(project, url, variableName, ret, startOffset, endOffset);
            }
            SourceName nameElement = sourceVariable.getNameElement();
            SourceElementEntry entry = new SourceElementEntry(project, (SourceElement)nameElement, 0);
            ret.addUsageEntry(entry);
        }
        return ret;
    }

    private void scanComments(Project project, URL url, String variableName, UsageModel usageModel, int startOffset, int endOffset) {
        Node node = NodeFactory.find((URL)url);
        if (node instanceof TextNode) {
            int tokenValue;
            Pattern pattern = Pattern.compile("\\b" + variableName + "\\b");
            TextNode textNode = (TextNode)node;
            JavaLexer javaLexer = new JavaLexer();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
            LexerToken lexerToken = javaLexer.createLexerToken();
            block3: while ((tokenValue = javaLexer.lex(lexerToken)) != 0) {
                switch (tokenValue) {
                    case 24: 
                    case 25: 
                    case 26: {
                        int tokenStart = lexerToken.getStartOffset();
                        int tokenEnd = lexerToken.getEndOffset();
                        if (startOffset > tokenStart || tokenEnd > endOffset) continue block3;
                        String text = textBuffer.getString(tokenStart, tokenEnd - tokenStart);
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            int start = matcher.start();
                            int end = matcher.end();
                            UsageEntry usageEntry = new UsageEntry(project, url, tokenStart + start, end - start, 0, 2);
                            usageModel.addUsageEntry(usageEntry);
                        }
                        continue block3;
                    }
                }
            }
        }
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] ret = null;
        if (FindRenameVariableURLHandler.isMyType(searchOperation)) {
            RenameVariableCriteria criteria = (RenameVariableCriteria)searchOperation.getCriteria();
            ArrayList textChanges = TextURLHandler.genericRename(usageModel, criteria.getVariableName(), criteria.getNewVariableName());
            ret = textChanges.toArray(new RefactoringChange[textChanges.size()]);
        }
        return ret;
    }

    private static boolean isMyType(SearchOperation searchOperation) {
        boolean ret = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 6 || searchType == -2147483542) {
            ret = true;
        }
        return ret;
    }

    private URL getURL(SearchOperation searchOperation) {
        SearchVariableCriteria criteria = (SearchVariableCriteria)searchOperation.getCriteria();
        SourceFile sourceFile = criteria.getSourceFile();
        URL url = sourceFile.getURL();
        return url;
    }
}

