/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.replacectorwithmethod;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.replacectorwithmethod.ReplaceCtorWithMethodDialog;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class ReplaceCtorWithMethodController
implements Controller {
    private static final boolean HAS_BUG_CCTOR_NOT_SIMPLIFIED = true;
    private static final String OPR_TITLE = RefactoringArb.getString(50);

    public boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        ElementAt elementAt;
        boolean ret = false;
        if (context != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            switch (elementAt.getElementType()) {
                case 2: {
                    SourceMethod sourceMethod;
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    if (javaMethod == null || (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) == null || !Util.canRefactor((SourceElement)sourceMethod)) break;
                    ret = true;
                    if (!doit) break;
                    this.handle(context, sourceMethod);
                }
            }
        }
        return ret;
    }

    private void handle(Context context, SourceMethod ctor) {
        SourceClass sourceClass = ctor.getEnclosingClass();
        if (!sourceClass.isAbstract()) {
            if (sourceClass.getOwningClass() == null) {
                ReplaceCtorWithMethodDialog dialog = new ReplaceCtorWithMethodDialog(context, ctor);
                if (dialog.runDialog()) {
                    String methodName = dialog.getMethodName();
                    UsageModel usageModel = new UsageModel();
                    Project project = context.getProject();
                    MyJotUsageListener usageListener = new MyJotUsageListener(project, usageModel);
                    FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember)ctor);
                    findMemberUsages.findMemberUsages(project, usageListener);
                    boolean makeCtorPrivate = true;
                    if (MyJotUsageListener.ra$_hasAnonymousClassUsages(usageListener)) {
                        String message = MessageFormat.format("{0} is extended by anonymous classes which will not be transformed to use the factory method ", sourceClass.getQualifiedName());
                        int anonymousConfirmation = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, OPR_TITLE, 2, 2);
                        if (anonymousConfirmation == 2) {
                            usageModel.release();
                            return;
                        }
                        makeCtorPrivate = false;
                    }
                    RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
                    try {
                        this.createFactoryMethod(refactoringCommandSupport, ctor, methodName, (JavaClass)sourceClass);
                        if (makeCtorPrivate) {
                            this.modifyCtor(ctor);
                        }
                        this.replaceUsages(refactoringCommandSupport, usageModel, methodName, (JavaClass)sourceClass);
                        usageModel.release();
                        refactoringCommandSupport.commit(context, OPR_TITLE);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        refactoringCommandSupport.abort();
                    }
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(112), OPR_TITLE, 0);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), RefactoringArb.getString(204), OPR_TITLE, 0);
        }
    }

    private void replaceUsages(RefactoringCommandSupport refactoringCommandSupport, UsageModel usageModel, String methodName, JavaClass owningClass) {
        ArrayList usageEntries = usageModel.getUsageEntries();
        int i = 0;
        while (i < usageEntries.size()) {
            UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)usageEntry.getUserObject();
                SourceFile owningSourceFile = sourceClassCreatorExpression.getOwningSourceFile();
                refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                SourceFactory factory = owningSourceFile.getFactory();
                String qualifiedName = owningClass.getQualifiedName();
                SourceExpression classAccessExpression = factory.createExpression(qualifiedName);
                SourceListExpression ctorArgList = sourceClassCreatorExpression.getArgumentList();
                SourceListExpression methodArgList = (SourceListExpression)ctorArgList.cloneSelf(owningSourceFile);
                SourceMethodCallExpression methodCall = factory.createMethodCall(classAccessExpression, methodName, methodArgList);
                sourceClassCreatorExpression.replaceSelf((SourceElement)methodCall);
            }
            ++i;
        }
    }

    private void modifyCtor(SourceMethod ctor) {
        ctor.removeModifiers(5);
        ctor.addModifiers(2);
    }

    private void createFactoryMethod(RefactoringCommandSupport refactoringCommandSupport, SourceMethod ctor, String methodName, JavaClass owningJavaClass) {
        SourceClass owningSourceClass = (SourceClass)owningJavaClass.getSourceElement();
        SourceFile owningSourceFile = owningSourceClass.getOwningSourceFile();
        refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
        SourceFactory factory = owningSourceFile.getFactory();
        SourceTypeReference creatorType = factory.createType(owningSourceClass.getQualifiedName());
        SourceFormalParameterList ctorFormalParameters = ctor.getFormalParameterList();
        SourceBlock sourceBlock = factory.createBlock();
        List sourceParameters = ctorFormalParameters.getSourceParameters();
        SourceExpression[] arguments = new SourceExpression[sourceParameters.size()];
        int i = 0;
        while (i < sourceParameters.size()) {
            SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
            String parameterName = sourceVariable.getName();
            SourceSimpleNameExpression simpleNameExpression = factory.createSimpleNameExpression(parameterName);
            arguments[i] = simpleNameExpression;
            ++i;
        }
        SourceTypeReference ctorType = factory.createType(owningSourceClass.getName());
        SourceNewClassExpression classCreatorExpression = factory.createNewClassExpression(null, ctorType, factory.createArgumentList(arguments), null);
        SourceReturnStatement returnStatement = factory.createReturnStatement((SourceExpression)classCreatorExpression);
        returnStatement.addSelf((SourceElement)sourceBlock);
        SourceTypeReference returnSourceType = (SourceTypeReference)creatorType.cloneSelf(owningSourceFile);
        SourceFormalParameterList factoryFormalParameters = (SourceFormalParameterList)ctorFormalParameters.cloneSelf(owningSourceFile);
        SourceThrowsClause throwsClause = (SourceThrowsClause)ctor.getThrowsClause().cloneSelf(owningSourceFile);
        SourceMethod factoryMethod = factory.createMethod(returnSourceType, methodName, factoryFormalParameters, throwsClause, sourceBlock);
        int accessModifiers = ctor.getModifiers() & 7;
        factoryMethod.setModifiers(accessModifiers | 8);
        factoryMethod.addSelfAfter((SourceElement)ctor);
    }

    private static class MyJotUsageListener
    extends FindMemberUsages.JotUsageListener {
        private boolean _hasAnonymousClassUsages;
        private final Project _project;
        private final UsageModel _usageModel;

        public MyJotUsageListener(Project project, UsageModel usageModel) {
            this._project = project;
            this._usageModel = usageModel;
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
            SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)sourceInvokeExpression;
            SourceClass anonymousClass = sourceClassCreatorExpression.getAnonymousClass();
            if (anonymousClass != null) {
                this._hasAnonymousClassUsages = true;
            } else {
                UsageEntry usageEntry = new UsageEntry(this._project, (SourceElement)sourceInvokeExpression, 0, 2);
                usageEntry.setUserObject(sourceInvokeExpression);
                this._usageModel.addUsageEntry(usageEntry);
            }
        }

        static boolean ra$_hasAnonymousClassUsages(MyJotUsageListener myJotUsageListener) {
            return myJotUsageListener._hasAnonymousClassUsages;
        }
    }
}

