/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.replacectorwithmethod;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class ReplaceCtorWithMethodDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "REP_CTOR_WITH_MTD_PRF";
    private JTextField _methodName;
    private SourceMethod _ctor;

    public ReplaceCtorWithMethodDialog(Context context, SourceMethod ctor) {
        super(PREFERENCE_KEY, context);
        this._ctor = ctor;
        this.init();
    }

    private void init() {
        JLabel label = new JLabel();
        this._methodName = new JTextField(40);
        this.updateOnChanges(this._methodName);
        JavaClass owningClass = this._ctor.getOwningClass();
        String owningClassName = owningClass.getName();
        String methodName = "create" + owningClassName;
        this._methodName.setText(methodName);
        ResourceUtils.resLabel((JLabel)label, (Component)this._methodName, (String)RefactoringArb.getString(289));
        JLabel message = new JLabel();
        message.setPreferredSize(label.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._methodName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._methodName;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dconsttofactorymeth_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(72);
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String methodName = this.getMethodName();
            NameValidation nameValidation = NameValidation.validateMethod(this._ctor, methodName);
            boolean isValid = nameValidation.isValid();
            String message = nameValidation.getMessage();
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    public String getMethodName() {
        return this._methodName.getText();
    }
}

