/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.OrderedProperties;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public class ResourceCommand
extends Command {
    private SourceLiteralExpression _sourceLiteralExpression;
    private URL _resUrl;
    private String _resName;
    private String _resString;
    private OrderedProperties _properties;
    private UndoableEdit[] _undoableEdits;
    private final Node[] _affectedNodes;

    private void $init$() {
        this._affectedNodes = new Node[2];
    }

    public ResourceCommand(Context context, SourceLiteralExpression sourceLiteralExpression, URL resUrl, String resName, String resString, OrderedProperties properties) throws IllegalAccessException, InstantiationException {
        super(-1, 3, "Resource Bundle Change");
        this.$init$();
        this.setContext(context);
        this._sourceLiteralExpression = sourceLiteralExpression;
        this._resUrl = resUrl;
        this._resName = resName;
        this._resString = resString;
        this._properties = properties;
        this._affectedNodes[0] = NodeFactory.findOrCreate((URL)this._resUrl);
        this._affectedNodes[1] = NodeFactory.findOrCreate((URL)sourceLiteralExpression.getOwningSourceFile().getURL());
    }

    public int doit() throws Exception {
        if (this._undoableEdits == null) {
            this._undoableEdits = new UndoableEdit[3];
            this.updateJavaFile();
            this.updateProperties();
            this._sourceLiteralExpression = null;
            this._resUrl = null;
            this._resName = null;
            this._resString = null;
            this._properties = null;
        } else {
            int i = 0;
            while (i < this._undoableEdits.length) {
                UndoableEdit undoableEdit = this._undoableEdits[i];
                undoableEdit.redo();
                ++i;
            }
        }
        return 0;
    }

    public int undo() throws Exception {
        int i = this._undoableEdits.length - 1;
        while (i >= 0) {
            UndoableEdit undoableEdit = this._undoableEdits[i];
            undoableEdit.undo();
            --i;
        }
        return 0;
    }

    private void updateJavaFile() {
        Project project = this.getContext().getProject();
        ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        URL resDirectory = URLFileSystem.getParent((URL)this._resUrl);
        String resPkg = allContents.toRelativePath(resDirectory).replace('/', '.');
        String resFileName = URLFileSystem.getFileName((URL)this._resUrl);
        String className = resFileName.substring(0, resFileName.indexOf(46));
        String fqClassName = resPkg + className;
        SourceFile owningSourceFile = this._sourceLiteralExpression.getOwningSourceFile();
        SourceTransaction sourceTransaction = owningSourceFile.beginTransaction();
        SourceFactory factory = owningSourceFile.getFactory();
        SourceTypeExpression typeExpression1 = factory.createTypeExpression(fqClassName);
        SourceTypeExpression typeExpression2 = factory.createTypeExpression(fqClassName);
        SourceDotExpression fieldAccess = factory.createDotReference((SourceExpression)typeExpression2, this._resName);
        SourceMethodCallExpression methodCall = factory.createMethodCall((SourceExpression)typeExpression1, "getString", factory.createArgumentList((SourceExpression)fieldAccess));
        this._sourceLiteralExpression.replaceSelf((SourceElement)methodCall);
        this._undoableEdits[0] = sourceTransaction.commit();
    }

    private void updateProperties() throws IOException, IllegalAccessException, InstantiationException {
        this._properties.setProperty(this._resName, this._resString);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._properties.store((OutputStream)byteArrayOutputStream, null);
        byteArrayOutputStream.close();
        String textAfter = byteArrayOutputStream.toString();
        TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)this._resUrl);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        this._undoableEdits[1] = textBuffer.removeToEnd(0);
        this._undoableEdits[2] = textBuffer.insert(0, textAfter.toCharArray());
    }

    public Node[] getAffectedNodes() {
        return this._affectedNodes;
    }
}

