/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.OrderedProperties;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.refactoring.oprs.resbundle.ResourceCommand;
import oracle.jdevimpl.refactoring.oprs.resbundle.ResourceDialog;

public class ResourceController
implements Controller {
    private static final String TITLE = "Introduce Resource";

    public boolean update(IdeAction action, Context context) {
        boolean canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        boolean ret = false;
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            Node node = context.getNode();
            if (node instanceof JavaSourceNode) {
                SourceLiteralExpression sourceLiteralExpression;
                String text;
                URL url = node.getURL();
                int caretPosition = codeEditor.getCaretPosition();
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                SourceFile sourceFile = javaManager.getSourceFile(url);
                SourceElement sourceElement = sourceFile.getElementAt(caretPosition);
                if (sourceElement instanceof SourceLiteralExpression && (text = (sourceLiteralExpression = (SourceLiteralExpression)sourceElement).getText()).startsWith("\"") && text.endsWith("\"")) {
                    ret = true;
                    if (doit) {
                        this.whenResource(context, sourceLiteralExpression);
                    }
                }
            }
        }
        return ret;
    }

    private void whenResource(Context context, SourceLiteralExpression sourceLiteralExpression) {
        boolean tryAgain;
        ResourceDialog resourceDialog = new ResourceDialog(context, sourceLiteralExpression);
        do {
            boolean isContained;
            tryAgain = false;
            if (!resourceDialog.runDialog(context, sourceLiteralExpression)) continue;
            URL resUrl = resourceDialog.getResUrl();
            String resName = resourceDialog.getResName();
            String resString = resourceDialog.getResString();
            Project project = context.getProject();
            ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            String relativePath = allContents.toRelativePath(resUrl);
            boolean bl = isContained = relativePath != null;
            if (isContained) {
                OrderedProperties properties = this.getProperties(resUrl);
                if (properties.getProperty(resName) != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(resName + " already exists."), (String)TITLE, null);
                    tryAgain = true;
                    continue;
                }
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    ResourceCommand resourceCommand = new ResourceCommand(context, sourceLiteralExpression, resUrl, resName, resString, properties);
                    commandProcessor.invoke((Command)resourceCommand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)(URLFileSystem.getPlatformPathName((URL)resUrl) + " must part of the project."), (String)TITLE, null);
            tryAgain = true;
        } while (tryAgain);
    }

    private OrderedProperties getProperties(URL resUrl) {
        OrderedProperties ret = null;
        try {
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)resUrl);
            TextBuffer textBuffer = node.acquireTextBuffer();
            String buffer = textBuffer.getString(0, textBuffer.getLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.getBytes());
            OrderedProperties properties = new OrderedProperties();
            properties.load((InputStream)byteArrayInputStream);
            ret = properties;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

