/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.resbundle;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.UpperCaseTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;

class ResourceDialog
extends JPanel {
    private static final HashMap _registry = new HashMap();
    private Context _context;
    private SourceLiteralExpression _sourceLiteralExpression;
    private JComboBox _resCombo;
    private JTextField _nameField;
    private JTextField _strField;
    private static String _lastPlatformName;

    public ResourceDialog(Context context, SourceLiteralExpression sourceLiteralExpression) {
        super(new GridBagLayout());
        this._context = context;
        this._sourceLiteralExpression = sourceLiteralExpression;
        this.init();
    }

    public boolean runDialog(Context context, SourceLiteralExpression sourceLiteralExpression) {
        boolean ret = false;
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), "Resource String", 3);
        dialog.setContent((Component)this);
        dialog.setInitialFocus((Component)this._nameField);
        if (dialog.runDialog()) {
            URL resUrl = this.getResUrl();
            if (resUrl != null) {
                _registry.put(sourceLiteralExpression.getOwningSourceFile().getURL(), resUrl);
                _lastPlatformName = URLFileSystem.getPlatformPathName((URL)resUrl);
            }
            ret = true;
        }
        return ret;
    }

    private void init() {
        String text = this._sourceLiteralExpression.getText();
        String string = text.substring(1, text.length() - 1);
        SourceFile owningSourceFile = this._sourceLiteralExpression.getOwningSourceFile();
        URL sourceUrl = owningSourceFile.getURL();
        URL prevResUrl = (URL)_registry.get(sourceUrl);
        JLabel resLabel = new JLabel();
        DefaultListComboBoxModel resModel = new DefaultListComboBoxModel();
        Collection values = _registry.values();
        for (URL resUrl : values) {
            String platformPathName = URLFileSystem.getPlatformPathName((URL)resUrl);
            resModel.addElement((Object)platformPathName);
        }
        this._resCombo = new JComboBox(resModel);
        this._resCombo.setEditable(true);
        ResourceUtils.resLabel((JLabel)resLabel, (Component)this._resCombo, (String)"&File");
        if (prevResUrl != null) {
            String platformPathName = URLFileSystem.getPlatformPathName((URL)prevResUrl);
            this._resCombo.setSelectedItem(platformPathName);
        } else if (_lastPlatformName != null) {
            this._resCombo.setSelectedItem(_lastPlatformName);
        }
        JButton resBrowse = new JButton("...");
        resBrowse.addActionListener(new 1());
        JLabel nameLabel = new JLabel();
        this._nameField = new UpperCaseTextField();
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this._nameField, (String)"&Name");
        String defaultName = string.replaceAll("&", "").replaceAll("\\W+", "_").replaceAll("_*$", "").toUpperCase();
        this._nameField.setText(defaultName);
        JLabel strLabel = new JLabel();
        this._strField = new JTextField(50);
        ResourceUtils.resLabel((JLabel)strLabel, (Component)this._strField, (String)"&String");
        this._strField.setText(string.replaceAll("\\\\\"", "\""));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)resLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._resCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)resBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)strLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._strField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, insets, 0, 0));
    }

    private void whenBrowse() {
        URL selectedURL;
        URLChooser urlChooser = DialogUtil.newURLChooser((Context)this._context);
        int confirm = urlChooser.showOpenDialog((Component)Ide.getMainWindow(), "Resource Bundle");
        if (confirm == 0 && (selectedURL = urlChooser.getSelectedURL()) != null) {
            String platformPathName = URLFileSystem.getPlatformPathName((URL)selectedURL);
            this._resCombo.setSelectedItem(platformPathName);
        }
    }

    public URL getResUrl() {
        URL ret = null;
        Object selectedItem = this._resCombo.getSelectedItem();
        if (selectedItem != null) {
            String s = selectedItem.toString();
            ret = URLFactory.newFileURL((String)s);
        }
        return ret;
    }

    public String getResName() {
        return this._nameField.getText();
    }

    public String getResString() {
        return this._strField.getText();
    }

    static void mav$whenBrowse(ResourceDialog resourceDialog) {
        resourceDialog.whenBrowse();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ResourceDialog.mav$whenBrowse(ResourceDialog.this);
        }
    }
}

