/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.awt.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.DeleteNode;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteClassesCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.search.FindClassURLHandler;

public class SafeDeleteClassHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_RANGES_TO_DELETE = "RANGES_TO_DELETE";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        return searchType == -2147483538;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483538) {
            SafeDeleteClassesCriteria criteria = (SafeDeleteClassesCriteria)searchCriteria;
            String[] fqClassNames = criteria.getFqClassNames();
            ret = SafeDeleteClassHandler.getIncludedProjects(searchOperation, fqClassNames);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet<URL> ret = null;
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria criteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            String[] fqClassNames = criteria.getFqClassNames();
            MultiMap rangesToDelete = this.getRangesToDelete(searchOperation);
            int i = 0;
            while (i < fqClassNames.length) {
                String fqClassName = fqClassNames[i];
                SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
                if (sourceClass != null) {
                    String className = sourceClass.getName();
                    int lastDollar = className.lastIndexOf(36);
                    className = className.substring(lastDollar + 1);
                    HashSet javaURLsContaining = JavaURLHelper.getJavaURLsContaining(searchOperation, project, className, false, false, progressIndicator);
                    if (ret == null) {
                        ret = new HashSet();
                    }
                    ret.addAll(javaURLsContaining);
                    SourceFile containingSourceFile = sourceClass.getOwningSourceFile();
                    URL url = containingSourceFile.getURL();
                    int startOffset = sourceClass.getStartOffset();
                    int endOffset = sourceClass.getEndOffset();
                    this.addRangeToDelete(rangesToDelete, url, startOffset, endOffset);
                } else {
                    if (ret == null) {
                        ret = new HashSet<URL>();
                    }
                    ret.addAll(Arrays.asList(criteria.getUrls()));
                }
                ++i;
            }
            searchOperation.setProperty(KEY_RANGES_TO_DELETE, rangesToDelete);
        }
        return ret;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel ret = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria criteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            String[] fqClassNames = criteria.getFqClassNames();
            MultiMap rangesToDelete = this.getRangesToDelete(searchOperation);
            int i = 0;
            while (i < fqClassNames.length) {
                String fqClassName = fqClassNames[i];
                SourceClass classToDelete = javaManager.getSourceClass(fqClassName);
                if (classToDelete != null) {
                    String packageName = classToDelete.getPackageName();
                    UsageModel usageModel = FindClassURLHandler.searchClass(progressIndicator, project, urls, fqClassName, packageName, true, true, true, true, true, false, false);
                    ArrayList usageEntries = usageModel.getUsageEntries();
                    int j = 0;
                    while (j < usageEntries.size()) {
                        int offset;
                        BaseUsageEntry entry = (BaseUsageEntry)usageEntries.get(j);
                        URL url = entry.getURL();
                        if (!this.isInRangeToDelete(rangesToDelete, url, offset = entry.getOffset())) {
                            ret.addUsageEntry(entry);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refChanges = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            SafeDeleteClassesCriteria criteria = (SafeDeleteClassesCriteria)searchOperation.getCriteria();
            ArrayList<URL> urlsToDelete = new ArrayList<URL>();
            String[] fqClassNames = criteria.getFqClassNames();
            ArrayList<String> classesToDelete = new ArrayList<String>(Arrays.asList(fqClassNames));
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            MultiMap rangesToDelete = this.getRangesToDelete(searchOperation);
            Set urls = rangesToDelete.keySet();
            for (URL url : urls) {
                SourceFile sourceFile = javaManager.getSourceFile(url);
                List containedSourceClasses = sourceFile.getSourceClasses();
                boolean canDeleteURL = true;
                for (SourceClass containedSourceClass : containedSourceClasses) {
                    String containedClassName = containedSourceClass.getQualifiedName();
                    if (classesToDelete.contains(containedClassName)) continue;
                    canDeleteURL = false;
                }
                if (!canDeleteURL) continue;
                urlsToDelete.add(url);
                for (SourceClass containedSourceClass : containedSourceClasses) {
                    String name = containedSourceClass.getQualifiedName();
                    classesToDelete.remove(name);
                }
            }
            ArrayList<RefactoringChange> allChanges = new ArrayList<RefactoringChange>();
            int i = 0;
            while (i < urlsToDelete.size()) {
                URL url = (URL)urlsToDelete.get(i);
                DeleteNode deleteNode = new DeleteNode(project, url);
                allChanges.add(deleteNode);
                ++i;
            }
            int i2 = 0;
            while (i2 < classesToDelete.size()) {
                String fqClassName = classesToDelete.get(i2);
                SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
                URL url = sourceClass.getOwningSourceFile().getURL();
                TextNode textNode = (TextNode)NodeFactory.find((URL)url);
                int startOffset = sourceClass.getStartOffset();
                int endOffset = sourceClass.getEndOffset();
                TextChange textChange = new TextChange(textNode, startOffset, endOffset, "", true);
                allChanges.add(textChange);
                ++i2;
            }
            refChanges = allChanges.toArray(new RefactoringChange[allChanges.size()]);
            int i3 = 0;
            while (i3 < urlsToDelete.size()) {
                URL url = (URL)urlsToDelete.get(i3);
                Helpers.removeClasses(project, url);
                ++i3;
            }
        }
        return refChanges;
    }

    private boolean isInRangeToDelete(MultiMap rangesToDelete, URL url, int offset) {
        List ranges = rangesToDelete.get((Object)url);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.size()) {
                Point point = (Point)ranges.get(i);
                if (point.x <= offset && offset <= point.y) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void addRangeToDelete(MultiMap rangesToDelete, URL url, int startOffset, int endOffset) {
        Point range;
        List ranges = rangesToDelete.getOrCreate((Object)url);
        if (!ranges.contains(range = new Point(startOffset, endOffset))) {
            ranges.add(range);
        }
    }

    private MultiMap getRangesToDelete(SearchOperation searchOperation) {
        MultiMap rangesToDelete = (MultiMap)searchOperation.getProperty(KEY_RANGES_TO_DELETE);
        if (rangesToDelete == null) {
            rangesToDelete = new MultiMap();
        }
        return rangesToDelete;
    }
}

