/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteMethodCriteria;
import oracle.jdeveloper.refactoring.dialogs.SafeDeleteFailedDialog;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.safedelete.IdeSafeDeleteCommand;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;

public class SafeDeleteController
implements Controller,
IdeSafeDeleteCommand {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle;
        block6: {
            block7: {
                canHandle = false;
                if (context == null || context.getWorkspace() == null || context.getProject() == null) break block6;
                ElementAt elementAt = ElementAt.findElementAt(context);
                if (elementAt == null) break block7;
                switch (elementAt.getElementType()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: {
                        SourceFile owningFile;
                        URL url;
                        SourceElement sourceElement = elementAt.getSourceElement();
                        if (sourceElement != null && Util.canRefactor(url = (owningFile = sourceElement.getOwningSourceFile()).getURL())) {
                            canHandle = true;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block6;
            }
            if (context.getView() instanceof NavigatorWindow) {
                Element[] selected = context.getSelection();
                int i = 0;
                while (i < selected.length) {
                    Node node;
                    URL url;
                    Element element = selected[i];
                    if (element instanceof Node && !(canHandle = Util.canRefactor(url = (node = (Node)element).getURL()))) break;
                    ++i;
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean ret = false;
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 1: {
                    SourceClass sourceSourceClass = (SourceClass)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteClass(context, sourceSourceClass);
                    ret = true;
                    break;
                }
                case 3: {
                    SourceMethod sourceMethod = (SourceMethod)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteMethod(context, sourceMethod);
                    ret = true;
                    break;
                }
                case 4: 
                case 7: {
                    SourceMemberVariable sourceMemberVariable = (SourceMemberVariable)elementAt.getSourceElement();
                    SafeDeleteController.whenSafeDeleteField(context, sourceMemberVariable);
                    ret = true;
                }
            }
        } else if (context.getView() instanceof NavigatorWindow) {
            Element[] selected = context.getSelection();
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 0;
            while (i < selected.length) {
                Element element = selected[i];
                if (element instanceof Locatable) {
                    Locatable locatable = (Locatable)element;
                    urls.add(locatable.getURL());
                }
                ++i;
            }
            ret = SafeDeleteController.safeDeleteFiles(context, urls.toArray(new URL[urls.size()]));
        }
        return ret;
    }

    public static boolean canSafeDeleteFiles(Context context, URL[] urls) {
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            if (!Util.isJavaSource(url)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean safeDeleteFiles(Context context, URL[] urls) {
        Element[] selectedIdeElements = context.getSelection();
        Folder ownerFolder = Workspaces.findOwner((Element)selectedIdeElements[0], (Context)context);
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        ArrayList<SourceClass> classesToDelete = new ArrayList<SourceClass>();
        int i = 0;
        while (i < urls.length) {
            SourceFile sourceFile;
            URL url = urls[i];
            if (Util.isJavaSource(url) && (sourceFile = javaManager.getSourceFile(url)) != null && SafeDeleteController.updateMessage(url, ownerFolder, selectedIdeElements)) {
                List sourceClasses = sourceFile.getSourceClasses();
                int j = 0;
                while (j < sourceClasses.size()) {
                    SourceClass sourceClass = (SourceClass)sourceClasses.get(j);
                    classesToDelete.add(sourceClass);
                    ++j;
                }
            }
            ++i;
        }
        SourceClass[] classesArray = classesToDelete.toArray(new SourceClass[classesToDelete.size()]);
        return SafeDeleteController.doSafeDelete(context, urls, classesArray);
    }

    public static boolean safeDeleteClasses(Context context, SourceClass[] sourceClasses) {
        boolean ret = false;
        if (sourceClasses.length != 0) {
            HashSet<URL> affectedUrls = new HashSet<URL>(sourceClasses.length);
            int i = 0;
            while (i < sourceClasses.length) {
                SourceClass sourceClass = sourceClasses[i];
                SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
                URL url = owningSourceFile.getURL();
                affectedUrls.add(url);
                ++i;
            }
            JavaManager javaManager = JavaManager.getJavaManager((Project)context.getProject());
            HashSet<SourceClass> classesToDelete = new HashSet<SourceClass>(Arrays.asList(sourceClasses));
            HashSet<URL> urlsToDelete = new HashSet<URL>(affectedUrls);
            for (URL url : affectedUrls) {
                boolean deleteFile = true;
                SourceFile sourceFile = javaManager.getSourceFile(url);
                List classesInFile = sourceFile.getSourceClasses();
                int i2 = 0;
                while (!deleteFile && i2 < classesInFile.size()) {
                    SourceClass sourceClass = (SourceClass)classesInFile.get(i2);
                    if (!classesToDelete.contains(sourceClass)) {
                        deleteFile = false;
                    }
                    ++i2;
                }
                if (!deleteFile) continue;
                urlsToDelete.add(url);
            }
            URL[] urlsArrayToDelete = urlsToDelete.toArray(new URL[urlsToDelete.size()]);
            ret = SafeDeleteController.doSafeDelete(context, urlsArrayToDelete, sourceClasses);
        }
        return ret;
    }

    private static void whenSafeDeleteClass(Context context, SourceClass sourceSourceClass) {
        SourceFile sourceFile = sourceSourceClass.getOwningSourceFile();
        SourceClass mainClass = sourceFile.getSourcePrimaryClass();
        if (mainClass == sourceSourceClass) {
            SafeDeleteController.doSafeDelete(context, sourceFile);
        } else {
            SafeDeleteController.doSafeDelete(context, new URL[0], new SourceClass[]{sourceSourceClass});
        }
    }

    private static boolean doSafeDelete(Context context, SourceFile sourceFile) {
        ArrayList<SourceClass> classesToDelete = new ArrayList<SourceClass>();
        List classes = sourceFile.getSourceClasses();
        for (SourceClass sourceClass : classes) {
            classesToDelete.add(sourceClass);
        }
        SourceClass[] classesArray = classesToDelete.toArray(new SourceClass[classesToDelete.size()]);
        URL[] urls = new URL[]{sourceFile.getURL()};
        return SafeDeleteController.doSafeDelete(context, urls, classesArray);
    }

    public static boolean whenSafeDeleteMethod(Context context, SourceMethod sourceMethod) {
        MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
        SafeDeleteMethodCriteria criteria = new SafeDeleteMethodCriteria(methodDescription);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        Util.setOperationHints(searchOperation, (JavaMember)sourceMethod, false);
        return SafeDeleteController.doSafeDelete(searchOperation, criteria);
    }

    public static boolean whenSafeDeleteField(Context context, SourceMemberVariable sourceMemberVariable) {
        FieldDescription fieldDescription = new FieldDescription((JavaField)sourceMemberVariable);
        SafeDeleteFieldCriteria safeDeleteFieldCriteria = new SafeDeleteFieldCriteria(fieldDescription);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, safeDeleteFieldCriteria);
        Util.setOperationHints(searchOperation, (JavaMember)sourceMemberVariable, false);
        return SafeDeleteController.doSafeDelete(searchOperation, safeDeleteFieldCriteria);
    }

    private static boolean doSafeDelete(Context context, URL[] urls, SourceClass[] classesToDelete) {
        int classCount = classesToDelete.length;
        ClassDescription[] classDescriptions = new ClassDescription[classCount];
        int i = 0;
        while (i < classCount) {
            SourceClass sourceClass = classesToDelete[i];
            classDescriptions[i] = ClassDescription.createClassDescription((JavaClass)sourceClass);
            ++i;
        }
        SafeDeleteClassesCriteria safeDeleteClassesCriteria = new SafeDeleteClassesCriteria(urls, classDescriptions);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, safeDeleteClassesCriteria);
        boolean ret = SafeDeleteController.doSafeDelete(searchOperation, safeDeleteClassesCriteria);
        return ret;
    }

    private static boolean doSafeDelete(SearchOperationImpl searchOperation, SearchCriteria criteria) {
        SearchResults searchResults = searchOperation.search();
        if (searchResults != null) {
            UsageModel usageModel = searchResults.getUsageModel();
            ArrayList usageEntries = usageModel.getUsageEntries();
            if (usageEntries.isEmpty()) {
                if (criteria.getSearchType() == -2147483538) {
                    SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)criteria;
                    URL[] urls = safeDeleteClassesCriteria.getUrls();
                    int i = 0;
                    while (i < urls.length) {
                        URL url = urls[i];
                        URLFileSystem.delete((URL)url);
                        SafeDeleteController.deleteOutputFile(searchOperation, url);
                        ++i;
                    }
                    return true;
                }
                return false;
            }
            if (Ide.getIdeArgs().getCreateUI()) {
                String title = criteria.getLongTitle();
                SafeDeleteFailedDialog dialog = new SafeDeleteFailedDialog(title, "f1_jrf_ddelete_html");
                if (WizardLauncher.runDialog((JDialog)((Object)dialog))) {
                    if (dialog.isIgnorePressed()) {
                        return searchOperation.doRefactoring();
                    }
                    UsagesLogPage.showUsages(searchOperation, false);
                    return false;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private static void deleteOutputFile(SearchOperationImpl searchOperation, URL url) {
        Project project = searchOperation.getContext().getProject();
        URL outputDirectoryURL = JavaProject.getInstance((Project)project).getOutputDirectory();
        if (URLFileSystem.exists((URL)outputDirectoryURL)) {
            String outputDirectoryPath = URLFileSystem.getPath((URL)outputDirectoryURL);
            URLPath urlPath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
            String path = URLFileSystem.getPath((URL)url);
            URL[] sourcePathUrls = urlPath.getEntries();
            int i = 0;
            while (i < sourcePathUrls.length) {
                String sourcePath = URLFileSystem.getPath((URL)sourcePathUrls[i]);
                String[] substrings = path.split(sourcePath);
                if (substrings != null && substrings.length == 2 && "".equals(substrings[0])) {
                    String relPath = substrings[1];
                    File file = new File(outputDirectoryPath, relPath);
                    if (!file.exists()) break;
                    try {
                        URLFileSystem.delete((URL)file.toURL());
                    }
                    catch (MalformedURLException e) {}
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean updateMessage(URL url, Folder ownerFolder, Element[] elements) {
        Element element = null;
        int i = 0;
        while (i < elements.length) {
            Locatable locatable;
            Element elem = elements[i];
            if (elem instanceof Locatable && url.equals((locatable = (Locatable)elem).getURL())) {
                element = elem;
                break;
            }
            ++i;
        }
        if (element == null) return true;
        if (ownerFolder == null) return true;
        if (!ownerFolder.canRemove(element)) return false;
        try {
            if (!(ownerFolder instanceof VetoableSubject)) return true;
            UpdateMessage.fireCanRemoveChild((VetoableSubject)((VetoableSubject)ownerFolder), element);
            return true;
        }
        catch (ChangeVetoException e) {
            return false;
        }
    }

    public boolean canSafeDelete(Context context, URL url) {
        Node node = context.getNode();
        if (node instanceof Workspace || node instanceof Project) {
            return false;
        }
        return context.getProject() != null && Util.canRefactor(url);
    }

    public boolean safeDeleteFile(Context context, URL url) {
        return SafeDeleteController.safeDeleteFiles(context, new URL[]{url});
    }
}

