/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.handlers.MemberURLHelperJot;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.util.Visitor;

public class SafeDeleteFieldHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_WRITE_USAGES = "WRITE_USAGES";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        return searchType == -2147483536;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483536) {
            SafeDeleteFieldCriteria criteria = (SafeDeleteFieldCriteria)searchCriteria;
            String fqClassName = criteria.getClassName();
            ret = SafeDeleteFieldHandler.getIncludedProjects(searchOperation, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        if (this.isMyType(searchOperation)) {
            SafeDeleteFieldCriteria criteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = criteria.getFieldDescription();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            JavaField javaField = fieldDescription.getJavaField((JavaProvider)javaManager);
            urls = MemberURLHelperJot.chooseURLs(searchOperation, project, progressIndicator, (JavaMember)javaField, false, false);
        }
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel ret = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteFieldCriteria criteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = criteria.getFieldDescription();
            SearchFieldCriteria searchFieldCriteria = new SearchFieldCriteria(fieldDescription, false);
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            UsageModel usageModel = RenameFieldURLHandler.findUsages(project, urls, progressIndicator, searchFieldCriteria.getFieldDescription(), searchFieldCriteria.isSearchInComments());
            ArrayList usageEntries = usageModel.getUsageEntries();
            ArrayList writeUsages = this.getWriteUsages(searchOperation, project);
            int i = 0;
            while (i < usageEntries.size()) {
                BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
                int usageType = usageEntry.getUsageType();
                switch (usageType) {
                    case 201: {
                        break;
                    }
                    default: {
                        SourceExpression lhs;
                        SourceInfixExpression sourceInfixExpression;
                        SourceElement parent;
                        URL url = usageEntry.getURL();
                        SourceFile sourceFile = javaManager.getSourceFile(url);
                        int offset = usageEntry.getOffset();
                        boolean isDiscardableUsage = false;
                        SourceElement elementAt = sourceFile.getElementAt(offset);
                        if (elementAt != null && (parent = elementAt.getParent()) != null && (sourceInfixExpression = this.getParentAssigment(parent)) != null && Patch.contains((SourceElement)(lhs = sourceInfixExpression.getFirstOperand()), elementAt)) {
                            writeUsages.add(sourceInfixExpression);
                            isDiscardableUsage = true;
                        }
                        if (isDiscardableUsage) break;
                        ret.addUsageEntry(usageEntry);
                        break;
                    }
                }
                ++i;
            }
            this.setWriteUsages(searchOperation, project, writeUsages);
        }
        return ret;
    }

    private SourceInfixExpression getParentAssigment(SourceElement parent) {
        while (parent != null) {
            SourceInfixExpression sourceInfixExpression;
            int operatorCode;
            int nodeID = parent.getSymbolKind();
            if (nodeID == 50 && Patch.isAssignment(operatorCode = (sourceInfixExpression = (SourceInfixExpression)parent).getOperatorCode())) {
                return sourceInfixExpression;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void setWriteUsages(SearchOperation searchOperation, Project project, ArrayList writeUsages) {
        HashMap<Project, ArrayList> allWriteUsages = (HashMap<Project, ArrayList>)searchOperation.getProperty(KEY_WRITE_USAGES);
        if (allWriteUsages == null) {
            allWriteUsages = new HashMap<Project, ArrayList>();
            searchOperation.setProperty(KEY_WRITE_USAGES, allWriteUsages);
        }
        allWriteUsages.put(project, writeUsages);
    }

    private ArrayList getWriteUsages(SearchOperation searchOperation, Project project) {
        ArrayList ret = null;
        HashMap allWriteUsages = (HashMap)searchOperation.getProperty(KEY_WRITE_USAGES);
        if (allWriteUsages != null) {
            ret = (ArrayList)allWriteUsages.get(project);
        }
        return ret == null ? new ArrayList() : ret;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refChanges = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            JavaManager javaManager;
            ArrayList changes = new ArrayList();
            SafeDeleteFieldCriteria criteria = (SafeDeleteFieldCriteria)searchOperation.getCriteria();
            FieldDescription fieldDescription = criteria.getFieldDescription();
            JavaField javaField = fieldDescription.getJavaField((JavaProvider)(javaManager = JavaManager.getJavaManager((Project)project)));
            if (javaField instanceof SourceFieldVariable) {
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
                if (sourceFieldVariable != null) {
                    SourceFile owningSourceFile = sourceFieldVariable.getOwningSourceFile();
                    URL url = owningSourceFile.getURL();
                    try {
                        TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                        if (project.containsChild((Element)textNode)) {
                            this.removeDeclarations(sourceFieldVariable, textNode, changes);
                            this.removeAssignments(searchOperation, project, textNode, changes);
                            refChanges = changes.toArray(new RefactoringChange[changes.size()]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (javaField instanceof SourceEnumConstant) {
                SourceEnumConstant enumConstant = (SourceEnumConstant)javaField;
                URL url = enumConstant.getOwningSourceFile().getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                    if (project.containsChild((Element)textNode)) {
                        this.removeDeclarations(enumConstant, textNode, changes);
                        refChanges = changes.toArray(new RefactoringChange[changes.size()]);
                    }
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
        }
        return refChanges;
    }

    private void removeAssignments(SearchOperation searchOperation, Project project, TextNode textNode, ArrayList changes) {
        ArrayList writeUsages = this.getWriteUsages(searchOperation, project);
        int i = 0;
        while (i < writeUsages.size()) {
            boolean extend;
            int right;
            int left;
            SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)writeUsages.get(i);
            SourceExpression assignmentExpression = sourceInfixExpression.getFirstOperand();
            if (this.isConstExpression(assignmentExpression)) {
                SourceElement parent = sourceInfixExpression.getParent();
                if (parent instanceof SourceStatement) {
                    SourceStatement sourceStatement = (SourceStatement)parent;
                    left = sourceStatement.getStartOffset();
                    right = sourceStatement.getEndOffset();
                    extend = true;
                } else {
                    left = sourceInfixExpression.getStartOffset();
                    right = assignmentExpression.getStartOffset();
                    extend = false;
                }
            } else {
                left = sourceInfixExpression.getStartOffset();
                right = assignmentExpression.getStartOffset();
                extend = false;
            }
            TextChange textChange = new TextChange(textNode, left, right, "", extend);
            changes.add(textChange);
            ++i;
        }
    }

    private void removeDeclarations(SourceFieldVariable sourceFieldVariable, TextNode textNode, ArrayList changes) {
        boolean extend;
        int startOffset;
        int endOffset;
        SourceFieldDeclaration declaration = (SourceFieldDeclaration)sourceFieldVariable.getParent();
        List variablesCo = declaration.getVariables();
        SourceVariable[] variables = variablesCo.toArray(new SourceVariable[variablesCo.size()]);
        if (variablesCo.size() == 1) {
            endOffset = declaration.getEndOffset();
            Object javaDoc = null;
            startOffset = javaDoc != null ? javaDoc.getStartOffset() : declaration.getStartOffset();
            extend = true;
        } else {
            if (variables[0] == sourceFieldVariable) {
                startOffset = variables[0].getStartOffset();
                endOffset = variables[1].getStartOffset();
            } else {
                int pos = Arrays.asList(variables).indexOf(sourceFieldVariable);
                startOffset = variables[pos - 1].getEndOffset();
                endOffset = variables[pos].getEndOffset();
            }
            extend = false;
        }
        TextChange textChange = new TextChange(textNode, startOffset, endOffset, "", extend);
        changes.add(textChange);
    }

    private boolean isConstExpression(SourceExpression sourceExpression) {
        1 visitor = new 1();
        visitor.visit((SourceElement)sourceExpression);
        return visitor.getUserData() == Boolean.TRUE;
    }

    private void removeDeclarations(SourceEnumConstant enumConstant, TextNode textNode, ArrayList changes) {
        TextChange textChange = new TextChange(textNode, enumConstant.getStartOffset(), enumConstant.getEndOffset(), "", false);
        changes.add(textChange);
    }

    final class 1
    extends Visitor {
        private void $init$() {
            this.setUserData(Boolean.TRUE);
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            this.setNotConst();
        }

        protected void whenEnterInfixExpression(SourceInfixExpression sourceInfixExpression) {
            int operatorCode = sourceInfixExpression.getOperatorCode();
            if (Patch.isAssignment(operatorCode)) {
                this.setNotConst();
            }
        }

        private void setNotConst() {
            this.setUserData(Boolean.FALSE);
            this.skipChildren();
        }

        public 1() {
            this.$init$();
        }
    }
}

