/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.safedelete;

import java.awt.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.handlers.MemberURLHelperJot;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;

public class SafeDeleteMethodHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEY_RANGES_TO_DELETE = "RANGES_TO_DELETE";

    private boolean isMyType(SearchOperation searchOperation) {
        SearchCriteria criteria = searchOperation.getCriteria();
        int searchType = criteria.getSearchType();
        return searchType == -2147483537;
    }

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483537) {
            SafeDeleteMethodCriteria criteria = (SafeDeleteMethodCriteria)searchCriteria;
            String fqClassName = criteria.getClassName();
            ret = SafeDeleteMethodHandler.getIncludedProjects(searchOperation, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        if (this.isMyType(searchOperation)) {
            SourceMethod sourceMethod;
            SafeDeleteMethodCriteria criteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            MultiMap rangesToDelete = this.getRangesToDelete(searchOperation);
            MethodDescription methodDescription = criteria.getMethodDescription();
            JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
            if (javaMethod != null && (sourceMethod = (SourceMethod)javaMethod.getSourceElement()) != null) {
                urls = MemberURLHelperJot.chooseURLs(searchOperation, project, progressIndicator, (JavaMember)javaMethod, false, false);
                HashSet implementedUrls = this.chooseImplementedInterfacesURLs(javaManager, criteria);
                urls.addAll(implementedUrls);
                int startOffset = sourceMethod.getStartOffset();
                int endOffset = sourceMethod.getEndOffset();
                SourceFile owningSourceFile = sourceMethod.getOwningSourceFile();
                URL url = owningSourceFile.getURL();
                this.addRangeToDelete(rangesToDelete, url, startOffset, endOffset);
                searchOperation.setProperty(KEY_RANGES_TO_DELETE, rangesToDelete);
            }
        }
        return urls;
    }

    private HashSet chooseImplementedInterfacesURLs(JavaManager javaManager, SafeDeleteMethodCriteria criteria) {
        HashSet implementedSourceMethods = this.getImplementedInterfaceMethods(criteria, javaManager);
        HashSet<URL> urls = new HashSet<URL>();
        for (SourceMethod sourceMethod : implementedSourceMethods) {
            SourceFile owningFile = sourceMethod.getOwningSourceFile();
            URL url = owningFile.getURL();
            urls.add(url);
        }
        return urls;
    }

    private HashSet getImplementedInterfaceMethods(SafeDeleteMethodCriteria criteria, JavaManager javaManager) {
        HashSet<SourceElement> ret = new HashSet<SourceElement>(0);
        MethodDescription methodDescription = criteria.getMethodDescription();
        JavaMethod thisJavaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
        Collection overriddenMethods = thisJavaMethod.getOverriddenMethods();
        for (JavaMethod javaMethod : overriddenMethods) {
            SourceElement sourceElement = javaMethod.getSourceElement();
            ret.add(sourceElement);
        }
        return ret;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel ret = new UsageModel();
        if (this.isMyType(searchOperation)) {
            SafeDeleteMethodCriteria criteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            MultiMap rangesToDelete = this.getRangesToDelete(searchOperation);
            MethodDescription methodDescription = criteria.getMethodDescription();
            UsageModel usageModel = RenameMethodURLHandler.searchMethod(project, urls, progressIndicator, methodDescription, true);
            ArrayList usageEntries = usageModel.getUsageEntries();
            int j = 0;
            while (j < usageEntries.size()) {
                int offset;
                BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(j);
                URL url = usageEntry.getURL();
                if (!this.isInRangeToDelete(rangesToDelete, url, offset = usageEntry.getOffset())) {
                    ret.addUsageEntry(usageEntry);
                }
                ++j;
            }
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            HashSet implementedInterfaceMethods = this.getImplementedInterfaceMethods(criteria, javaManager);
            for (SourceMethod sourceMethod : implementedInterfaceMethods) {
                URL url = sourceMethod.getOwningSourceFile().getURL();
                int startOffset = sourceMethod.getStartOffset();
                int endOffset = sourceMethod.getEndOffset();
                UsageEntry usageEntry = new UsageEntry(project, url, startOffset, endOffset - startOffset, 0, 2);
                ret.addUsageEntry(usageEntry);
            }
        }
        return ret;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] refChanges = new RefactoringChange[]{};
        if (this.isMyType(searchOperation)) {
            SafeDeleteMethodCriteria criteria = (SafeDeleteMethodCriteria)searchOperation.getCriteria();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            MethodDescription methodDescription = criteria.getMethodDescription();
            JavaMethod javaMethod = methodDescription.getJavaMethod((JavaProvider)javaManager);
            SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
            SourceFile owningSourceFile = sourceMethod.getOwningSourceFile();
            URL url = owningSourceFile.getURL();
            try {
                TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                if (project.containsChild((Element)textNode)) {
                    int startOffset = sourceMethod.getStartOffset();
                    int endOffset = sourceMethod.getEndOffset();
                    TextChange textChange = new TextChange(textNode, startOffset, endOffset, "", true);
                    refChanges = new RefactoringChange[]{textChange};
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return refChanges;
    }

    private boolean isInRangeToDelete(MultiMap rangesToDelete, URL url, int offset) {
        List ranges = rangesToDelete.get((Object)url);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.size()) {
                Point point = (Point)ranges.get(i);
                if (point.x <= offset && offset <= point.y) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void addRangeToDelete(MultiMap rangesToDelete, URL url, int startOffset, int endOffset) {
        Point range;
        List ranges = rangesToDelete.getOrCreate((Object)url);
        if (!ranges.contains(range = new Point(startOffset, endOffset))) {
            ranges.add(range);
        }
    }

    private MultiMap getRangesToDelete(SearchOperation searchOperation) {
        MultiMap rangesToDelete = (MultiMap)searchOperation.getProperty(KEY_RANGES_TO_DELETE);
        if (rangesToDelete == null) {
            rangesToDelete = new MultiMap();
        }
        return rangesToDelete;
    }
}

