/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.usersupertype;

import java.awt.Component;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.criteria.UseSupertypeCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeDialog;

public class UseSupertypeController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = UseSupertypeController.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public static boolean canUseSupertype(Context context, SourceClass sourceClass) {
        return UseSupertypeController.handle(context, sourceClass, false);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        UseSupertypeController.handle(context, true);
        return true;
    }

    public static void whenUseSupertype(Context context, SourceClass sourceClass) {
        UseSupertypeController.handle(context, sourceClass, true);
    }

    private static boolean handle(Context context, boolean doit) {
        boolean ret = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null) {
            SourceClass sourceClass = ElementAt.getSourceClassAt(context, false, false);
            if (sourceClass != null) {
                ret = UseSupertypeController.handle(context, sourceClass, doit);
            } else {
                Element element = context.getElement();
                if (element instanceof JavaSourceNode) {
                    SourceClass sourceSourceClass;
                    JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                    Project project = context.getProject();
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    SourceFile sourceFile = javaManager.getSourceFile(javaSourceNode.getURL());
                    if (sourceFile != null && (sourceSourceClass = Patch.getMainClass(sourceFile)) != null && Util.isClassInSources(context.getWorkspace(), project, sourceSourceClass)) {
                        ret = UseSupertypeController.handle(context, sourceSourceClass, doit);
                    }
                }
            }
        }
        return ret;
    }

    private static boolean handle(Context context, SourceClass sourceClass, boolean doit) {
        boolean ret = false;
        if (sourceClass != null && !sourceClass.isAnnotation() && !sourceClass.isAnonymous() && Util.canRefactor((SourceElement)sourceClass)) {
            ret = true;
            if (doit) {
                boolean hasValidSuper = false;
                Set hierarchy = sourceClass.getHierarchy();
                Iterator iterator = hierarchy.iterator();
                while (!hasValidSuper && iterator.hasNext()) {
                    JavaClass javaClass = (JavaClass)iterator.next();
                    SourceElement sourceElement = javaClass.getSourceElement();
                    if (sourceElement == null || !Util.canRefactor(sourceElement)) continue;
                    hasValidSuper = true;
                }
                if (hasValidSuper) {
                    UseSupertypeDialog dlg = new UseSupertypeDialog(context, sourceClass);
                    if (dlg.runDialog()) {
                        boolean hasPreview = dlg.hasPreview();
                        String fqSupertypeName = dlg.getSelectedType();
                        JavaProvider provider = sourceClass.getOwningSourceFile().getProvider();
                        SourceClass superSourceClass = provider.getSourceClass(fqSupertypeName);
                        if (superSourceClass != null) {
                            UseSupertypeController.whenUseSupertype(context, sourceClass, superSourceClass, hasPreview);
                        }
                    }
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(124), (String)RefactoringArb.getString(171), null);
                }
            }
        }
        return ret;
    }

    public static void whenUseSupertype(Context context, SourceClass sourceClass, SourceClass superSourceClass, boolean hasPreview) {
        UseSupertypeCriteria criteria = new UseSupertypeCriteria(ClassDescription.createClassDescription((JavaClass)sourceClass), ClassDescription.createClassDescription((JavaClass)superSourceClass));
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        searchOperation.runRefactoring(hasPreview);
    }
}

