/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.usersupertype;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class UseSupertypeDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "USE_SUPERTYPE_PREF";
    private static final int PREF_PREVIEW = 1;
    private SourceClass _sourceClass;
    private JList _baseTypes;
    private JCheckBox _preview;

    public UseSupertypeDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context);
        this._sourceClass = sourceClass;
        this.init();
    }

    protected String getTitle() {
        return RefactoringArb.getString(225);
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateOKButton() {
        boolean isValid = true;
        if (this._baseTypes.getSelectedValue() == null) {
            isValid = false;
        }
        this.setOKButtonEnabled(isValid);
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this.hasPreview());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._baseTypes;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dgeneralizedecl_html";
    }

    private void init() {
        JLabel supertypesLabel = new JLabel();
        ArrayList baseTypeNames = this.getBaseTypeNames();
        this._baseTypes = new JList<Object>(baseTypeNames.toArray(new Object[baseTypeNames.size()]));
        ResourceUtils.resLabel((JLabel)supertypesLabel, (Component)this._baseTypes, (String)RefactoringArb.getString(186));
        this._baseTypes.setSelectionMode(0);
        JScrollPane typeSP = new JScrollPane(this._baseTypes);
        if (!baseTypeNames.isEmpty()) {
            this._baseTypes.setSelectedIndex(0);
        }
        String previewLabel = RefactoringArb.getString(328);
        this._preview = new JCheckBox(StringUtils.stripMnemonic((String)previewLabel));
        Util.setMnemonic(this._preview, previewLabel);
        this._preview.setSelected(this.getSettings().isBitSet(1));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)supertypesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)typeSP, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
    }

    private ArrayList getBaseTypeNames() {
        Set baseTypes = this._sourceClass.getHierarchy();
        ArrayList<String> baseTypeNames = new ArrayList<String>();
        String thisClassName = this._sourceClass.getName();
        for (JavaType baseType : baseTypes) {
            String thatClassName;
            SourceClass sourceClass = (SourceClass)baseType.getSourceElement();
            if (sourceClass == null || thisClassName.equals(thatClassName = sourceClass.getQualifiedName()) || sourceClass.getSuperclass() == null) continue;
            baseTypeNames.add(thatClassName);
        }
        return baseTypeNames;
    }

    public String getSelectedType() {
        Object selectedValue = this._baseTypes.getSelectedValue();
        return (String)selectedValue;
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

