/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.usersupertype;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.UseSupertypeCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.Visitor;

public class UseSupertypeURLHandler
extends URLRefactoringHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483541) {
            UseSupertypeCriteria criteria = (UseSupertypeCriteria)searchCriteria;
            String fqClassName = criteria.getFqTypeName();
            ret = UseSupertypeURLHandler.getIncludedProjects(searchOperation, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483541) {
            UseSupertypeCriteria useSupertypeCriteria = (UseSupertypeCriteria)searchCriteria;
            String oldClassName = useSupertypeCriteria.getFqTypeName();
            String shortName = UseSupertypeURLHandler.getShortName(oldClassName);
            urls = JavaURLHelper.getJavaURLsContaining(searchOperation, project, shortName, false, false, progressIndicator);
        }
        return urls;
    }

    private static String getShortName(String fqClassName) {
        int lastDot = fqClassName.lastIndexOf(46);
        int lastDollar = (fqClassName = fqClassName.substring(lastDot + 1)).lastIndexOf(36);
        if (lastDollar != -1) {
            fqClassName = fqClassName.substring(lastDollar + 1);
        }
        return fqClassName;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == -2147483541) {
            usageModel = this.searchReplacableTypes(searchOperation, project, urls, progressIndicator);
        }
        return usageModel;
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            UseSupertypeCriteria criteria = (UseSupertypeCriteria)searchOperation.getCriteria();
            String fqSupertypeName = criteria.getFqSupertypeName();
            ArrayList usageEntries = usageModel.getUsageEntries();
            for (Object usageEntry : usageEntries) {
                SourceElementEntry entry = (SourceElementEntry)usageEntry;
                SourceElement sourceElement = entry.getSourceElementOrThrow();
                SourceFile sourceFile = sourceElement.getOwningSourceFile();
                SourceFactory factory = sourceFile.getFactory();
                refactoringCommandSupport.beginTransaction((SourceElement)sourceFile);
                switch (sourceElement.getSymbolKind()) {
                    case 27: {
                        SourceTypeReference oldTypeReference = (SourceTypeReference)sourceElement;
                        int arrayDimension = oldTypeReference.getArrayDimension();
                        SourceTypeReference newTypeReference = factory.createType(fqSupertypeName, arrayDimension);
                        oldTypeReference.replaceSelf((SourceElement)newTypeReference);
                        break;
                    }
                    case 49: 
                    case 57: {
                        SourceExpression oldExpression = (SourceExpression)sourceElement;
                        SourceExpression newExpression = factory.createExpressionFromText(fqSupertypeName);
                        oldExpression.replaceSelf((SourceElement)newExpression);
                        break;
                    }
                    default: {
                        System.out.println("UseSupertypeURLHandler.doChanges(): missed a change");
                        break;
                    }
                }
            }
            ret = refactoringCommandSupport.commit(searchOperation.getContext(), RefactoringArb.getString(225));
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return ret;
    }

    private UsageModel searchReplacableTypes(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel ret = new UsageModel();
        UseSupertypeCriteria criteria = (UseSupertypeCriteria)searchOperation.getCriteria();
        MultiMap hits = new MultiMap();
        1 classUsageListener = new 1(this, hits);
        UsageManager usageManager = new UsageManager(project);
        UsageQueryTask usageQueryTask = usageManager.findClassUsages(criteria.getFqTypeName(), classUsageListener, urls);
        Util.waitUntilFinished(usageQueryTask, progressIndicator);
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        String fqSupertypeName = criteria.getFqSupertypeName();
        SourceClass superType = javaManager.getSourceClass(fqSupertypeName);
        HashSet stack = new HashSet();
        Set set = hits.keySet();
        String fqTypeName = criteria.getFqTypeName();
        JavaClass javaClass = javaManager.getClass(fqTypeName);
        JavaClass superJavaClass = javaManager.getClass(criteria.getFqSupertypeName());
        if (javaClass == null || superJavaClass == null) {
            return ret;
        }
        String shortName = javaClass.getName();
        for (Object aSet : set) {
            URL url = (URL)aSet;
            SourceFile sourceFile = javaManager.getSourceFile(url);
            new 2(this, shortName, javaClass, project, superType, ret, fqTypeName, superJavaClass, stack).visit((SourceElement)sourceFile);
        }
        return ret;
    }

    private boolean canReplace(SourceExpression expression, JavaClass superType, HashSet stack) {
        try {
            SourceExpression sourceElement = expression;
            SourceElement parent = sourceElement.getParent();
            while (parent != null) {
                int nodeID = parent.getSymbolKind();
                switch (nodeID) {
                    case 2: {
                        boolean bl = false;
                        return bl;
                    }
                    case 49: {
                        SourceDotExpression sourceDotExpression = (SourceDotExpression)parent;
                        JavaHasType resolvedObject = sourceDotExpression.getResolvedObject();
                        if (resolvedObject == null || resolvedObject.getElementKind() != 5) break;
                        JavaField javaField = (JavaField)resolvedObject;
                        JavaClass owningClass = javaField.getOwningClass();
                        boolean bl = owningClass.isAssignableFrom((JavaType)superType);
                        return bl;
                    }
                    case 53: {
                        SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)parent;
                        JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                        if (resolvedMethod == null) break;
                        SourceExpression lhExpression = sourceMethodCallExpression.getLhsOperand();
                        if (lhExpression != null && Patch.contains((SourceElement)sourceElement, (SourceElement)lhExpression)) {
                            JavaType[] parameterTypes;
                            String methodName = resolvedMethod.getName();
                            JavaMethod superMethod = Patch.getJavaMethod((JavaType)superType, methodName, parameterTypes = Patch.getParameterTypes(resolvedMethod));
                            boolean bl = superMethod != null;
                            return bl;
                        }
                        int argPos = this.findArgumentPos(sourceMethodCallExpression, expression);
                        if (argPos != -1) {
                            Collection parameters = resolvedMethod.getParameters();
                            JavaVariable parameter = (JavaVariable)new ArrayList(parameters).get(argPos);
                            SourceVariable sourceParameter = (SourceVariable)parameter.getSourceElement();
                            if (sourceParameter == null) {
                                JavaType paramType = parameter.getResolvedType();
                                boolean bl = paramType != null && paramType.isAssignableFrom((JavaType)superType);
                                return bl;
                            }
                            boolean bl = this.canReplace(sourceParameter, superType, stack);
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 48: {
                        SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)parent;
                        SourceExpression rhsExpression = sourceAssignmentExpression.getSecondOperand();
                        if (Patch.contains((SourceElement)rhsExpression, (SourceElement)sourceElement)) {
                            SourceExpression lhsExpression = sourceAssignmentExpression.getFirstOperand();
                            JavaType lhsTypeInfo = lhsExpression.getResolvedType();
                            if (lhsTypeInfo != null) {
                                SourceElement lhsSourceElement;
                                SourceSimpleNameExpression sourceSimpleNameExpression;
                                JavaHasType resolvedObject;
                                if (lhsTypeInfo.isAssignableFrom((JavaType)superType)) {
                                    boolean bl = true;
                                    return bl;
                                }
                                SourceElement lhsElement = lhsExpression.getSourceElement();
                                if (lhsElement instanceof SourceSimpleNameExpression && (resolvedObject = (sourceSimpleNameExpression = (SourceSimpleNameExpression)lhsElement).getResolvedObject()) != null && (lhsSourceElement = resolvedObject.getSourceElement()) != null) {
                                    switch (lhsSourceElement.getSymbolKind()) {
                                        case 13: 
                                        case 17: {
                                            SourceVariable sourceVariable = (SourceVariable)lhsSourceElement;
                                            boolean bl = this.canReplace(sourceVariable, superType, stack);
                                            return bl;
                                        }
                                    }
                                }
                            }
                        } else {
                            JavaType rhsTypeInfo = rhsExpression.getResolvedType();
                            if (rhsTypeInfo != null && superType.isAssignableFrom(rhsTypeInfo)) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 17: {
                        SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)parent;
                        SourceExpression rhsExpression = sourceLocalVariable.getInitializer();
                        if (Patch.contains((SourceElement)rhsExpression, (SourceElement)sourceElement)) {
                            JavaType lhsTypeInfo = sourceLocalVariable.getResolvedType();
                            if (lhsTypeInfo != null) {
                                if (lhsTypeInfo.isAssignableFrom((JavaType)superType)) {
                                    boolean bl = true;
                                    return bl;
                                }
                                boolean bl = this.canReplace((SourceVariable)sourceLocalVariable, superType, stack);
                                return bl;
                            }
                        } else {
                            JavaType rhsTypeInfo = rhsExpression.getResolvedType();
                            if (rhsTypeInfo != null && superType.isAssignableFrom(rhsTypeInfo)) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 40: {
                        JavaType resolvedType;
                        SourceReturnStatement sourceReturnStatement = (SourceReturnStatement)parent;
                        SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceReturnStatement);
                        if (sourceMethod != null && (resolvedType = sourceMethod.getResolvedType()) != null && resolvedType.isAssignableFrom((JavaType)superType)) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 50: {
                        SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)parent;
                        int operatorCode = sourceInfixExpression.getOperatorCode();
                        switch (operatorCode) {
                            case 23: {
                                SourceTypeExpression sourceTypeExpression = (SourceTypeExpression)sourceInfixExpression.getSecondOperand();
                                JavaType instanceType = sourceTypeExpression.getResolvedType();
                                if (instanceType == null || !instanceType.isAssignableFrom((JavaType)superType)) break;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                sourceElement = parent;
                parent = parent.getParent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private int findArgumentPos(SourceMethodCallExpression sourceMethodCallExpression, SourceExpression expression) {
        SourceListExpression argumentList = sourceMethodCallExpression.getArgumentList();
        List children = argumentList.getChildren();
        Iterator iterator = children.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SourceExpression sourceExpression = (SourceExpression)iterator.next();
            if (sourceExpression.equals(expression)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private SourceElementEntry getStaticTypeUsageEntry(Project project, SourceElement elementAt, SourceClass superType) {
        SourceElement sourceElement = elementAt;
        while (sourceElement != null) {
            JavaClass owningClass = null;
            int nodeID = sourceElement.getSymbolKind();
            switch (nodeID) {
                case 49: {
                    int resolveToNodeID;
                    SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                    JavaHasType resolvedObject = sourceDotExpression.getResolvedObject();
                    if (resolvedObject == null || (resolveToNodeID = resolvedObject.getElementKind()) != 5) break;
                    JavaField javaField = (JavaField)resolvedObject;
                    owningClass = javaField.getOwningClass();
                    break;
                }
                case 53: {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    JavaMethod sourceMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (sourceMethod == null) break;
                    owningClass = sourceMethod.getOwningClass();
                    break;
                }
            }
            if (owningClass != null) {
                if (owningClass.isAssignableFrom((JavaType)superType)) {
                    SourceElementEntry entry = new SourceElementEntry(project, elementAt, 0);
                    return entry;
                }
                return null;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private boolean canReplace(SourceVariableDeclaration sourceVariableDeclaration, JavaClass superType, HashSet stack) {
        List variables = sourceVariableDeclaration.getVariables();
        for (Object variable : variables) {
            SourceVariable sourceVariable = (SourceVariable)variable;
            if (this.canReplace(sourceVariable, superType, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean canReplace(SourceVariable sourceVariable, JavaClass superType, HashSet stack) {
        if (!stack.contains(sourceVariable)) {
            SourceElement owningBlockStatement = Patch.getOwningBlockStatement(sourceVariable);
            boolean canReplace = false;
            if (owningBlockStatement != null) {
                stack.add(sourceVariable);
                canReplace = this.recCanReplace(sourceVariable, owningBlockStatement, superType, stack);
                stack.remove(sourceVariable);
            }
            return canReplace;
        }
        return true;
    }

    private boolean recCanReplace(SourceVariable sourceVariable, SourceElement root, JavaClass superType, HashSet stack) {
        SourceElement[] containedElements;
        SourceElement[] sourceElementArray = containedElements = root.getContainedElements();
        int n = 0;
        while (n < sourceElementArray.length) {
            SourceElement containedElement = sourceElementArray[n];
            int nodeID = containedElement.getSymbolKind();
            switch (nodeID) {
                case 57: {
                    SourceElement resolveToSource;
                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)containedElement;
                    JavaHasType resolveTo = sourceSimpleNameExpression.getResolvedObject();
                    if (resolveTo == null || !sourceVariable.equals(resolveToSource = resolveTo.getSourceElement())) break;
                    return this.canReplace((SourceExpression)sourceSimpleNameExpression, superType, stack);
                }
            }
            if (!this.recCanReplace(sourceVariable, containedElement, superType, stack)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean mav$canReplace(UseSupertypeURLHandler useSupertypeURLHandler, SourceVariable sourceVariable, JavaClass javaClass, HashSet hashSet) {
        return useSupertypeURLHandler.canReplace(sourceVariable, javaClass, hashSet);
    }

    static boolean mav$canReplace(UseSupertypeURLHandler useSupertypeURLHandler, SourceVariableDeclaration sourceVariableDeclaration, JavaClass javaClass, HashSet hashSet) {
        return useSupertypeURLHandler.canReplace(sourceVariableDeclaration, javaClass, hashSet);
    }

    static boolean mav$canReplace(UseSupertypeURLHandler useSupertypeURLHandler, SourceExpression sourceExpression, JavaClass javaClass, HashSet hashSet) {
        return useSupertypeURLHandler.canReplace(sourceExpression, javaClass, hashSet);
    }

    static SourceElementEntry mav$getStaticTypeUsageEntry(UseSupertypeURLHandler useSupertypeURLHandler, Project project, SourceElement sourceElement, SourceClass sourceClass) {
        return useSupertypeURLHandler.getStaticTypeUsageEntry(project, sourceElement, sourceClass);
    }

    static boolean mav$recCanReplace(UseSupertypeURLHandler useSupertypeURLHandler, SourceVariable sourceVariable, SourceElement sourceElement, JavaClass javaClass, HashSet hashSet) {
        return useSupertypeURLHandler.recCanReplace(sourceVariable, sourceElement, javaClass, hashSet);
    }

    final class 1
    implements ClassUsageListener {
        private final /* synthetic */ MultiMap v$hits;
        final /* synthetic */ UseSupertypeURLHandler this$0;

        public void notifyClassUsage(ClassUsageEvent event) {
            int usageCode = event.getUsageCode();
            switch (usageCode) {
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    URL url = event.getURL();
                    this.v$hits.add((Object)url, (Object)event);
                    break;
                }
            }
        }

        public void notifyFinished(UsageEvent event) {
        }

        public void notifySkipped(UsageEvent event) {
        }

        public 1(UseSupertypeURLHandler useSupertypeURLHandler, MultiMap multiMap) {
            this.v$hits = multiMap;
            this.this$0 = useSupertypeURLHandler;
        }
    }

    final class 2
    extends Visitor {
        private final /* synthetic */ String v$shortName;
        private final /* synthetic */ JavaClass v$javaClass;
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ SourceClass v$superType;
        private final /* synthetic */ UsageModel v$ret;
        private final /* synthetic */ String v$fqTypeName;
        private final /* synthetic */ JavaClass v$superJavaClass;
        private final /* synthetic */ HashSet v$stack;
        final /* synthetic */ UseSupertypeURLHandler this$0;

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            JavaHasType resolvedObject;
            SourceName sourceName = sourceDotExpression.getNameElement();
            if (this.v$shortName.equals(sourceName.getName()) && this.v$javaClass.equals((Object)(resolvedObject = sourceDotExpression.getResolvedObject()))) {
                SourceElementEntry usageEntry = UseSupertypeURLHandler.mav$getStaticTypeUsageEntry(this.this$0, this.v$project, (SourceElement)sourceDotExpression, this.v$superType);
                if (usageEntry != null) {
                    this.v$ret.addUsageEntry(usageEntry);
                }
                super.skipChildren();
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject;
            String name = sourceSimpleNameExpression.getName();
            if (this.v$shortName.equals(name) && this.v$javaClass.equals((Object)(resolvedObject = sourceSimpleNameExpression.getResolvedObject()))) {
                SourceElementEntry usageEntry = UseSupertypeURLHandler.mav$getStaticTypeUsageEntry(this.this$0, this.v$project, (SourceElement)sourceSimpleNameExpression, this.v$superType);
                if (usageEntry != null) {
                    this.v$ret.addUsageEntry(usageEntry);
                }
                super.skipChildren();
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceTypeReference) {
            JavaClass foundClass;
            JavaType resolvedType;
            SourceName nameElement = sourceTypeReference.getNameElement();
            String typeName = nameElement.getName();
            if ((typeName.equals(this.v$shortName) || typeName.equals(this.v$fqTypeName)) && (resolvedType = sourceTypeReference.getResolvedType()) != null && this.v$javaClass.equals((Object)(foundClass = (resolvedType.isArray() ? resolvedType.getComponentType() : resolvedType).getTypeErasure()))) {
                boolean canReplace;
                SourceElement parent = sourceTypeReference.getParent();
                switch (parent.getSymbolKind()) {
                    case 13: {
                        SourceFormalParameter sourceLocalVariable = (SourceFormalParameter)parent;
                        canReplace = UseSupertypeURLHandler.mav$canReplace(this.this$0, (SourceVariable)sourceLocalVariable, this.v$superJavaClass, this.v$stack);
                        break;
                    }
                    case 18: {
                        SourceVariableDeclaration sourceVariableDeclaration = (SourceVariableDeclaration)parent;
                        canReplace = UseSupertypeURLHandler.mav$canReplace(this.this$0, sourceVariableDeclaration, this.v$superJavaClass, this.v$stack);
                        break;
                    }
                    case 58: {
                        SourceTypeExpression sourceTypeExpression = (SourceTypeExpression)parent;
                        SourceElement parent2 = sourceTypeExpression.getParent();
                        if (parent2.getSymbolKind() == 59) {
                            SourceTypecastExpression sourceTypecastExpression = (SourceTypecastExpression)parent2;
                            canReplace = UseSupertypeURLHandler.mav$canReplace(this.this$0, (SourceExpression)sourceTypecastExpression, (JavaClass)this.v$superType, this.v$stack);
                            break;
                        }
                        canReplace = false;
                        break;
                    }
                    case 9: {
                        SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)parent;
                        if (sourceFieldDeclaration.isPrivate()) {
                            List variables = sourceFieldDeclaration.getVariables();
                            SourceClass enclosingClass = sourceFieldDeclaration.getEnclosingClass();
                            while (enclosingClass.getOwningClass() != null) {
                                enclosingClass = enclosingClass.getEnclosingClass();
                            }
                            1 visitor = new 1(this, variables);
                            visitor.visit((SourceElement)enclosingClass);
                            canReplace = visitor.getUserData() != Boolean.FALSE;
                            break;
                        }
                        canReplace = false;
                        break;
                    }
                    default: {
                        canReplace = false;
                    }
                }
                if (canReplace) {
                    SourceElementEntry entry = new SourceElementEntry(this.v$project, (SourceElement)sourceTypeReference, 1);
                    this.v$ret.addUsageEntry(entry);
                }
            }
        }

        public 2(UseSupertypeURLHandler useSupertypeURLHandler, String string, JavaClass javaClass, Project project, SourceClass sourceClass, UsageModel usageModel, String string2, JavaClass javaClass2, HashSet hashSet) {
            this.v$stack = hashSet;
            this.v$superJavaClass = javaClass2;
            this.v$fqTypeName = string2;
            this.v$ret = usageModel;
            this.v$superType = sourceClass;
            this.v$project = project;
            this.v$javaClass = javaClass;
            this.v$shortName = string;
            this.this$0 = useSupertypeURLHandler;
        }

        static SourceClass ra$v$superType(2 var0) {
            return var0.v$superType;
        }

        static HashSet ra$v$stack(2 var0) {
            return var0.v$stack;
        }

        final class 1
        extends Visitor {
            private final /* synthetic */ List v$variables;
            final /* synthetic */ 2 this$0;

            protected void whenEnterBlock(SourceBlock sourceBlock) {
                for (Object variable : this.v$variables) {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)variable;
                    if (UseSupertypeURLHandler.mav$recCanReplace(this.this$0.this$0, (SourceVariable)sourceFieldVariable, (SourceElement)sourceBlock, (JavaClass)2.ra$v$superType(this.this$0), 2.ra$v$stack(this.this$0))) continue;
                    this.setUserData(Boolean.FALSE);
                    this.cancel();
                }
            }

            public 1(2 var1_1, List list) {
                this.v$variables = list;
                this.this$0 = var1_1;
            }
        }
    }
}

