/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.refactoring.model.DeterminateProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchResultListener;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.SearchResultsPerHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;

public class BackgroundUsagesLogPage
extends UsagesLogPage
implements DeterminateProgressIndicator,
SearchResultListener {
    public static int STOP_SEARCH_CMD_ID;
    private static boolean _actionsCreated;
    private boolean _cancelled;
    private boolean _running;
    private JProgressBar _progressBar;
    private String _progressText;
    private ArrayList<ActionListener> _listeners;

    private void $init$() {
        this._listeners = new ArrayList(1);
    }

    public BackgroundUsagesLogPage() {
        this.$init$();
    }

    public static void showUsages(SearchOperationImpl usageSource, boolean useNewTab) {
        BackgroundUsagesLogPage logPage = BackgroundUsagesLogPage.findUsablePage(useNewTab);
        logPage.setUsageSource(usageSource);
        logPage.showPage();
        logPage.doSearch();
    }

    private static BackgroundUsagesLogPage findUsablePage(boolean useNewTab) {
        if (!useNewTab) {
            LogManager logManager = LogManager.getLogManager();
            LogPage page = logManager.getSelectedPage();
            if (BackgroundUsagesLogPage.isReusablePage(page)) {
                return (BackgroundUsagesLogPage)page;
            }
            LogPage[] pages = logManager.getPages();
            int i = 0;
            while (i < pages.length) {
                LogPage page2 = pages[i];
                if (BackgroundUsagesLogPage.isReusablePage(page2)) {
                    return (BackgroundUsagesLogPage)page2;
                }
                ++i;
            }
        }
        return new BackgroundUsagesLogPage();
    }

    private static boolean isReusablePage(LogPage logPage) {
        BackgroundUsagesLogPage usagesLogPage;
        return logPage.getClass() == BackgroundUsagesLogPage.class && !(usagesLogPage = (BackgroundUsagesLogPage)logPage).isLocked() && !usagesLogPage.isRunning();
    }

    public boolean isRunning() {
        return this._running && !this._cancelled;
    }

    protected Toolbar createToolbar() {
        BackgroundUsagesLogPage.createActions();
        Toolbar toolbar = new Toolbar();
        this.addStopButton(toolbar);
        this.addRefreshButton(toolbar);
        this.addShowMatchButton(toolbar);
        this.addLockPageButton(toolbar);
        this.addShowMethodsButton(toolbar);
        this.addProgressBar(toolbar);
        return toolbar;
    }

    public void setOwner(LogOwner owner) {
        if (owner == null) {
            this._cancelled = true;
            this.fireActionListeners();
        }
        super.setOwner(owner);
    }

    protected final void addStopButton(Toolbar toolbar) {
        toolbar.add((ToggleAction)this.getAction(STOP_SEARCH_CMD_ID));
    }

    protected final void addProgressBar(Toolbar toolbar) {
        this._progressBar = new JProgressBar();
        this._progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES)));
        this._progressBar.setIndeterminate(true);
        this._progressBar.setMinimum(0);
        this._progressBar.setMaximum(100);
        this._progressBar.setStringPainted(true);
        toolbar.add((Component)this._progressBar);
    }

    public void setProgressStepText(String text) {
        if (text != null && text.trim().length() > 0) {
            this._progressBar.setString(text);
        } else {
            this._progressBar.setString(this._progressText);
        }
    }

    public void setProgressText(String text) {
        this._progressText = text;
        this._progressBar.setString(text);
    }

    public void setProgress(int progress) {
        if (this._progressBar.isIndeterminate()) {
            SwingUtilities.invokeLater(new 1());
        }
        this._progressBar.setValue(progress);
    }

    public void addActionListener(ActionListener listener) {
        this._listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this._listeners.remove(listener);
    }

    public boolean isUserCancelled() {
        return this._cancelled;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId != STOP_SEARCH_CMD_ID) {
            return super.handleEvent(action, context);
        }
        this.whenStop();
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == STOP_SEARCH_CMD_ID) {
            action.setEnabled(this._running && !this._cancelled);
        } else if (commandId == 51) {
            action.setEnabled((!this._running || this._cancelled) && this.canSearch());
        } else if (commandId == UsagesLogPage.SHOW_METHODS_CMD_ID) {
            action.setEnabled(this._running ^ true);
        } else {
            return super.update(action, context);
        }
        return true;
    }

    protected void whenStop() {
        this._cancelled = true;
        this._progressBar.setVisible(false);
        SearchOperationImpl usageSource = (SearchOperationImpl)this.getUsageSource();
        usageSource.setUserCancelled(true);
        this.fireActionListeners();
    }

    protected void whenRefresh() {
        this.doSearch();
    }

    public void resultsAdded(SearchResults results, SearchResultsPerHandler added) {
        SwingUtilities.invokeLater(new 2(this, added, results));
    }

    private void doSearch() {
        this.setUsageModel(new UsageModel());
        SearchOperationImpl usageSource = (SearchOperationImpl)this.getUsageSource();
        usageSource.getSearchResults().addSearchResultListener(this);
        usageSource.setUserCancelled(false);
        3 r = new 3(this, usageSource);
        Thread t = new Thread((Runnable)r, "Find Usages");
        t.start();
    }

    private void fireActionListeners() {
        ArrayList localListeners = (ArrayList)this._listeners.clone();
        for (ActionListener listener : localListeners) {
            listener.actionPerformed(new ActionEvent(this, 1001, "canceled"));
        }
    }

    private static void createActions() {
        if (!_actionsCreated) {
            String stopLabel = RefactoringArb.getString(193);
            STOP_SEARCH_CMD_ID = Ide.findOrCreateCmdID((String)"REFACTORING_PREVIEW.STOP");
            IdeAction.get((int)STOP_SEARCH_CMD_ID, null, (String)StringUtils.stripMnemonic((String)stopLabel), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)stopLabel)), (Icon)OracleIcons.getIcon((String)"terminate.png"), null, (boolean)true);
            _actionsCreated = true;
        }
    }

    static JProgressBar ra$_progressBar(BackgroundUsagesLogPage backgroundUsagesLogPage) {
        return backgroundUsagesLogPage._progressBar;
    }

    static void wa$_cancelled(BackgroundUsagesLogPage backgroundUsagesLogPage, boolean bl) {
        backgroundUsagesLogPage._cancelled = bl;
    }

    static void wa$_running(BackgroundUsagesLogPage backgroundUsagesLogPage, boolean bl) {
        backgroundUsagesLogPage._running = bl;
    }

    static void mav$requestShow(BackgroundUsagesLogPage backgroundUsagesLogPage, boolean bl) {
        backgroundUsagesLogPage.requestShow(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            BackgroundUsagesLogPage.ra$_progressBar(BackgroundUsagesLogPage.this).setIndeterminate(false);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ SearchResultsPerHandler v$added;
        private final /* synthetic */ SearchResults v$results;
        final /* synthetic */ BackgroundUsagesLogPage this$0;

        public void run() {
            if (!this.v$added.getUsageModel().getUsageEntries().isEmpty()) {
                this.this$0.updateUsageModel(this.v$results.getUsageModel(), this.v$added.getUsageModel());
                BackgroundUsagesLogPage.mav$requestShow(this.this$0, false);
            }
        }

        public 2(BackgroundUsagesLogPage backgroundUsagesLogPage, SearchResultsPerHandler searchResultsPerHandler, SearchResults searchResults) {
            this.v$results = searchResults;
            this.v$added = searchResultsPerHandler;
            this.this$0 = backgroundUsagesLogPage;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ SearchOperationImpl v$usageSource;
        final /* synthetic */ BackgroundUsagesLogPage this$0;

        public void run() {
            BackgroundUsagesLogPage.ra$_progressBar(this.this$0).setIndeterminate(true);
            BackgroundUsagesLogPage.ra$_progressBar(this.this$0).setString(RefactoringArb.getString(85));
            BackgroundUsagesLogPage.wa$_cancelled(this.this$0, false);
            BackgroundUsagesLogPage.wa$_running(this.this$0, true);
            SwingUtilities.invokeLater(new 1());
            try {
                this.v$usageSource.doSearch(this.this$0);
                this.v$usageSource.getSearchResults().removeSearchResultListener(this.this$0);
            }
            finally {
                BackgroundUsagesLogPage.wa$_running(this.this$0, false);
            }
            SwingUtilities.invokeLater(new 2());
        }

        public 3(BackgroundUsagesLogPage backgroundUsagesLogPage, SearchOperationImpl searchOperationImpl) {
            this.v$usageSource = searchOperationImpl;
            this.this$0 = backgroundUsagesLogPage;
        }

        final class 1
        implements Runnable {
            public void run() {
                View.updateToolbarActions((Toolbar)3.this.this$0.getToolbar());
                BackgroundUsagesLogPage.ra$_progressBar(3.this.this$0).setVisible(true);
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                View.updateToolbarActions((Toolbar)3.this.this$0.getToolbar());
                BackgroundUsagesLogPage.ra$_progressBar(3.this.this$0).setVisible(false);
            }
        }
    }
}

