/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public class PreviewLogPage
extends UsagesLogPage
implements Controller,
ActionListener {
    public Icon getTabIcon() {
        return RefactoringArb.getIcon(261);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jrf_preview_log_html");
    }

    public static boolean showUsages(UsageSource usageSource) {
        PreviewLogPage previewDockable = new PreviewLogPage();
        previewDockable.setUsageSource(usageSource);
        return previewDockable.showPage();
    }

    protected void whenDoit() {
        UsageSource usageSource = this.getUsageSource();
        usageSource.doRefactoring();
        this.closePage();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId != UsagesLogPage.DO_REFACTORING_CMD_ID) {
            return super.handleEvent(action, context);
        }
        this.whenDoit();
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId != UsagesLogPage.DO_REFACTORING_CMD_ID) {
            return super.update(action, context);
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)source;
            String menuText = menuItem.getText();
            if (StringUtils.stripMnemonic((String)RefactoringArb.getString(295)).equals(menuText)) {
                this.setIncludedState(true);
                return;
            }
            if (StringUtils.stripMnemonic((String)RefactoringArb.getString(130)).equals(menuText)) {
                this.setIncludedState(false);
                return;
            }
        }
    }

    protected final void setIncludedState(boolean state) {
        ArrayList selectedLeafNodes = this.getSelectedLeafNodes();
        int i = 0;
        while (i < selectedLeafNodes.size()) {
            UsageNode usageNode = (UsageNode)selectedLeafNodes.get(i);
            UsagesLeaf usagesLeaf = (UsagesLeaf)usageNode.getUserObject();
            usagesLeaf.setIncludedStates(state);
            ++i;
        }
        JTree tree = this.getTree();
        tree.repaint();
    }

    protected Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        this.addRefreshButton(toolbar);
        this.addRunButton(toolbar);
        this.addShowMatchButton(toolbar);
        return toolbar;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        ArrayList affectedLeafNodes = this.getSelectedLeafNodes();
        boolean areAllValid = true;
        boolean hasPreviewNodes = false;
        boolean hasIncludedNodes = false;
        boolean hasExcludedNodes = false;
        int i = 0;
        while (i < affectedLeafNodes.size() && areAllValid) {
            UsageNode usageNode = (UsageNode)affectedLeafNodes.get(i);
            Object userObject = usageNode.getUserObject();
            if (userObject instanceof UsagesLeaf) {
                UsagesLeaf usagesLeaf = (UsagesLeaf)userObject;
                hasPreviewNodes = true;
                boolean isNodeValid = usagesLeaf.areAllValid();
                if (isNodeValid) {
                    boolean hasExcludedChanges;
                    boolean hasIncludedChanges = usagesLeaf.hasIncludedChanges();
                    if (hasIncludedChanges) {
                        hasIncludedNodes = true;
                    }
                    if (hasExcludedChanges = usagesLeaf.hasExcludedChanges()) {
                        hasExcludedNodes = true;
                    }
                } else {
                    areAllValid = false;
                }
            }
            ++i;
        }
        if (hasPreviewNodes) {
            if (hasExcludedNodes) {
                JMenuItem includeMenuItem = new JMenuItem(RefactoringArb.getIcon(162));
                ResourceUtils.resButton((AbstractButton)includeMenuItem, (String)RefactoringArb.getString(295));
                includeMenuItem.addActionListener(this);
                contextMenu.add((Component)includeMenuItem);
            }
            if (hasIncludedNodes) {
                JMenuItem excludeMenuItem = new JMenuItem(RefactoringArb.getIcon(341));
                ResourceUtils.resButton((AbstractButton)excludeMenuItem, (String)RefactoringArb.getString(130));
                excludeMenuItem.addActionListener(this);
                contextMenu.add((Component)excludeMenuItem);
            }
        }
        if (contextMenu.getMenuCount() != 0) {
            contextMenu.add((Component)new JSeparator());
        }
        super.menuWillShow(contextMenu);
    }

    private ArrayList getSelectedLeafNodes() {
        ArrayList<UsageNode> affectedLeafNodes = new ArrayList<UsageNode>();
        JTree tree = this.getTree();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            LinkedList<TreeNode> selectedNodes = new LinkedList<TreeNode>();
            int i = 0;
            while (i < selectionPaths.length) {
                TreePath selectionPath = selectionPaths[i];
                UsageNode usageNode = (UsageNode)selectionPath.getLastPathComponent();
                selectedNodes.add(usageNode);
                ++i;
            }
            while (!selectedNodes.isEmpty()) {
                UsageNode usageNode = (UsageNode)selectedNodes.removeFirst();
                int childCount = usageNode.getChildCount();
                if (childCount == 0) {
                    affectedLeafNodes.add(usageNode);
                    continue;
                }
                int i2 = 0;
                while (i2 < childCount) {
                    TreeNode childAt = usageNode.getChildAt(i2);
                    selectedNodes.add(childAt);
                    ++i2;
                }
            }
        }
        return affectedLeafNodes;
    }
}

