/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.Component;
import java.net.URL;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.sourcecolors.CodeTreeCellRenderer;
import oracle.jdevimpl.refactoring.preview.model.TreeBuilder;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public class UsageCellRenderer
extends CodeTreeCellRenderer {
    private static int _level = 0;
    private Object _value;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        block20: {
            try {
                Assert.check((++_level < 10 ? 1 : 0) != 0);
                this._value = value;
                if (!(this._value instanceof UsageNode)) break block20;
                UsageNode usageNode = (UsageNode)value;
                int nodeType = usageNode.getNodeType();
                switch (nodeType) {
                    case 4: {
                        UsagesLeaf usagesLeaf = (UsagesLeaf)usageNode.getUserObject();
                        value = usagesLeaf.getAttributedString();
                        this.setIcon(null);
                        Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                        return component;
                    }
                    case 3: {
                        TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)usageNode.getUserObject();
                        URL url = fileEntry.getUrl();
                        String fileString = URLFileSystem.getFileName((URL)url);
                        value = fileString;
                        Component treeCellRendererComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                        try {
                            Node node = NodeFactory.findOrCreate((URL)url);
                            if (node != null) {
                                Icon icon = node.getIcon();
                                this.setIcon(icon);
                                AccessibleContext ac = this.getAccessibleContext();
                                if (ac != null) {
                                    ac.setAccessibleName(fileString);
                                }
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        Component component = treeCellRendererComponent;
                        return component;
                    }
                    case 1: {
                        Component component = this.getMyCellRenderer(tree, value, sel, expanded, leaf, row, hasFocus, OracleIcons.getIcon((String)"package.png"));
                        return component;
                    }
                    case 5: {
                        Component component = this.getMyCellRenderer(tree, value, sel, expanded, leaf, row, hasFocus, OracleIcons.getIcon((String)"method.png"));
                        return component;
                    }
                    case 2: {
                        TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)usageNode.getUserObject();
                        URL url = fileEntry.getUrl();
                        String fileName = URLFileSystem.getPlatformPathName((URL)url);
                        Component component = this.getMyCellRenderer(tree, fileName, sel, expanded, leaf, row, hasFocus, OracleIcons.getIcon((String)"folder.png"));
                        return component;
                    }
                }
            }
            finally {
                --_level;
            }
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    private Component getMyCellRenderer(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus, Icon packageIcon) {
        try {
            Assert.check((++_level < 10 ? 1 : 0) != 0);
            Component treeCellRendererComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(packageIcon);
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null && treeCellRendererComponent instanceof JLabel) {
                ac.setAccessibleName(((JLabel)treeCellRendererComponent).getText());
            }
            Component component = treeCellRendererComponent;
            return component;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            --_level;
        }
    }

    public String getToolTipText() {
        String ret = null;
        if (this._value instanceof UsageNode) {
            UsageNode usageNode = (UsageNode)this._value;
            ret = usageNode.toString();
        }
        return ret;
    }
}

