/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.PeekableTree;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefactorAddin;
import oracle.jdevimpl.refactoring.preview.UsageCellRenderer;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.preview.model.TreeBuilder;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagesLogPage
extends AbstractLogPage
implements Controller,
ChangeListener,
TreeSelectionListener,
MouseListener,
PropertyChangeListener,
DragGestureListener,
DragSourceListener,
ContextMenuListener {
    public static int DO_REFACTORING_CMD_ID;
    public static int SHOW_MATCH_CMD_ID;
    public static int LOCK_PAGE_CMD_ID;
    public static int SHOW_METHODS_CMD_ID;
    protected static int CREATE_WORKINGSET_CMD_ID;
    static final String VIEW_TYPE = "REFACTORING";
    static final String VIEW_ID = "PREVIEW";
    private static int _id;
    private UsageSource _usageSource;
    private static boolean _actionsCreated;
    private JScrollPane _scrollPane;
    private UsageNode _root;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private boolean _mergeJavaAndNonJavaFiles;
    private Toolbar _toolbar;
    private ToggleToolButton _showMatchButton;
    private ToggleToolButton _lockPageButton;
    private ToggleToolButton _showMethodsButton;
    private ToolButton _runButton;
    private boolean _showMatchState;
    private boolean _lockPageState;
    private UsageModel _usageModel;

    private void $init$() {
        this._mergeJavaAndNonJavaFiles = false;
    }

    protected UsagesLogPage() {
        super(new ViewId(VIEW_TYPE, VIEW_ID + ++_id), null, false);
        this.$init$();
        UsagesLogPage.createActions();
        this.init();
    }

    protected void setUsageSource(UsageSource usageSource) {
        this.setUsageModel(null);
        this._usageSource = usageSource;
        if (this._usageSource != null) {
            UsageModel usageModel = this._usageSource.getUsageModel();
            this.setUsageModel(usageModel);
        }
    }

    public UsageSource getUsageSource() {
        return this._usageSource;
    }

    public static boolean showUsages(UsageSource usageSource, boolean useNewTab) {
        UsageModel usageModel = usageSource.getUsageModel();
        if (usageModel.getUsageEntries().size() != 0) {
            UsagesLogPage usagesLogPage = UsagesLogPage.findUsablePage(useNewTab);
            usagesLogPage.setUsageSource(usageSource);
            return usagesLogPage.showPage();
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(60), (String)RefactoringArb.getString(368), null);
        return true;
    }

    private static UsagesLogPage findUsablePage(boolean useNewTab) {
        if (!useNewTab) {
            LogManager logManager = LogManager.getLogManager();
            LogPage page = logManager.getSelectedPage();
            if (UsagesLogPage.isReusablePage(page)) {
                return (UsagesLogPage)page;
            }
            LogPage[] pages = logManager.getPages();
            int i = 0;
            while (i < pages.length) {
                LogPage page2 = pages[i];
                if (UsagesLogPage.isReusablePage(page2)) {
                    return (UsagesLogPage)page2;
                }
                ++i;
            }
        }
        return new UsagesLogPage();
    }

    private static boolean isReusablePage(LogPage logPage) {
        UsagesLogPage usagesLogPage;
        return logPage.getClass() == UsagesLogPage.class && !(usagesLogPage = (UsagesLogPage)logPage).isLocked();
    }

    protected boolean showPage() {
        String title = this.getTabName();
        super.tabNameUpdated();
        this.log(title);
        LogWindow logWindow = LogManager.getIdeLogWindow();
        boolean ret = DockStation.getDockStation().activateDockable((Dockable)logWindow);
        this.getGUI().requestFocus();
        return ret;
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return RefactoringArb.getIcon(71);
    }

    public String getTitleName() {
        return this._usageSource.getShortTitle();
    }

    public String getToolTip() {
        return this._usageSource.getLongTitle();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public Component getGUI() {
        if (this._scrollPane == null) {
            this.init();
        }
        return this._scrollPane;
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 51) {
            this.whenRefresh();
        } else if (commandId != SHOW_MATCH_CMD_ID && commandId != LOCK_PAGE_CMD_ID) {
            if (commandId == CREATE_WORKINGSET_CMD_ID) {
                this.whenCreateWorkingSet(context);
            } else if (commandId == 31) {
                this.whenNavigatePrev();
            } else if (commandId == 30) {
                this.whenNavigateNext();
            } else if (commandId == 12) {
                this.whenExport();
            } else if (commandId == SHOW_METHODS_CMD_ID) {
                this.updateTreeModel();
            } else {
                return false;
            }
        }
        return true;
    }

    private void whenNavigatePrev() {
        this.whenNavigate(-1, false);
    }

    private void whenNavigateNext() {
        this.whenNavigate(1, false);
    }

    private boolean whenNavigate(int direction, boolean forUpdate) {
        int newSelection;
        boolean ret = false;
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        ArrayList leafNodes = new ArrayList();
        this.getLeafNodes((TreeNode)model.getRoot(), leafNodes);
        TreePath selectionPath = this._tree.getSelectionPath();
        if (selectionPath != null) {
            Object lastPathComponent = selectionPath.getLastPathComponent();
            newSelection = leafNodes.indexOf(lastPathComponent) + direction;
        } else {
            newSelection = direction < 0 ? 0 : leafNodes.size() - 1;
        }
        if (0 <= newSelection && newSelection < leafNodes.size()) {
            if (!forUpdate) {
                TreeNode newSelectedObject = (TreeNode)leafNodes.get(newSelection);
                TreePath newSelectedPath = new TreePath(model.getPathToRoot(newSelectedObject));
                this._tree.expandPath(newSelectedPath);
                this._tree.setSelectionPath(newSelectedPath);
                UsagesLogPage.gotoPath(newSelectedPath, true);
            }
            ret = true;
        }
        return ret;
    }

    private void getLeafNodes(TreeNode root, ArrayList leafNodes) {
        int childCount = root.getChildCount();
        int i = 0;
        while (i < childCount) {
            TreeNode child = root.getChildAt(i);
            if (child.isLeaf()) {
                leafNodes.add(child);
            } else {
                this.getLeafNodes(child, leafNodes);
            }
            ++i;
        }
    }

    protected void whenCreateWorkingSet(Context context) {
        ArrayList usageEntries = this._usageModel.getUsageEntries();
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap<URL, List<URL>> projectUrlToFileUrl = new HashMap<URL, List<URL>>();
        int i = 0;
        while (i < usageEntries.size()) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                ArrayList<URL> urlList;
                URL url = usageEntry.getURL();
                Project project = usageEntry.getProject();
                URL projectURL = project.getURL();
                if (projectUrlToFileUrl.containsKey(projectURL)) {
                    urlList = (ArrayList<URL>)projectUrlToFileUrl.get(projectURL);
                } else {
                    projects.add(project);
                    urlList = new ArrayList<URL>();
                    projectUrlToFileUrl.put(projectURL, urlList);
                }
                if (!urlList.contains(url)) {
                    urlList.add(url);
                }
            }
            ++i;
        }
        this.whenCreateWorkingSet(context, projects, projectUrlToFileUrl);
    }

    private void whenCreateWorkingSet(Context context, List<Project> projects, Map<URL, List<URL>> projectUrlToFileUrl) {
        JLabel label = new JLabel();
        JTextField textField = new JTextField(this.getTitleName(), 20);
        ResourceUtils.resLabel((JLabel)label, (Component)textField, (String)RefactoringArb.getString(268));
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)textField, "Center");
        IdeMainWindow mainWindow = Ide.getMainWindow();
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_jrf_createworkingset_html");
        JEWTDialog dlg = new JEWTDialog((Frame)mainWindow, RefactoringArb.getString(231), 7);
        dlg.setContent((Component)panel);
        dlg.setResizable(true);
        dlg.addVetoableChangeListener((VetoableChangeListener)new 1(this, textField));
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            String workingSetName = textField.getText().trim();
            WorkingSets.getOrCreateWorkingSet((Workspace)context.getWorkspace(), (String)workingSetName, projects, projectUrlToFileUrl);
        }
    }

    private void whenExport() {
        URLChooser urlChooser = DialogUtil.newURLChooser();
        urlChooser.clearChooseableURLFilters();
        WildcardURLFilter urlFilter = new WildcardURLFilter("*.xml", false, RefactoringArb.getString(234));
        urlChooser.addChooseableURLFilter((URLFilter)urlFilter);
        urlChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        Component parent = this.getGUI();
        int ret = urlChooser.showSaveDialog(parent, RefactoringArb.getString(367));
        if (ret == 0) {
            XMLDocument xmlDocument = new XMLDocument();
            Element root = xmlDocument.createElement(RefactoringArb.getString(160));
            xmlDocument.appendChild((org.w3c.dom.Node)root);
            String longTitle = this._usageSource.getLongTitle();
            Comment comment = xmlDocument.createComment(longTitle);
            root.appendChild(comment);
            MultiMap urlToEntries = new MultiMap();
            ArrayList usageEntries = this._usageModel.getUsageEntries();
            int i = 0;
            while (i < usageEntries.size()) {
                BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
                URL url = usageEntry.getURL();
                urlToEntries.add((Object)url, (Object)usageEntry);
                ++i;
            }
            ArrayList urls = new ArrayList(urlToEntries.keySet());
            int i2 = 0;
            while (i2 < urls.size()) {
                URL url = (URL)urls.get(i2);
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    Element urlHits = xmlDocument.createElement("url-hits");
                    String urlName = url.toString();
                    urlHits.setAttribute("name", urlName);
                    List entries = urlToEntries.get((Object)url);
                    int j = 0;
                    while (j < entries.size()) {
                        BaseUsageEntry usageEntry = (BaseUsageEntry)entries.get(j);
                        XMLElement hitElement = (XMLElement)xmlDocument.createElement("hit");
                        int offset = usageEntry.getOffset();
                        hitElement.setAttribute("offset", Integer.toString(offset));
                        int length = usageEntry.getLength();
                        int line = lineMap.getLineFromOffset(offset);
                        hitElement.setAttribute("line", Integer.toString(line));
                        String string = textBuffer.getString(offset, length);
                        Text text = xmlDocument.createTextNode("text#");
                        text.setNodeValue(string);
                        hitElement.appendChild((org.w3c.dom.Node)text);
                        urlHits.appendChild((org.w3c.dom.Node)hitElement);
                        ++j;
                    }
                    root.appendChild(urlHits);
                    textNode.releaseTextBuffer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i2;
            }
            try {
                URL selectedURL = urlChooser.getSelectedURL();
                OutputStream outputStream = URLFileSystem.openOutputStream((URL)selectedURL);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                xmlDocument.print((OutputStream)bufferedOutputStream);
                bufferedOutputStream.close();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 51 || commandId == SHOW_METHODS_CMD_ID) {
            boolean canRefresh = this.canSearch();
            action.setEnabled(canRefresh);
        } else if (commandId == SHOW_MATCH_CMD_ID || commandId == LOCK_PAGE_CMD_ID || commandId == CREATE_WORKINGSET_CMD_ID || commandId == 12) {
            action.setEnabled(true);
        } else if (commandId == 31) {
            boolean enabled = this.whenNavigate(-1, true);
            action.setEnabled(enabled);
        } else if (commandId == 30) {
            boolean enabled = this.whenNavigate(1, true);
            action.setEnabled(enabled);
        } else {
            return false;
        }
        return true;
    }

    protected void whenRefresh() {
        this._usageSource.doSearch();
        UsageModel usageModel = this._usageSource.getUsageModel();
        this.setUsageModel(usageModel);
    }

    private static void createActions() {
        if (!_actionsCreated) {
            String label = RefactoringArb.getString(34);
            SHOW_MATCH_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.SHOW_MATCHING_CODE");
            IdeAction showMatchAction = IdeAction.get((int)SHOW_MATCH_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)RefactoringArb.getIcon(354), null, (boolean)true);
            showMatchAction.putValue("Check", (Object)Boolean.TRUE);
            String label2 = RefactoringArb.getString(52);
            LOCK_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.LOCK_PAGE");
            IdeAction lockPageAction = IdeAction.get((int)LOCK_PAGE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label2), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label2)), (Icon)RefactoringArb.getIcon(88), null, (boolean)true);
            lockPageAction.putValue("Check", (Object)Boolean.TRUE);
            String label3 = RefactoringArb.getString(146);
            CREATE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.CREATE_WORKINGSET");
            IdeAction.get((int)CREATE_WORKINGSET_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label3), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label3)), null, null, (boolean)true);
            String doRefactoringLabel = RefactoringArb.getString(166);
            DO_REFACTORING_CMD_ID = Ide.findOrCreateCmdID((String)"REFACTORING_PREVIEW.GO");
            IdeAction.get((int)DO_REFACTORING_CMD_ID, null, (String)StringUtils.stripMnemonic((String)doRefactoringLabel), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)doRefactoringLabel)), (Icon)RefactoringArb.getIcon(226), null, (boolean)true);
            String label4 = RefactoringArb.getString(184);
            SHOW_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"USAGES.SHOW_METHODS");
            IdeAction showMethodsAction = IdeAction.get((int)SHOW_METHODS_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label4), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label4)), (Icon)OracleIcons.getIcon((String)"method.png"), null, (boolean)true);
            showMethodsAction.putValue("Check", (Object)Boolean.TRUE);
            _actionsCreated = true;
        }
    }

    public void close() {
        super.close();
        this.release();
        this._toolbar.dispose();
        this._toolbar.removeAll();
    }

    public void closePage() {
        LogManager logManager = LogManager.getLogManager();
        logManager.removePage((LogPage)this);
    }

    public boolean isLocked() {
        boolean ret = false;
        if (this._scrollPane != null) {
            ret = this._lockPageButton == null ? true : this._lockPageButton.isSelected();
        }
        return ret;
    }

    public IdeAction getAction(int cmd_id) {
        IdeAction action = IdeAction.find((int)cmd_id);
        IdeAction ret = action.newLocalAction((View)this);
        ret.setEnabled(true);
        return ret;
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        RefactorAddin instance = RefactorAddin.getInstance();
        instance.setPreferenceFlag(1, this._showMatchButton.isSelected());
        if (this._showMethodsButton != null) {
            instance.setPreferenceFlag(1, this._showMethodsButton.isSelected());
        }
    }

    @Override
    public final void valueChanged(TreeSelectionEvent e) {
        TreePath newLeadSelectionPath;
        if (this._showMatchButton != null && this._showMatchButton.isSelected() && (newLeadSelectionPath = e.getNewLeadSelectionPath()) != null) {
            UsagesLogPage.gotoPath(newLeadSelectionPath, false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.handleContextMenu(e) && e.getClickCount() == 2) {
            this.whenTreeDefaultAction();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleContextMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleContextMenu(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private boolean handleContextMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e);
            return true;
        }
        return false;
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        return contextMenu;
    }

    private void showContextMenu(MouseEvent e) {
        Point point = e.getPoint();
        JTree tree = this.getTree();
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        TreePath[] selectionPaths = selectionModel.getSelectionPaths();
        TreePath pathAtPt = tree.getPathForLocation(point.x, point.y);
        if (pathAtPt != null) {
            boolean mustChangeSel = true;
            if (selectionPaths != null) {
                int i = 0;
                while (i < selectionPaths.length) {
                    TreePath selectionPath = selectionPaths[i];
                    if (pathAtPt.equals(selectionPath)) {
                        mustChangeSel = false;
                    }
                    ++i;
                }
            }
            if (mustChangeSel) {
                selectionModel.setSelectionPath(pathAtPt);
            }
        }
        ContextMenu contextMenu = this.getContextMenu();
        Context ctxMenuContext = this.getContext(e);
        contextMenu.show(ctxMenuContext);
    }

    private static void gotoPath(TreePath anchorPath, boolean focusEditor) {
        UsageNode usageNode = (UsageNode)anchorPath.getLastPathComponent();
        Object userObject = usageNode.getUserObject();
        if (userObject instanceof UsagesLeaf) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)userObject;
            usagesLeaf.goToChange(focusEditor);
        }
    }

    private Peek createPeek(TreePath tp) {
        int pad;
        int offset;
        UsagesLeaf usagesLeaf;
        URL url;
        Pair ret;
        UsageNode usageNode = (UsageNode)tp.getLastPathComponent();
        Object userObject = usageNode.getUserObject();
        if (userObject instanceof UsagesLeaf && (ret = PeekHelper.getPeekTextByOffset((URL)(url = (usagesLeaf = (UsagesLeaf)userObject).getURL()), (int)(offset = usagesLeaf.getFirstOffset()), (int)(pad = 4))) != null) {
            Rectangle rect = this._tree.getPathBounds(tp).intersection(this._tree.getVisibleRect());
            CodePeek peek = PeekHelper.createCodePeek((JComponent)this._tree, (String)url.getFile(), (String)((String)ret.first), (String)URLFileSystem.getFileName((URL)url), (Rectangle)rect);
            PeekHelper.addHighlight((CodePeek)peek, (int)((Integer)ret.second < pad ? (Integer)ret.second : pad), (String)"caret-line-highlight");
            return peek;
        }
        return null;
    }

    protected JTree getTree() {
        return this._tree;
    }

    protected void whenTreeDefaultAction() {
        this.goToSelectedNode(true);
    }

    private void goToSelectedNode(boolean focusEditor) {
        TreePath anchorSelectionPath = this.getTree().getAnchorSelectionPath();
        if (anchorSelectionPath != null) {
            UsagesLogPage.gotoPath(anchorSelectionPath, focusEditor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName() == "VALID") {
            BaseUsageEntry usageEntry = (BaseUsageEntry)event.getSource();
            Object newValue = event.getNewValue();
            boolean isValid = Boolean.TRUE.equals(newValue);
            this.whenValidityChanges(usageEntry, isValid);
            this._root.whenUsageEntryChanged(usageEntry, event);
            View.updateToolbarActions((Toolbar)this._toolbar);
        }
        this._scrollPane.repaint();
    }

    protected void init() {
        this.createTree();
        this._toolbar = this.createToolbar();
        this._scrollPane = new JScrollPane(this._tree);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        this._scrollPane.setBorder(emptyBorder);
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this._tree, 3, this);
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jed_usages_log_html");
    }

    protected Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        this.addRefreshButton(toolbar);
        this.addShowMatchButton(toolbar);
        this.addLockPageButton(toolbar);
        this.addShowMethodsButton(toolbar);
        return toolbar;
    }

    protected final void addRefreshButton(Toolbar toolbar) {
        IdeAction refreshAction = this.getAction(51);
        toolbar.add((ToggleAction)refreshAction);
    }

    protected final void addRunButton(Toolbar toolbar) {
        IdeAction runAction = this.getAction(DO_REFACTORING_CMD_ID);
        this._runButton = toolbar.add((ToggleAction)runAction);
    }

    protected final void addShowMatchButton(Toolbar toolbar) {
        IdeAction showMatchAction = this.getAction(SHOW_MATCH_CMD_ID);
        this._showMatchButton = toolbar.addToggleButton((ToggleAction)showMatchAction);
        RefactorAddin instance = RefactorAddin.getInstance();
        boolean initialState = instance.getPreferenceFlag(1);
        this._showMatchButton.setSelected(initialState);
        ButtonModel showMatchModel = this._showMatchButton.getModel();
        showMatchModel.addChangeListener(this);
    }

    protected final void addLockPageButton(Toolbar toolbar) {
        IdeAction lockPageAction = this.getAction(LOCK_PAGE_CMD_ID);
        this._lockPageButton = toolbar.addToggleButton((ToggleAction)lockPageAction);
    }

    protected final void addShowMethodsButton(Toolbar toolbar) {
        IdeAction showMethodsAction = this.getAction(SHOW_METHODS_CMD_ID);
        this._showMethodsButton = toolbar.addToggleButton((ToggleAction)showMethodsAction);
        boolean initialState = RefactorAddin.getInstance().getPreferenceFlag(1);
        this._showMethodsButton.setSelected(initialState);
        ButtonModel showMethodsModel = this._showMethodsButton.getModel();
        showMethodsModel.addChangeListener(this);
    }

    private void createTree() {
        this._root = new UsageNode((Object)"x", 0);
        this._treeModel = new DefaultTreeModel(this._root);
        this._treeModel.addTreeModelListener(new 2());
        this._tree = new 3(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setRowHeight(-1);
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        selectionModel.addTreeSelectionListener(this);
        UsageCellRenderer cellRenderer = new UsageCellRenderer();
        this._tree.setCellRenderer(cellRenderer);
        this._tree.setShowsRootHandles(true);
        this._tree.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        4 enterAction = new 4();
        InputMap inputMap = this._tree.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), enterAction);
        this._tree.getActionMap().put(enterAction, enterAction);
    }

    public boolean canSearch() {
        return this._usageSource.canSearch();
    }

    protected void setMergeJavaAndNonJavaFiles(boolean merge) {
        this._mergeJavaAndNonJavaFiles = merge;
    }

    private void release() {
        this.setUsageModel(null);
    }

    protected void setUsageModel(UsageModel usageModel) {
        if (this._usageModel != null) {
            this._usageModel.release();
            this._usageModel.removePropertyChangeListener(this);
        }
        this._usageModel = usageModel;
        if (this._usageModel != null) {
            this._usageModel.addPropertyChangeListener(this);
            this.whenValidityChanges(null, true);
            this.updateTreeModel();
        }
    }

    protected void updateUsageModel(UsageModel usageModel, UsageModel added) {
        if (this._usageModel != null) {
            this._usageModel.removePropertyChangeListener(this);
        }
        this._usageModel = usageModel;
        this._usageModel.addPropertyChangeListener(this);
        Context context = this._usageSource.getContext();
        TreeBuilder treeBuilder = new TreeBuilder();
        PerformanceLogger.get().startTiming("UsagesLogPage.updateUsageModel");
        try {
            treeBuilder.build_by_packages(context, added, this._treeModel, this._mergeJavaAndNonJavaFiles, true);
        }
        finally {
            PerformanceLogger.get().stopTiming("UsagesLogPage.updateUsageModel", "Added usages to tree", 200);
        }
    }

    private void updateTreeModel() {
        this._root.removeAllChildren();
        this._treeModel.nodeStructureChanged(this._root);
        Context context = this._usageSource.getContext();
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.build_by_packages(context, this._usageModel, this._treeModel, this._mergeJavaAndNonJavaFiles, true);
        this._tree.setRootVisible(true);
        IdeUtil.expandAllTreeRows((JTree)this._tree);
        this._tree.setRootVisible(false);
    }

    protected void whenValidityChanges(BaseUsageEntry usageEntry, boolean valid) {
        if (this._runButton != null) {
            this._runButton.setEnabled(valid);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        UsageNode usageNode;
        Object userObject;
        JTree tree = this.getTree();
        Point pt = dge.getDragOrigin();
        TreePath treePath = tree.getPathForLocation(pt.x, pt.y);
        if (treePath != null && (userObject = (usageNode = (UsageNode)treePath.getLastPathComponent()).getUserObject()) instanceof TreeBuilder.FileEntry) {
            TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)userObject;
            URL url = fileEntry.getUrl();
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                Context transferableContext = new Context((View)this, fileEntry.getWorkspace(), fileEntry.getProject(), node);
                TransferableContext transferable = new TransferableContext(transferableContext);
                DragSource dragSource = DragSource.getDefaultDragSource();
                dragSource.startDrag(dge, null, (Transferable)transferable, this);
            }
            catch (InvalidDnDOperationException e) {
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        IdeAction action = IdeAction.find((int)12);
        action.updateAction();
        JMenuItem menuItem = new JMenuItem((Action)action);
        contextMenu.add((Component)menuItem);
        IdeAction action2 = IdeAction.find((int)CREATE_WORKINGSET_CMD_ID);
        action2.updateAction();
        JMenuItem menuItem2 = new JMenuItem((Action)action2);
        contextMenu.add((Component)menuItem2);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean isLockPageState() {
        return this._lockPageState;
    }

    public void setLockPageState(boolean lockPageState) {
        this._lockPageState = lockPageState;
    }

    public boolean isShowMatchState() {
        return this._showMatchState;
    }

    public void setShowMatchState(boolean showMatchState) {
        this._showMatchState = showMatchState;
    }

    static JTree ra$_tree(UsagesLogPage usagesLogPage) {
        return usagesLogPage._tree;
    }

    static Peek mav$createPeek(UsagesLogPage usagesLogPage, TreePath treePath) {
        return usagesLogPage.createPeek(treePath);
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ JTextField v$textField;
        final /* synthetic */ UsagesLogPage this$0;

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("closed") && Boolean.TRUE.equals(evt.getNewValue()) && this.v$textField.getText().length() == 0) {
                throw new PropertyVetoException(RefactoringArb.getString(331), evt);
            }
        }

        public 1(UsagesLogPage usagesLogPage, JTextField jTextField) {
            this.v$textField = jTextField;
            this.this$0 = usagesLogPage;
        }
    }

    final class 2
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            UsagesLogPage.ra$_tree(UsagesLogPage.this).expandPath(path);
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            TreeNode node = (TreeNode)path.getLastPathComponent();
            int[] children = e.getChildIndices();
            if (children != null) {
                int[] nArray = children;
                int n = 0;
                while (n < nArray.length) {
                    int i = nArray[n];
                    TreePath childPath = path.pathByAddingChild(node.getChildAt(i));
                    this.expandAll(childPath);
                    ++n;
                }
            } else {
                IdeUtil.expandAllTreeRows((JTree)UsagesLogPage.ra$_tree(UsagesLogPage.this));
            }
        }

        private void expandAll(TreePath path) {
            UsagesLogPage.ra$_tree(UsagesLogPage.this).expandPath(path);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            int i = 0;
            while (i < node.getChildCount()) {
                this.expandAll(path.pathByAddingChild(node.getChildAt(i)));
                ++i;
            }
        }
    }

    final class 3
    extends PeekableTree {
        public Peek createPeek(TreePath tp) {
            return UsagesLogPage.mav$createPeek(UsagesLogPage.this, tp);
        }

        public 3(TreeModel treeModel) {
            super(treeModel);
        }
    }

    final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            UsagesLogPage.this.whenTreeDefaultAction();
        }
    }
}

