/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.net.URL;
import java.text.AttributedString;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.sourcecolors.SourceColorizer;

public class ParseOptimizer {
    private MultiMap<URL, Entry> _urlToOffset;

    private void $init$() {
        this._urlToOffset = new MultiMap();
    }

    public void addOffset(URL url, int offset) {
        Entry entry = new Entry(offset);
        this._urlToOffset.add((Object)url, (Object)entry);
    }

    public void run() {
        Set urls = this._urlToOffset.keySet();
        for (URL url : urls) {
            this.parseURL(url);
        }
    }

    public AttributedString getAttributedString(URL url, int offset) {
        for (Entry entry : this._urlToOffset.get((Object)url)) {
            if (entry._offset != offset) continue;
            return entry._attributedString;
        }
        return null;
    }

    private void parseURL(URL url) {
        try {
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
            String language = SourceColorizer.getLanguage(url);
            TextBuffer textBuffer = node.acquireTextBuffer();
            try {
                textBuffer.readLock();
                try {
                    String code = textBuffer.getString(0, textBuffer.getLength());
                    LineMap lineMap = textBuffer.getLineMap();
                    List segments = this._urlToOffset.get((Object)url);
                    Collections.sort(segments);
                    int[] startOffsets = new int[segments.size()];
                    int[] endOffsets = new int[segments.size()];
                    int i = 0;
                    while (i < segments.size()) {
                        Entry entry = (Entry)segments.get(i);
                        int line = lineMap.getLineFromOffset(entry._offset);
                        startOffsets[i] = lineMap.getLineStartOffset(line);
                        endOffsets[i] = lineMap.getLineEndOffset(line);
                        ++i;
                    }
                    AttributedString[] attributedStrings = SourceColorizer.toAttributedString(language, code, startOffsets, endOffsets);
                    int i2 = 0;
                    while (i2 < attributedStrings.length) {
                        Entry entry = (Entry)segments.get(i2);
                        entry._attributedString = attributedStrings[i2];
                        ++i2;
                    }
                }
                finally {
                    textBuffer.readUnlock();
                }
            }
            finally {
                node.releaseTextBuffer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParseOptimizer() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry
    implements Comparable {
        int _offset;
        AttributedString _attributedString;

        public Entry(int offset) {
            this._offset = offset;
        }

        public int compareTo(Object o) {
            Entry other = (Entry)o;
            return this._offset - other._offset;
        }
    }
}

