/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.net.URL;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.RefactorAddin;
import oracle.jdevimpl.refactoring.preview.model.ParseOptimizer;
import oracle.jdevimpl.refactoring.preview.model.UsageNode;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

public final class TreeBuilder {
    private static final boolean DEBUG = false;
    private ArrayList<UsageNode> _usageLeaves;
    private boolean _showMethods;

    private void $init$() {
        this._usageLeaves = new ArrayList();
    }

    public UsageNode build_by_packages(Context context, UsageModel model, DefaultTreeModel treeModel, boolean mergeJavaAndNonJava, boolean mergeEntriesPerLine) {
        long t0 = 0L;
        this._showMethods = RefactorAddin.getInstance().getPreferenceFlag(1);
        ArrayList usageEntries = model.getUsageEntries();
        UsageNode packagesRoot = (UsageNode)treeModel.getRoot();
        Workspace workspace = context.getWorkspace();
        Project lastProject = null;
        ContentSet lastContents = null;
        URLPath libUrlPaths = new URLPath();
        int i = 0;
        while (i < usageEntries.size()) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
            Project project = usageEntry.getProject();
            URL url = usageEntry.getURL();
            FileEntry fileEntry = new FileEntry(workspace, project, url);
            URL directory = URLFileSystem.getParent((URL)url);
            UsageNode directoryNode = null;
            if (!mergeJavaAndNonJava && Util.isJavaSource(url)) {
                String relativePath;
                if (project != lastProject) {
                    libUrlPaths = new URLPath();
                    lastContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
                    JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
                    JDK jdk = jProjectLibraries.getJDK();
                    URLPath jdkSourcePath = jdk.getSourcePath();
                    libUrlPaths.add(jdkSourcePath);
                    JLibrary[] libraryList = jProjectLibraries.getLibraries();
                    int j = 0;
                    while (j < libraryList.length) {
                        JLibrary library = libraryList[j];
                        URLPath libSourcePath = library.getSourcePath();
                        libUrlPaths.add(libSourcePath);
                        ++j;
                    }
                    lastProject = project;
                }
                if ((relativePath = lastContents.toRelativePath(directory)) == null) {
                    relativePath = libUrlPaths.toRelativePath(url);
                }
                if (relativePath != null) {
                    String packageName = relativePath.replace('/', '.');
                    if (packageName.endsWith(".")) {
                        packageName = packageName.substring(0, packageName.length() - 1);
                    }
                    directoryNode = this.getOrCreateNode(treeModel, packagesRoot, packageName, 1);
                } else {
                    Assert.println((String)("Cannot find " + URLFileSystem.getPlatformPathName((URL)directory) + " in " + project.getShortLabel()));
                }
            } else {
                FileEntry directoryEntry = new FileEntry(workspace, project, directory);
                directoryNode = this.getOrCreateNode(treeModel, packagesRoot, directoryEntry, 2);
            }
            if (directoryNode != null) {
                UsageNode fileNode = this.getOrCreateNode(treeModel, directoryNode, fileEntry, 3);
                this.getOrCreateLeafNode(treeModel, fileNode, usageEntry, mergeEntriesPerLine);
            }
            ++i;
        }
        long t1 = 0L;
        ParseOptimizer parseOptimizer = new ParseOptimizer();
        for (UsageNode node : this._usageLeaves) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)node.getUserObject();
            URL url = usagesLeaf.getURL();
            parseOptimizer.addOffset(url, usagesLeaf.getFirstOffset());
        }
        parseOptimizer.run();
        for (UsageNode node : this._usageLeaves) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)node.getUserObject();
            URL url = usagesLeaf.getURL();
            AttributedString attributedString = parseOptimizer.getAttributedString(url, usagesLeaf.getFirstOffset());
            usagesLeaf.setAttributedString(attributedString);
            treeModel.nodeChanged(node);
        }
        return packagesRoot;
    }

    private UsageNode getOrCreateNode(DefaultTreeModel treeModel, UsageNode rootNode, Object userObject, int nodeType) {
        UsageNode node;
        String label = UsageNode.toString(nodeType, userObject);
        int index = rootNode.getInsertionPosition(label);
        if (index < rootNode.getChildCount() && label.equals((node = (UsageNode)rootNode.getChildAt(index)).toString())) {
            return node;
        }
        UsageNode node2 = new UsageNode(userObject, nodeType);
        treeModel.insertNodeInto(node2, rootNode, index);
        return node2;
    }

    private void getOrCreateLeafNode(DefaultTreeModel treeModel, UsageNode fileNode, BaseUsageEntry usageEntry, boolean mergeEntriesPerLine) {
        UsageNode node = null;
        int childCount = fileNode.getChildCount();
        int i = 0;
        while (node == null && i < childCount) {
            UsageNode nodeAt_i = (UsageNode)fileNode.getChildAt(i);
            if (nodeAt_i.getNodeType() == 5) {
                int methodChildCount = nodeAt_i.getChildCount();
                int j = 0;
                while (node == null && j < methodChildCount) {
                    UsageNode nodeAt_j = (UsageNode)nodeAt_i.getChildAt(j);
                    node = this._mergeOrCreateLeafNode(treeModel, fileNode, nodeAt_j, usageEntry, mergeEntriesPerLine);
                    ++j;
                }
            } else {
                node = this._mergeOrCreateLeafNode(treeModel, fileNode, nodeAt_i, usageEntry, mergeEntriesPerLine);
            }
            ++i;
        }
        if (node == null) {
            UsagesLeaf usagesLeaf = new UsagesLeaf();
            usagesLeaf.addChange(usageEntry);
            node = new UsageNode((Object)usagesLeaf, 4);
            this._attemptToAddToNode(treeModel, node, fileNode, usageEntry);
            this._usageLeaves.add(node);
        }
    }

    private UsageNode _mergeOrCreateLeafNode(DefaultTreeModel treeModel, UsageNode fileNode, UsageNode leafNode, BaseUsageEntry usageEntry, boolean mergeEntriesPerLine) {
        UsageNode node = null;
        UsagesLeaf usagesLeaf_i = (UsagesLeaf)leafNode.getUserObject();
        if (mergeEntriesPerLine) {
            if (usagesLeaf_i.isSameLine(usageEntry)) {
                usagesLeaf_i.addChange(usageEntry);
                node = leafNode;
            }
        } else {
            int firstOffset = usagesLeaf_i.getFirstOffset();
            if (usageEntry.getOffset() > firstOffset) {
                UsagesLeaf usagesLeaf = new UsagesLeaf();
                usagesLeaf.addChange(usageEntry);
                node = new UsageNode((Object)usagesLeaf, 4);
                this._attemptToAddToNode(treeModel, node, fileNode, usageEntry);
                this._usageLeaves.add(node);
            }
        }
        return node;
    }

    private void _addToTree(DefaultTreeModel treeModel, UsageNode node, UsageNode parent) {
        treeModel.insertNodeInto(node, parent, parent.getInsertionPosition(node));
    }

    private void _attemptToAddToNode(DefaultTreeModel treeModel, UsageNode node, UsageNode fileNode, BaseUsageEntry usageEntry) {
        if (this._showMethods) {
            this._attemptToAddToMethodNode(treeModel, node, fileNode, usageEntry);
        } else {
            this._addToTree(treeModel, node, fileNode);
        }
    }

    private void _attemptToAddToMethodNode(DefaultTreeModel treeModel, UsageNode node, UsageNode fileNode, BaseUsageEntry usageEntry) {
        SourceElement sourceElement = null;
        if (usageEntry.getUserObject() instanceof SourceElement) {
            sourceElement = (SourceElement)usageEntry.getUserObject();
        }
        if (usageEntry instanceof SourceElementEntry) {
            sourceElement = ((SourceElementEntry)usageEntry).getSourceElement();
        }
        if (sourceElement != null) {
            SourceMethod method = this._findParentMethod(sourceElement);
            if (method == null) {
                this._addToTree(treeModel, node, fileNode);
            } else {
                String methodName = this._createMethodName(method);
                boolean bAdded = false;
                int i = 0;
                while (i < fileNode.getChildCount()) {
                    UsageNode possibleMethodNode = (UsageNode)fileNode.getChildAt(i);
                    if (possibleMethodNode.getNodeType() == 5 && possibleMethodNode.toString().equals(methodName)) {
                        this._addToTree(treeModel, node, possibleMethodNode);
                        bAdded = true;
                        break;
                    }
                    ++i;
                }
                if (!bAdded) {
                    UsageNode newMethodNode = new UsageNode((Object)methodName, 5);
                    this._addToTree(treeModel, newMethodNode, fileNode);
                    treeModel.insertNodeInto(node, newMethodNode, 0);
                }
            }
        } else {
            treeModel.insertNodeInto(node, fileNode, fileNode.getChildCount());
        }
    }

    private String _createMethodName(SourceMethod sourceMethod) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(sourceMethod.isConstructor() ? sourceMethod.getOwningClass().getName() : sourceMethod.getName());
        buffer.append("(");
        Collection parameters = sourceMethod.getParameters();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            JavaVariable param = (JavaVariable)iterator.next();
            buffer.append(param.getUnresolvedType().getSimplifiedName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private SourceMethod _findParentMethod(SourceElement sourceElement) {
        SourceElement parent = sourceElement.getParent();
        while (parent != null && !(parent instanceof SourceMethod)) {
            parent = parent.getParent();
        }
        return (SourceMethod)parent;
    }

    public TreeBuilder() {
        this.$init$();
    }

    public class FileEntry {
        private Workspace _workspace;
        private Project _project;
        private URL _url;

        public FileEntry(Workspace workspace, Project project, URL url) {
            this._workspace = workspace;
            this._project = project;
            this._url = url;
        }

        public Workspace getWorkspace() {
            return this._workspace;
        }

        public Project getProject() {
            return this._project;
        }

        public URL getUrl() {
            return this._url;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileEntry) {
                FileEntry that = (FileEntry)obj;
                if (ModelUtil.areEqual((Object)this._url, (Object)that._url)) {
                    return true;
                }
            }
            return false;
        }
    }
}

