/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.StringComparator;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdevimpl.refactoring.preview.model.TreeBuilder;
import oracle.jdevimpl.refactoring.preview.model.UsagesLeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageNode
extends DefaultMutableTreeNode
implements Comparable {
    public static final int NODE_TYPE_OTHER = 0;
    public static final int NODE_TYPE_PACKAGE = 1;
    public static final int NODE_TYPE_DIRECTORY = 2;
    public static final int NODE_TYPE_FILE = 3;
    public static final int NODE_TYPE_TEXT_LINE = 4;
    public static final int NODE_TYPE_METHOD = 5;
    private int _nodeType;

    public UsageNode() {
        this(null, 0);
    }

    public UsageNode(Object userObject, int nodeType) {
        super(userObject);
        this._nodeType = nodeType;
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public UsageNode getUsageNodeAt(int index) {
        return (UsageNode)super.getChildAt(index);
    }

    public void whenUsageEntryChanged(BaseUsageEntry usageEntry, PropertyChangeEvent event) {
        if (this.getNodeType() == 4) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this.getUserObject();
            usagesLeaf.whenUsageEntryChanged(usageEntry, event);
        }
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            UsageNode usageNode = this.getUsageNodeAt(i);
            usageNode.whenUsageEntryChanged(usageEntry, event);
            ++i;
        }
    }

    @Override
    public String toString() {
        int nodeType = this.getNodeType();
        Object userObject = this.getUserObject();
        String ret = UsageNode.toString(nodeType, userObject);
        return ret;
    }

    public static String toString(int nodeType, Object userObject) {
        String ret;
        switch (nodeType) {
            case 4: {
                UsagesLeaf usagesLeaf = (UsagesLeaf)userObject;
                TextNode textNode = usagesLeaf.getTextNode();
                String longLabel = textNode.getLongLabel();
                if (usagesLeaf.areAllValid()) {
                    try {
                        int offset = usagesLeaf.getFirstOffset();
                        TextBuffer textBuffer = textNode.acquireTextBuffer();
                        LineMap lineMap = textBuffer.getLineMap();
                        int line = lineMap.getLineFromOffset(offset);
                        ret = longLabel = longLabel + ":" + (line + 1);
                        break;
                    }
                    finally {
                        textNode.releaseTextBuffer();
                    }
                }
                ret = null;
                break;
            }
            case 3: {
                TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)userObject;
                URL url = fileEntry.getUrl();
                ret = URLFileSystem.getPlatformPathName((URL)url);
                break;
            }
            case 1: {
                ret = (String)userObject;
                break;
            }
            case 2: {
                TreeBuilder.FileEntry fileEntry = (TreeBuilder.FileEntry)userObject;
                URL url = fileEntry.getUrl();
                ret = URLFileSystem.getPlatformPathName((URL)url);
                break;
            }
            case 5: {
                ret = (String)userObject;
                break;
            }
            default: {
                ret = "_";
                break;
            }
        }
        return ret;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
    }

    public int getInsertionPosition(UsageNode child) {
        return this.getInsertionPosition(child, null);
    }

    public int getInsertionPosition(String label) {
        return this.getInsertionPosition((Comparable)((Object)label), (Comparator)new StringComparator());
    }

    public int getInsertionPosition(Comparable obj, Comparator comparator) {
        int top = 0;
        int bottom = this.getChildCount();
        while (true) {
            int compare;
            int spread = top - bottom;
            switch (spread) {
                case 0: {
                    return top;
                }
                case 1: {
                    UsageNode topNode = (UsageNode)this.children.get(top);
                    int compare2 = comparator == null ? obj.compareTo(topNode) : comparator.compare(obj, topNode);
                    return compare2 <= 0 ? top : bottom;
                }
            }
            int middle = top + bottom >> 1;
            UsageNode middleNode = (UsageNode)this.children.get(middle);
            int n = compare = comparator == null ? obj.compareTo(middleNode) : comparator.compare(obj, middleNode);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                bottom = middle;
                continue;
            }
            top = middle + 1;
        }
    }

    public int compareTo(Object o) {
        int ret;
        int thatNodeType;
        UsageNode that = (UsageNode)o;
        int thisNodeType = this.getNodeType();
        if (thisNodeType == (thatNodeType = that.getNodeType())) {
            switch (thisNodeType) {
                case 4: {
                    UsagesLeaf thisLeaf = (UsagesLeaf)this.getUserObject();
                    UsagesLeaf thatLeaf = (UsagesLeaf)that.getUserObject();
                    int thisOffset = thisLeaf.getFirstOffset();
                    int thatOffset = thatLeaf.getFirstOffset();
                    ret = thisOffset - thatOffset;
                    break;
                }
                default: {
                    String thisString = this.toString();
                    String thatString = that.toString();
                    ret = thisString.compareToIgnoreCase(thatString);
                    break;
                }
            }
        } else {
            ret = thisNodeType - thatNodeType;
        }
        return ret;
    }

    public int getHitCount() {
        int ret = 0;
        if (this._nodeType == 4) {
            UsagesLeaf usagesLeaf = (UsagesLeaf)this.getUserObject();
            ret = usagesLeaf.getEntryCount();
        } else {
            int i = 0;
            while (i < this.children.size()) {
                UsageNode childNode = (UsageNode)this.children.elementAt(i);
                ret += childNode.getHitCount();
                ++i;
            }
        }
        return ret;
    }
}

