/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.preview.model;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;

public class UsagesLeaf {
    private ArrayList<BaseUsageEntry> _usageEntries;
    private AttributedString _baseAttributedString;
    private AttributedString _attributedString;

    private void $init$() {
        this._usageEntries = new ArrayList(2);
    }

    public UsagesLeaf() {
        this.$init$();
    }

    public void addChange(BaseUsageEntry usageEntry) {
        int offset = usageEntry.getOffset();
        boolean isDup = false;
        int bestInsertionPlace = 0;
        while (bestInsertionPlace < this._usageEntries.size()) {
            BaseUsageEntry change_i = this._usageEntries.get(bestInsertionPlace);
            int offset_i = change_i.getOffset();
            if (offset == offset_i) {
                isDup = true;
                break;
            }
            if (offset <= offset_i) break;
            ++bestInsertionPlace;
        }
        if (!isDup) {
            this._usageEntries.add(bestInsertionPlace, usageEntry);
            this.clearAttributedString();
        }
    }

    public int getEntryCount() {
        return this._usageEntries.size();
    }

    public void removeChange(BaseUsageEntry usageEntry) {
        if (this._usageEntries.remove(usageEntry)) {
            this.clearAttributedString();
        }
    }

    public void removeAllChanges() {
        while (!this._usageEntries.isEmpty()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(0);
            this.removeChange(usageEntry);
        }
    }

    public void whenUsageEntryChanged(BaseUsageEntry usageEntry, PropertyChangeEvent event) {
        if (event.getPropertyName() == "VALID") {
            int i = 0;
            while (i < this._usageEntries.size()) {
                BaseUsageEntry usageEntry_i = this._usageEntries.get(i);
                if (usageEntry == usageEntry_i) {
                    this.clearAttributedString();
                    break;
                }
                ++i;
            }
        }
    }

    private void clearAttributedString() {
        this._attributedString = null;
    }

    public void goToChange(boolean focusEditor) {
        BaseUsageEntry firstUsageEntry = this._usageEntries.get(0);
        firstUsageEntry.goToChange(focusEditor, false);
    }

    public AttributedString getAttributedString() {
        if (this._baseAttributedString == null) {
            return null;
        }
        if (this._attributedString == null) {
            boolean valid = true;
            boolean included = true;
            int i = 0;
            while (i < this._usageEntries.size()) {
                BaseUsageEntry usageEntry = this._usageEntries.get(i);
                valid = valid && usageEntry.isValid();
                included = included && usageEntry.isIncluded();
                ++i;
            }
            included = included && valid;
            int whiteCharCount = 0;
            AttributedCharacterIterator iterator = this._baseAttributedString.getIterator();
            char c = iterator.current();
            while (c != '\uffff' && Character.isWhitespace(c)) {
                ++whiteCharCount;
                c = iterator.next();
            }
            this._attributedString = new AttributedString(iterator, whiteCharCount, iterator.getEndIndex());
            if (!valid) {
                this._attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (!included) {
                this._attributedString.addAttribute(TextAttribute.FOREGROUND, Color.LIGHT_GRAY);
            }
        }
        return this._attributedString;
    }

    public boolean hasIncludedChanges() {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasExcludedChanges() {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            if (!usageEntry.isIncluded()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean areAllValid() {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            if (!usageEntry.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setIncludedStates(boolean state) {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            usageEntry.setIncluded(state);
            ++i;
        }
        this.clearAttributedString();
    }

    public boolean isSameLine(BaseUsageEntry usageEntry) {
        if (this._usageEntries.size() == 0) {
            return true;
        }
        BaseUsageEntry firstUsageEntry = this._usageEntries.get(0);
        boolean isSameUrl = firstUsageEntry.getURL().equals(usageEntry.getURL());
        if (isSameUrl) {
            int offset = usageEntry.getOffset();
            int firstOffset = firstUsageEntry.getOffset();
            TextNode textNode = this.getTextNode();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            try {
                LineMap lineMap = textBuffer.getLineMap();
                boolean bl = lineMap.getLineFromOffset(offset) == lineMap.getLineFromOffset(firstOffset);
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                textNode.releaseTextBuffer();
            }
        }
        return false;
    }

    public int getFirstOffset() {
        if (this._usageEntries.size() == 0) {
            return -1;
        }
        BaseUsageEntry firstUsageEntry = this._usageEntries.get(0);
        return firstUsageEntry.getOffset();
    }

    public URL getURL() {
        if (this._usageEntries.size() == 0) {
            return null;
        }
        BaseUsageEntry firstUsageEntry = this._usageEntries.get(0);
        return firstUsageEntry.getURL();
    }

    public TextNode getTextNode() {
        TextNode ret = null;
        BaseUsageEntry usageEntry = this._usageEntries.get(0);
        URL url = usageEntry.getURL();
        try {
            ret = (TextNode)NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void setAttributedString(AttributedString attributedString) {
        this._baseAttributedString = attributedString;
        TextNode textNode = this.getTextNode();
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        try {
            textBuffer.readLock();
            try {
                int line = -1;
                int lineStartOffset = -1;
                int lineEndOffset = -1;
                for (BaseUsageEntry usageEntry : this._usageEntries) {
                    int offset = usageEntry.getOffset();
                    if (line == -1) {
                        LineMap lineMap = textBuffer.getLineMap();
                        line = lineMap.getLineFromOffset(offset);
                        lineStartOffset = lineMap.getLineStartOffset(line);
                        lineEndOffset = lineMap.getLineEndOffset(line);
                    }
                    int endIndex = (offset -= lineStartOffset) + usageEntry.getLength();
                    try {
                        this._baseAttributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, offset, endIndex);
                        this._baseAttributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, offset, endIndex);
                    }
                    catch (IllegalArgumentException e) {
                        String message = "Invalid usage entry: " + URLFileSystem.getPlatformPathName((URL)usageEntry.getURL()) + " (offset=" + usageEntry.getOffset() + ", length=" + usageEntry.getLength() + ", line=" + line + ", lineStartOffset=" + lineStartOffset + ", lineEndOffset=" + lineEndOffset + ")";
                        throw new IllegalArgumentException(message, e);
                    }
                }
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        finally {
            textNode.releaseTextBuffer();
        }
    }
}

