/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.SourceElementEntry;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.search.Scope;

public class FindClassURLHandler
extends URLHandler {
    private static final String KEY_KEYWORDS = FindClassURLHandler.class.toString() + " - keywords";
    private static final String KEY_PACKAGE = FindClassURLHandler.class.toString() + " - package";

    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 1) {
            SearchClassCriteria criteria = (SearchClassCriteria)searchCriteria;
            String fqClassName = criteria.getFqClassName();
            String className = criteria.getClassName();
            Context context = searchOperation.getContext();
            Project project = context.getProject();
            Scope scope = searchOperation.getSearchHintFile() != null ? Scope.createProjectScope(project) : criteria.getScope();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            JavaClass javaClass = javaManager.getClass(fqClassName);
            if (javaClass != null) {
                String packageName = javaClass.getPackageName();
                searchOperation.setProperty(KEY_PACKAGE, packageName);
                ret = FindClassURLHandler.getIncludedProjects(context, scope, fqClassName);
                HashSet<String> keywords = new HashSet<String>();
                keywords.add(className);
                if (criteria.isIncludeMembers()) {
                    Collection members = javaClass.getDeclaredMethods();
                    int i = 0;
                    while (i < 2) {
                        for (JavaMember javaMember : members) {
                            String name = javaMember.getName();
                            keywords.add(name);
                        }
                        members = javaClass.getDeclaredFields();
                        ++i;
                    }
                }
                searchOperation.setProperty(KEY_KEYWORDS, keywords.toArray(new String[keywords.size()]));
            }
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        if (FindClassURLHandler.isMyType(searchOperation)) {
            SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchOperation.getCriteria();
            boolean includeLibraries = searchClassCriteria.isIncludeLibraries();
            String[] keywords = (String[])searchOperation.getProperty(KEY_KEYWORDS);
            urls = JavaURLHelper.getJavaURLsContaining(searchOperation, project, keywords, includeLibraries, searchClassCriteria.isSearchInNonJavaFiles(), searchClassCriteria.getScope(), progressIndicator);
        }
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        if (FindClassURLHandler.isMyType(searchOperation)) {
            SearchClassCriteria searchClassCriteria = (SearchClassCriteria)searchOperation.getCriteria();
            String fqClassName = searchClassCriteria.getFqClassName();
            String packageName = (String)searchOperation.getProperty(KEY_PACKAGE);
            boolean includeImports = searchClassCriteria.isIncludeImports();
            boolean includeExtends = searchClassCriteria.isIncludeExtends();
            boolean includeAllocation = searchClassCriteria.isIncludeAllocation();
            boolean includeDeclaration = searchClassCriteria.isIncludeDeclaration();
            boolean includeClass = searchClassCriteria.isIncludeClass();
            boolean searchInComments = searchClassCriteria.isSearchInComments();
            boolean includeMembers = searchClassCriteria.isIncludeMembers();
            usageModel = FindClassURLHandler.searchClass(progressIndicator, project, urls, fqClassName, packageName, includeImports, includeExtends, includeAllocation, includeDeclaration, includeClass, searchInComments, includeMembers);
        }
        return usageModel;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UsageModel searchClass(ProgressIndicator progressIndicator, Project project, URL[] urls, String fqClassName, String packageName, boolean includeImports, boolean includeExtends, boolean includeAllocation, boolean includeDeclaration, boolean includeClass, boolean searchInComments, boolean includeMembers) {
        UsageModel usageModel = new UsageModel();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaClass javaClass = javaManager.getClass(fqClassName);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        cacheSupport.beginCacheUse();
        try {
            block29: {
                int i;
                Pattern nqPattern;
                Pattern fqPattern;
                String className;
                block28: {
                    int lastDotPos = fqClassName.lastIndexOf(46);
                    className = fqClassName.substring(lastDotPos + 1);
                    String escapedFQClassName = fqClassName.replaceAll("\\.", "\\\\.");
                    fqPattern = Pattern.compile("\\b" + escapedFQClassName + "\\b");
                    nqPattern = Pattern.compile("\\b(" + escapedFQClassName + "|" + className + ")\\b");
                    i = 0;
                    if (!true) break block28;
                    if (i >= urls.length) return usageModel;
                    if (progressIndicator.isUserCancelled()) break block29;
                }
                do {
                    URL url = urls[i];
                    String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                    progressIndicator.setProgressStepText(platformPathName);
                    SourceFile sourceFile = javaManager.getSourceFile(url);
                    if (sourceFile != null) {
                        boolean isSamePackage = packageName.equals(sourceFile.getPackageName());
                        boolean isImported = false;
                        List list = SourceElementAsList.asList((SourceElement)sourceFile);
                        int j = 0;
                        while (j < list.size()) {
                            SourceElement sourceElement = (SourceElement)list.get(j);
                            int symbolKind = sourceElement.getSymbolKind();
                            switch (symbolKind) {
                                case 14: {
                                    SourceImport sourceImport;
                                    SourceName nameElement;
                                    if (!includeImports && !searchInComments || (nameElement = (sourceImport = (SourceImport)sourceElement).getNameElement()) == null || !fqClassName.equals(nameElement.getValue())) break;
                                    isImported = true;
                                    if (!includeImports) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)nameElement, 101);
                                    break;
                                }
                                case 3: {
                                    String thatQualifiedName;
                                    SourceClass sourceClass;
                                    SourceName nameElement;
                                    if (!includeDeclaration || (nameElement = (sourceClass = (SourceClass)sourceElement).getNameElement()) == null || !className.equals(nameElement.getName()) || !fqClassName.equals(thatQualifiedName = sourceClass.getQualifiedName())) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)nameElement, 102);
                                    break;
                                }
                                case 27: {
                                    JavaType resolvedType;
                                    String thatName;
                                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                                    SourceName nameElement = sourceTypeReference.getNameElement();
                                    if (nameElement == null || !(thatName = nameElement.getName()).endsWith(className) || (resolvedType = sourceTypeReference.getResolvedType()) == null) break;
                                    if (resolvedType.isArray()) {
                                        resolvedType = resolvedType.getBaseComponentType();
                                    } else if (resolvedType.hasActualTypeArguments()) {
                                        resolvedType = resolvedType.getTypeErasure();
                                    }
                                    String thatQualifiedName = resolvedType.getQualifiedName();
                                    if (!fqClassName.equals(thatQualifiedName)) break;
                                    SourceElement parent = sourceTypeReference.getParent();
                                    int usageCode = 1;
                                    switch (parent.getSymbolKind()) {
                                        case 22: {
                                            if (!includeExtends) break;
                                            usageCode = 103;
                                            break;
                                        }
                                        case 15: {
                                            if (!includeExtends) break;
                                            usageCode = 104;
                                            break;
                                        }
                                        case 55: {
                                            if (!includeAllocation) break;
                                            usageCode = 304;
                                            break;
                                        }
                                        default: {
                                            usageCode = 108;
                                        }
                                    }
                                    if (usageCode == 1) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)nameElement, usageCode);
                                    break;
                                }
                                case 6: {
                                    String thatQualifiedName;
                                    JavaClass owningClass;
                                    String name;
                                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                                    SourceName nameElement = sourceMethod.getNameElement();
                                    if (nameElement == null || !className.equals(name = nameElement.getName()) || (owningClass = sourceMethod.getOwningClass()) == null || !fqClassName.equals(thatQualifiedName = owningClass.getQualifiedName())) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)nameElement, 301);
                                    break;
                                }
                                case 57: {
                                    JavaClass resolvedClass;
                                    String thatFqClassName;
                                    JavaHasType resolvedObject;
                                    String name;
                                    SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                                    SourceName nameElement = sourceSimpleNameExpression.getNameElement();
                                    if (nameElement == null || !className.equals(name = nameElement.getName()) || (resolvedObject = sourceSimpleNameExpression.getResolvedObject()) == null || resolvedObject.getElementKind() != 3 || !fqClassName.equals(thatFqClassName = (resolvedClass = (JavaClass)resolvedObject).getQualifiedName())) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)nameElement, 1);
                                    break;
                                }
                                case 49: {
                                    JavaClass resolvedClass;
                                    String thatFqClassName;
                                    JavaHasType resolvedObject;
                                    String name;
                                    SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                                    SourceName nameElement = sourceDotExpression.getNameElement();
                                    if (nameElement == null || (name = nameElement.getName()) == null || !name.equals(className) || (resolvedObject = sourceDotExpression.getResolvedObject()) == null || resolvedObject.getElementKind() != 3 || !fqClassName.equals(thatFqClassName = (resolvedClass = (JavaClass)resolvedObject).getQualifiedName())) break;
                                    FindClassURLHandler.addUsage(usageModel, project, (SourceElement)sourceDotExpression, 1);
                                    break;
                                }
                                case 68: {
                                    SourceDocTextFragment sourceDocTextFragment;
                                    String text;
                                    if (!searchInComments || (text = (sourceDocTextFragment = (SourceDocTextFragment)sourceElement).getText()) == null) break;
                                    Pattern pattern = isSamePackage || isImported ? nqPattern : fqPattern;
                                    Matcher matcher = pattern.matcher(text);
                                    while (matcher.find()) {
                                        int start = matcher.start();
                                        int end = matcher.end();
                                        int offset = sourceDocTextFragment.getStartOffset() + start;
                                        int length = end - start;
                                        UsageEntry usageEntry = new UsageEntry(project, url, offset, length, 1, 2);
                                        usageModel.addUsageEntry(usageEntry);
                                    }
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    if (javaClass != null && includeMembers && !progressIndicator.isUserCancelled()) {
                        Collection declaredMethods = javaClass.getDeclaredMethods();
                        for (JavaMethod javaMethod : declaredMethods) {
                            MethodDescription methodDescription = new MethodDescription(javaMethod);
                            RenameMethodURLHandler.findUsages(project, url, methodDescription, true, true, false, false, false, true, usageModel);
                        }
                        Collection declaredFields = javaClass.getDeclaredFields();
                        for (JavaField javaField : declaredFields) {
                            FieldDescription fieldDescription = new FieldDescription(javaField);
                            RenameFieldURLHandler.findUsages(project, url, fieldDescription, false, usageModel);
                        }
                    }
                    ++i;
                    if (i >= urls.length) return usageModel;
                } while (!progressIndicator.isUserCancelled());
            }
            return usageModel;
        }
        finally {
            cacheSupport.endCacheUse();
        }
    }

    private static void addUsage(UsageModel usageModel, Project project, SourceElement sourceElement, int usageCode) {
        usageModel.addUsageEntry(new SourceElementEntry(project, sourceElement, usageCode));
    }

    private static boolean isMyType(SearchOperation searchOperation) {
        boolean ret = false;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 1) {
            ret = true;
        }
        return ret;
    }
}

