/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.handlers.JavaURLHelper;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.search.Scope;
import oracle.jdevimpl.refactoring.util.Visitor;

public class FindConstructorURLHandler
extends URLHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        Project[] ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 4) {
            SearchConstructorCriteria criteria = (SearchConstructorCriteria)searchCriteria;
            String fqClassName = criteria.getFqClassName();
            Scope scope = criteria.getScope();
            Context context = searchOperation.getContext();
            ret = FindConstructorURLHandler.getIncludedProjects(context, scope, fqClassName);
        }
        return ret;
    }

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet urls = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 4) {
            SearchConstructorCriteria criteria = (SearchConstructorCriteria)searchCriteria;
            String methodName = criteria.getClassName();
            urls = JavaURLHelper.getJavaURLsContaining(searchOperation, project, new String[]{methodName}, criteria.isSearchInLibraries(), criteria.isSearchInComments(), criteria.getScope(), progressIndicator);
        }
        return urls;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        if (searchType == 4) {
            SearchConstructorCriteria searchMethodCriteria = (SearchConstructorCriteria)searchOperation.getCriteria();
            usageModel = FindConstructorURLHandler.searchMethod(searchMethodCriteria, project, urls, progressIndicator);
        }
        return usageModel;
    }

    public static UsageModel searchMethod(SearchConstructorCriteria criteria, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        SourceFile owningSourceFile;
        URL url;
        Collection constructorParameters;
        JavaMethod constructor;
        UsageModel usageModel = new UsageModel();
        String fqClassName = criteria.getFqClassName();
        String className = criteria.getClassName();
        ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        Scope scope = criteria.getScope();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaClass javaClass = javaManager.getClass(fqClassName);
        if (javaClass == null) {
            return usageModel;
        }
        if (criteria.hasOverloadedMethods()) {
            constructor = null;
            constructorParameters = null;
        } else {
            String[] parameterTypes = criteria.getParameterTypes();
            JavaType[] parameters = Patch.typeNames2JavaTypes((JavaProvider)javaManager, parameterTypes);
            constructor = javaClass.getDeclaredConstructor(parameters);
            if (constructor == null) {
                constructorParameters = null;
                StringBuffer message = new StringBuffer(fqClassName);
                if (parameterTypes.length == 0) {
                    message.append("()");
                } else {
                    int lastIndex = parameterTypes.length - 1;
                    message.append("(");
                    int i = 0;
                    while (i < parameterTypes.length) {
                        message.append(parameterTypes[i]);
                        message.append(i == lastIndex ? ")" : ", ");
                        ++i;
                    }
                }
                Assert.printStackTrace((boolean)true, (String)("Cannot find constructor: " + message));
            } else {
                constructorParameters = constructor.getParameters();
            }
        }
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        if (sourceClass != null && scope.isValidPath(project, allContents, url = (owningSourceFile = sourceClass.getOwningSourceFile()).getURL())) {
            SourceMethod sourceMethod;
            if (criteria.hasOverloadedMethods()) {
                Collection declaredConstructors = sourceClass.getDeclaredConstructors();
                for (SourceMethod sourceMethod2 : declaredConstructors) {
                    SourceName nameElement = sourceMethod2.getNameElement();
                    usageModel.addUsageEntry(new UsageEntry(project, (SourceElement)nameElement, 0, 1));
                }
            } else if (constructor != null && (sourceMethod = (SourceMethod)constructor.getSourceElement()) != null) {
                SourceName nameElement = sourceMethod.getNameElement();
                usageModel.addUsageEntry(new UsageEntry(project, (SourceElement)nameElement, 0, 1));
            }
        }
        int i = 0;
        while (i < urls.length) {
            URL url2 = urls[i];
            progressIndicator.setProgressStepText("");
            if (Util.isJavaSource(url2) && scope.isValidPath(project, allContents, url2)) {
                SourceFile sourceFile = javaManager.getSourceFile(url2);
                1 visitor = new 1(className, constructor, fqClassName, constructorParameters, usageModel, project);
                visitor.visit((SourceElement)sourceFile);
            }
            ++i;
        }
        return usageModel;
    }

    private static boolean matchingClassName(String classNameFound, String classNameToLookFor) {
        int idx = classNameFound.indexOf(classNameToLookFor);
        if (idx == -1) {
            return false;
        }
        if (idx > 0 && Character.isJavaIdentifierPart(classNameFound.charAt(idx - 1))) {
            return false;
        }
        return idx + classNameToLookFor.length() >= classNameFound.length() || !Character.isJavaIdentifierPart(classNameFound.charAt(idx + classNameToLookFor.length()));
    }

    static boolean maS$matchingClassName(String string, String string2) {
        return FindConstructorURLHandler.matchingClassName(string, string2);
    }

    static final class 1
    extends Visitor {
        private final /* synthetic */ String v$className;
        private final /* synthetic */ JavaMethod v$constructor;
        private final /* synthetic */ String v$fqClassName;
        private final /* synthetic */ Collection v$constructorParameters;
        private final /* synthetic */ UsageModel v$usageModel;
        private final /* synthetic */ Project v$project;

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
            SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
            String classCreatorName = sourceType.getName();
            boolean include = false;
            if (FindConstructorURLHandler.maS$matchingClassName(classCreatorName, this.v$className)) {
                JavaMethod resolvedConstructor;
                if (this.v$constructor == null) {
                    JavaType resolvedType = sourceClassCreatorExpression.getResolvedType();
                    if (this.v$fqClassName.equals(resolvedType.getQualifiedName())) {
                        include = true;
                    }
                } else if (this.v$constructorParameters.size() == sourceClassCreatorExpression.getArgumentCount() && this.v$constructor.equals((Object)(resolvedConstructor = sourceClassCreatorExpression.getResolvedMethod()))) {
                    include = true;
                }
            }
            if (include) {
                SourceName nameElement = sourceType.getNameElement();
                this.v$usageModel.addUsageEntry(new UsageEntry(this.v$project, (SourceElement)nameElement, 0, 1));
            }
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
            if (this.v$constructor != null && this.v$constructor.equals((Object)resolvedMethod)) {
                SourceName nameElement = sourceMethodCallExpression.getNameElement();
                this.v$usageModel.addUsageEntry(new UsageEntry(this.v$project, (SourceElement)nameElement, 0, 1));
            }
        }

        public 1(String string, JavaMethod javaMethod, String string2, Collection collection, UsageModel usageModel, Project project) {
            this.v$project = project;
            this.v$usageModel = usageModel;
            this.v$constructorParameters = collection;
            this.v$fqClassName = string2;
            this.v$constructor = javaMethod;
            this.v$className = string;
        }
    }
}

