/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.refactoring.search.Scope;

public abstract class FindDialog
extends BaseDialog {
    private static final int PREF_COMMENTS = Integer.MIN_VALUE;
    private static final int PREF_NONJAVA = 0x40000000;
    private static final int PREF_LIBRARIES = 0x20000000;
    private static final int PREF_NEW_TAB = 0x10000000;
    protected JCheckBox _searchComments;
    protected JCheckBox _searchNonJavaFiles;
    protected JCheckBox _searchLibraries;
    protected JCheckBox _useNewTab;
    private JComboBox _comboBox;
    private static final String DEFAULT_SCOPE_KEY = "SEARCH_DEFAULT_SCOPE";

    public FindDialog(String preferenceKey, Context context) {
        super(preferenceKey, context);
    }

    protected JPanel createWherePanel() {
        CopyableInteger settings = this.getSettings();
        Insets insets = new Insets(2, 2, 2, 2);
        if (this.canSearchComments()) {
            this._searchComments = new JCheckBox();
            this._searchComments.setSelected(settings.isBitSet(Integer.MIN_VALUE));
            ResourceUtils.resButton((AbstractButton)this._searchComments, (String)RefactoringArb.getString(337));
        }
        if (this.canSearchNonJavaFiles()) {
            this._searchNonJavaFiles = new JCheckBox();
            this._searchNonJavaFiles.setSelected(settings.isBitSet(0x40000000));
            ResourceUtils.resButton((AbstractButton)this._searchNonJavaFiles, (String)RefactoringArb.getString(323));
        }
        this._searchLibraries = new JCheckBox();
        this._searchLibraries.setSelected(settings.isBitSet(0x20000000));
        ResourceUtils.resButton((AbstractButton)this._searchLibraries, (String)RefactoringArb.getString(335));
        JPanel where = new JPanel(new GridBagLayout());
        where.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(202)));
        if (this._searchComments != null) {
            where.add((Component)this._searchComments, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        if (this._searchNonJavaFiles != null) {
            where.add((Component)this._searchNonJavaFiles, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
        }
        where.add((Component)this._searchLibraries, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, insets, 2, 0));
        return where;
    }

    protected boolean canSearchNonJavaFiles() {
        return true;
    }

    protected boolean canSearchComments() {
        return true;
    }

    protected void updateSettings(CopyableInteger settings) {
        Object selectedItem;
        settings.setBit(Integer.MIN_VALUE, this.hasSearchComments());
        settings.setBit(0x40000000, this.hasSearchNonJavaFiles());
        settings.setBit(0x20000000, this.hasSearchLibraries());
        settings.setBit(0x10000000, this.hasUseNewTab());
        if (this._comboBox != null && (selectedItem = this._comboBox.getSelectedItem()) != null) {
            Object[] objects = (Object[])selectedItem;
            String label = (String)objects[0];
            DTCache dtCache = Ide.getDTCache();
            dtCache.putString(DEFAULT_SCOPE_KEY, label);
        }
    }

    public boolean hasSearchComments() {
        return this._searchComments != null && this._searchComments.isSelected();
    }

    public boolean hasSearchNonJavaFiles() {
        return this._searchNonJavaFiles != null && this._searchNonJavaFiles.isSelected();
    }

    public boolean hasSearchLibraries() {
        return this._searchLibraries.isSelected();
    }

    public boolean hasUseNewTab() {
        return this._useNewTab.isSelected();
    }

    public Scope getScope() {
        Scope ret;
        Object[] selectedItem = (Object[])this._comboBox.getSelectedItem();
        Object selectedObject = selectedItem[2];
        if (selectedObject instanceof Workspace) {
            Workspace workspace = (Workspace)selectedObject;
            ret = Scope.createApplicationScope(workspace);
        } else if (selectedObject instanceof Project) {
            Project project = (Project)selectedObject;
            ret = Scope.createProjectScope(project);
        } else if (selectedObject instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)selectedObject;
            ret = Scope.createWorkingSetScope(workingSet);
        } else {
            ret = Scope.createDummyScope();
        }
        return ret;
    }

    protected abstract JPanel createWhatPanel();

    protected final void init() {
        CopyableInteger settings = this.getSettings();
        FindDialog.setPreferNewTabChecked(settings.isBitSet(0x10000000));
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel what = this.createWhatPanel();
        JPanel where = this.createWherePanel();
        this._useNewTab = new JCheckBox();
        this._useNewTab.setSelected(BaseDialog.isPreferNewTabChecked());
        ResourceUtils.resButton((AbstractButton)this._useNewTab, (String)RefactoringArb.getString(271));
        JLabel label = new JLabel();
        DefaultComboBoxModel comboBoxModel = this.createScopeModel();
        this._comboBox = new JComboBox(comboBoxModel);
        this._comboBox.setRenderer(new 1());
        ResourceUtils.resLabel((JLabel)label, (Component)this._comboBox, (String)RefactoringArb.getString(217));
        JPanel scopePanel = new JPanel(new GridBagLayout());
        scopePanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        scopePanel.add((Component)this._comboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        int xpos = 0;
        if (what != null) {
            this.add((Component)what, new GridBagConstraints(xpos++, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 2, 0));
        }
        this.add((Component)where, new GridBagConstraints(xpos++, 0, 1, 1, 1.0, 0.0, 18, 1, insets, 2, 0));
        this.add((Component)scopePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 2, 0));
        this.add((Component)this._useNewTab, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 3, insets, 2, 0));
        DTCache dtCache = Ide.getDTCache();
        String defaultScope = dtCache.getString(DEFAULT_SCOPE_KEY);
        if (defaultScope == null) {
            defaultScope = RefactoringArb.getString(67);
        }
        if (defaultScope != null) {
            int size = comboBoxModel.getSize();
            int i = 0;
            while (i < size) {
                Object[] objects = (Object[])comboBoxModel.getElementAt(i);
                Object label2 = objects[0];
                if (defaultScope.equals(label2)) {
                    comboBoxModel.setSelectedItem(objects);
                    break;
                }
                ++i;
            }
        }
    }

    private DefaultComboBoxModel createScopeModel() {
        DefaultComboBoxModel<Object[]> ret = new DefaultComboBoxModel<Object[]>();
        Context context = this.getContext();
        Workspace workspace = context.getWorkspace();
        ret.addElement(new Object[]{RefactoringArb.getString(228), OracleIcons.getIcon((String)"application.png"), workspace});
        Project project = context.getProject();
        ret.addElement(new Object[]{RefactoringArb.getString(67), OracleIcons.getIcon((String)"project.png"), project});
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        WorkingSet currentWorkingSet = workingSets.getCurrentWorkingSet();
        String currentWSName = currentWorkingSet.getName();
        if (FindDialog.isAcceptableWorkingset(currentWSName)) {
            ret.addElement(new Object[]{currentWSName, Res.getIcon(26), currentWorkingSet});
        }
        List workingSetNames = workingSets.getWorkingSetNames();
        int i = 0;
        while (i < workingSetNames.size()) {
            String workingSetName = (String)workingSetNames.get(i);
            WorkingSet workingSet = workingSets.getWorkingSet(workingSetName);
            if (FindDialog.isAcceptableWorkingset(workingSetName) && !currentWSName.equals(workingSetName)) {
                Object[] objects = new Object[]{workingSet.getName(), Res.getIcon(26), workingSet};
                ret.addElement(objects);
            }
            ++i;
        }
        return ret;
    }

    private static final boolean isAcceptableWorkingset(String wsName) {
        return (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(wsName) || WorkingSets.DEFAULT_WORKING_SET_LABEL.equals(wsName)) ^ true;
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object[] values = (Object[])value;
            Object text = values[0];
            Icon icon = (Icon)values[1];
            Component ret = super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return ret;
        }
    }
}

