/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.search.FindDialog;

public class FindMethodDialog
extends FindDialog {
    public static final String PREFERENCE_KEY = "FIND_METHOD_DLG_DEFAULTS";
    private static final int PREF_OVERLOADED = 1;
    private static final int PREF_METHOD_CALLS = 2;
    private static final int PREF_METHOD_DECLS = 4;
    private JavaMethod _javaMethod;
    private JCheckBox _overloaded;
    private JCheckBox _searchMethodCalls;
    private JCheckBox _searchMethodOverrides;

    public FindMethodDialog(Context context, JavaMethod javaMethod) {
        super(PREFERENCE_KEY, context);
        this._javaMethod = javaMethod;
        this.init();
    }

    protected JPanel createWhatPanel() {
        Container ret = null;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(RefactoringArb.getString(29)));
        CopyableInteger settings = this.getSettings();
        Insets insets = new Insets(2, 2, 2, 2);
        if (this.hasOverloadedMethods()) {
            this._overloaded = new JCheckBox();
            this._overloaded.setSelected(settings.isBitSet(1));
            String labelText = this._javaMethod.isConstructor() ? RefactoringArb.getString(139) : RefactoringArb.getString(49);
            ResourceUtils.resButton((AbstractButton)this._overloaded, (String)labelText);
            panel.add((Component)this._overloaded, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
            ret = panel;
        }
        if (!this._javaMethod.isConstructor()) {
            String label = RefactoringArb.getString(126);
            this._searchMethodCalls = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._searchMethodCalls, (String)label);
            this._searchMethodCalls.setSelected(settings.isBitSet(2));
            this.updateOnChanges(this._searchMethodCalls);
            panel.add((Component)this._searchMethodCalls, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
            if (!this._javaMethod.isFinal()) {
                String label2 = RefactoringArb.getString(107);
                this._searchMethodOverrides = new JCheckBox();
                ResourceUtils.resButton((AbstractButton)this._searchMethodOverrides, (String)label2);
                this._searchMethodOverrides.setSelected(settings.isBitSet(4));
                panel.add((Component)this._searchMethodOverrides, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 0, insets, 2, 0));
                this.updateOnChanges(this._searchMethodOverrides);
            }
            ret = panel;
        }
        if (ret != null) {
            ret.add((Component)new JPanel(), new GridBagConstraints(0, 99, 1, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
        }
        return ret;
    }

    protected String getTitle() {
        String fullName = Util.getFullMethodName(this._javaMethod, true, false, false);
        String title = MessageFormat.format(RefactoringArb.getString(46), fullName);
        return title;
    }

    protected int getDefaultPreferences() {
        return 7;
    }

    protected void updateSettings(CopyableInteger settings) {
        super.updateSettings(settings);
        settings.setBit(1, this.hasSearchOverloaded());
        if (this._searchMethodCalls != null) {
            settings.setBit(2, this._searchMethodCalls.isSelected());
        }
        if (this._searchMethodOverrides != null) {
            settings.setBit(4, this._searchMethodOverrides.isSelected());
        }
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            boolean hasSomethingToSearch = !this._javaMethod.isConstructor() ? this.hasSearchMethodCalls() || this.hasSearchMethodOverrides() : true;
            this.setOKButtonEnabled(hasSomethingToSearch);
        }
    }

    protected boolean hasOverloadedMethods() {
        boolean canOverload;
        if (!this._javaMethod.isConstructor()) {
            String methodName = this._javaMethod.getName();
            JavaClass owningClass = this._javaMethod.getOwningClass();
            int overloadCount = 0;
            Collection methods = owningClass.getMethods(methodName);
            for (JavaMethod javaMethod : methods) {
                if (this._javaMethod.equals((Object)javaMethod) || CommonUtilities.matchMethod((JavaMethod)javaMethod, (JavaType[])this._javaMethod.getParameterTypes())) continue;
                ++overloadCount;
            }
            canOverload = overloadCount > 0;
        } else {
            JavaClass owningClass = this._javaMethod.getOwningClass();
            Collection declaredConstructors = owningClass.getDeclaredConstructors();
            canOverload = declaredConstructors.size() > 1;
        }
        return canOverload;
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._overloaded;
    }

    protected String getHelpTopicID() {
        return "f1_jed_usages_of_method_dlg_html";
    }

    protected boolean canSearchComments() {
        return this._javaMethod.isConstructor() ^ true;
    }

    protected boolean canSearchNonJavaFiles() {
        return this._javaMethod.isConstructor() ^ true;
    }

    public JavaMethod getSearchedMethod() {
        return this._javaMethod;
    }

    public boolean hasSearchOverloaded() {
        return this._overloaded != null && this._overloaded.isSelected() && this._overloaded.isEnabled();
    }

    public boolean hasSearchMethodCalls() {
        return this._searchMethodCalls != null && this._searchMethodCalls.isSelected() && this._searchMethodCalls.isEnabled();
    }

    public boolean hasSearchMethodOverrides() {
        return this._searchMethodOverrides != null && this._searchMethodOverrides.isSelected() && this._searchMethodOverrides.isEnabled();
    }
}

