/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.net.URL;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.util.PatternFilters;

public final class Scope {
    public static final int TYPE_ALL = 0;
    public static final int TYPE_WORKSPACE = 1;
    public static final int TYPE_PROJECT = 2;
    public static final int TYPE_WORKINGSET = 3;
    private int _type;
    private Workspace _workspace;
    private Project _project;
    private WorkingSet _workingSet;
    public static final Scope DUMMY_SCOPE = new Scope();

    private Scope() {
        this._type = 0;
    }

    private Scope(Workspace workspace) {
        this._type = 1;
        this._workspace = workspace;
    }

    private Scope(Project project) {
        this._type = 2;
        this._project = project;
    }

    private Scope(WorkingSet workingSet) {
        this._type = 3;
        this._workingSet = workingSet;
    }

    public int getType() {
        return this._type;
    }

    public WorkingSet getWorkingSet() {
        return this._workingSet;
    }

    public boolean isValidProject(Project project) {
        switch (this._type) {
            case 2: {
                return this._project.equals((Object)project);
            }
            case 3: {
                return this._workingSet.isIncluded(project);
            }
        }
        return true;
    }

    public boolean isValidRelativePath(Project project, String path) {
        boolean ret = true;
        switch (this._type) {
            case 3: {
                PatternFilters patternFilters = this._workingSet.getPatternFilters(project);
                ret = patternFilters == null || patternFilters.isIncluded(path);
                break;
            }
        }
        return ret;
    }

    public boolean isValidPath(Project project, ContentSet contentSet, URL url) {
        boolean ret = true;
        switch (this._type) {
            case 3: {
                String path = contentSet.toRelativePath(url);
                if (path == null) break;
                ret = this.isValidRelativePath(project, path);
                break;
            }
        }
        return ret;
    }

    public static final Scope createDummyScope() {
        return DUMMY_SCOPE;
    }

    public static final Scope createApplicationScope(Workspace workspace) {
        return new Scope(workspace);
    }

    public static Scope createProjectScope(Project project) {
        return new Scope(project);
    }

    public static Scope createWorkingSetScope(WorkingSet workingSet) {
        return new Scope(workingSet);
    }
}

