/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.search;

import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchVariableCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.preview.BackgroundUsagesLogPage;
import oracle.jdevimpl.refactoring.search.FindClassDialog;
import oracle.jdevimpl.refactoring.search.FindFieldDialog;
import oracle.jdevimpl.refactoring.search.FindMethodDialog;
import oracle.jdevimpl.refactoring.search.Scope;

public class UsageController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        ElementAt elementAt;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (elementAt = ElementAt.findElementAt(context)) != null) {
            int type = elementAt.getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    action.setEnabled(true);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 1: {
                    JavaClass javaClass = (JavaClass)elementAt.getJavaElement();
                    UsageController.whenFindClassUsages(context, javaClass);
                    return true;
                }
                case 4: 
                case 7: {
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    UsageController.whenFindFieldUsages(context, javaField);
                    return true;
                }
                case 3: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    UsageController.whenFindMethodUsages(context, javaMethod);
                    return true;
                }
                case 2: {
                    JavaMethod javaMethod = (JavaMethod)elementAt.getJavaElement();
                    UsageController.whenFindConstructorUsages(context, javaMethod);
                    return true;
                }
                case 5: {
                    SourceVariable sourceLocalVariable = (SourceVariable)elementAt.getSourceElement();
                    SourceFile sourceFile = sourceLocalVariable.getOwningSourceFile();
                    UsageController.whenFindVariableUsages(context, sourceLocalVariable, sourceFile);
                    return true;
                }
            }
        }
        return false;
    }

    public static void whenFindConstructorUsages(Context context, JavaMethod javaMethod) {
        FindMethodDialog findMethodDialog = new FindMethodDialog(context, javaMethod);
        if (findMethodDialog.runDialog()) {
            JavaMember[] javaMembers;
            MethodDescription methodDescription = new MethodDescription(javaMethod);
            SearchConstructorCriteria criteria = new SearchConstructorCriteria(methodDescription);
            boolean overloadedMethods = findMethodDialog.hasSearchOverloaded();
            criteria.setIncludeAllocation(true);
            criteria.setIncludeSuperAndThis(true);
            criteria.setOverloadedMethods(overloadedMethods);
            criteria.setSearchInLibraries(findMethodDialog.hasSearchLibraries());
            criteria.setScope(findMethodDialog.getScope());
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            if (overloadedMethods) {
                JavaClass owningClass = javaMethod.getOwningClass();
                Collection declaredConstructors = owningClass.getDeclaredConstructors();
                javaMembers = declaredConstructors.toArray(new JavaMember[declaredConstructors.size()]);
            } else {
                javaMembers = new JavaMember[]{javaMethod};
            }
            Util.setOperationHints(searchOperation, javaMembers);
            boolean useNewTab = findMethodDialog.hasUseNewTab();
            BackgroundUsagesLogPage.showUsages(searchOperation, useNewTab);
        }
    }

    public static void whenFindClassUsages(Context context, JavaClass javaClass) {
        FindClassDialog findClassDialog = new FindClassDialog(context, javaClass);
        if (findClassDialog.runDialog()) {
            boolean searchInComments = findClassDialog.hasSearchComments();
            boolean searchInNonJavaFiles = findClassDialog.hasSearchNonJavaFiles();
            SearchClassCriteria criteria = new SearchClassCriteria(ClassDescription.createClassDescription(javaClass), searchInComments, searchInNonJavaFiles);
            boolean includeClass = findClassDialog.hasFindClass();
            boolean includeMembers = findClassDialog.hasFindMembers();
            boolean includeLibraries = findClassDialog.hasSearchLibraries();
            boolean useNewTab = findClassDialog.hasUseNewTab();
            Scope scope = findClassDialog.getScope();
            criteria.setInclude(includeClass, includeClass, includeClass, includeClass, includeMembers, includeClass);
            criteria.setIncludeLibraries(includeLibraries);
            criteria.setScope(scope);
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            Util.setOperationHints(searchOperation, javaClass, includeMembers);
            BackgroundUsagesLogPage.showUsages(searchOperation, useNewTab);
        }
    }

    public static void whenFindFieldUsages(Context context, JavaField javaField) {
        FindFieldDialog findFieldDialog = new FindFieldDialog(context, javaField);
        if (findFieldDialog.runDialog()) {
            FieldDescription fieldDescription = new FieldDescription(javaField);
            SearchFieldCriteria criteria = new SearchFieldCriteria(fieldDescription);
            criteria.setSearchInComments(findFieldDialog.hasSearchComments());
            criteria.setSearchInLibraries(findFieldDialog.hasSearchLibraries());
            criteria.setSearchInNonJavaFiles(findFieldDialog.hasSearchNonJavaFiles());
            criteria.setScope(findFieldDialog.getScope());
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            Util.setOperationHints(searchOperation, new JavaMember[]{javaField});
            boolean useNewTab = findFieldDialog.hasUseNewTab();
            BackgroundUsagesLogPage.showUsages(searchOperation, useNewTab);
        }
    }

    public static void whenFindMethodUsages(Context context, JavaMethod javaMethod) {
        JavaMethod methodErasure = javaMethod.getMethodErasure();
        FindMethodDialog findMethodDialog = new FindMethodDialog(context, methodErasure);
        if (findMethodDialog.runDialog()) {
            boolean overloadedMethods = findMethodDialog.hasSearchOverloaded();
            boolean searchMethodCalls = findMethodDialog.hasSearchMethodCalls();
            boolean searchMethodOverrides = findMethodDialog.hasSearchMethodOverrides();
            JavaMethod searchMethod = findMethodDialog.getSearchedMethod();
            MethodDescription methodDescription = new MethodDescription(searchMethod);
            SearchMethodCriteria criteria = new SearchMethodCriteria(methodDescription, overloadedMethods);
            criteria.setIncludeDeclaration(searchMethodOverrides);
            criteria.setIncludeInvocation(searchMethodCalls);
            criteria.setSearchInComments(findMethodDialog.hasSearchComments());
            criteria.setSearchInLibraries(findMethodDialog.hasSearchLibraries());
            criteria.setSearchInNonJavaFiles(findMethodDialog.hasSearchNonJavaFiles());
            criteria.setScope(findMethodDialog.getScope());
            SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
            Util.setOperationHints(searchOperation, (JavaMember)methodErasure, overloadedMethods);
            boolean useNewTab = findMethodDialog.hasUseNewTab();
            BackgroundUsagesLogPage.showUsages(searchOperation, useNewTab);
        }
    }

    private static void whenFindVariableUsages(Context context, SourceVariable sourceLocalVariable, SourceFile sourceFile) {
        SearchVariableCriteria criteria = new SearchVariableCriteria(sourceLocalVariable, sourceFile, false);
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        BackgroundUsagesLogPage.showUsages(searchOperation, false);
    }
}

