/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.Collection;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class ExpressionUtil {
    public static JavaType getExpectedType(SourceExpression expression) {
        JavaType resolvedType = null;
        SourceElement parent = expression.getParent();
        while (parent != null) {
            int nodeID = parent.getSymbolKind();
            switch (nodeID) {
                case 2: {
                    return null;
                }
                case 48: {
                    SourceAssignmentExpression sourceAssignmentExpression = (SourceAssignmentExpression)parent;
                    SourceExpression lhsExpression = sourceAssignmentExpression.getFirstOperand();
                    if (!Patch.contains((SourceElement)lhsExpression, (SourceElement)expression)) {
                        resolvedType = lhsExpression.getResolvedType();
                    }
                    return resolvedType;
                }
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)parent;
                    if (Patch.contains((SourceElement)sourceLocalVariable.getInitializer(), (SourceElement)expression)) {
                        resolvedType = sourceLocalVariable.getResolvedType();
                    }
                    return resolvedType;
                }
                case 53: 
                case 55: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)parent;
                    SourceExpression lhsOperand = sourceInvokeExpression.getLhsOperand();
                    if (lhsOperand != null && Patch.contains((SourceElement)lhsOperand, (SourceElement)expression)) {
                        JavaMethod resolvedMethod = sourceInvokeExpression.getResolvedMethod();
                        if (resolvedMethod != null) {
                            resolvedType = resolvedMethod.getOwningClass();
                        }
                    } else {
                        int argPos;
                        JavaMethod resolvedMethod = sourceInvokeExpression.getResolvedMethod();
                        if (resolvedMethod != null && (argPos = Patch.getArgumentPos(sourceInvokeExpression, (SourceElement)expression)) >= 0) {
                            Collection parameters = resolvedMethod.getParameters();
                            JavaVariable[] javaVariables = parameters.toArray(new JavaVariable[parameters.size()]);
                            int i = 0;
                            while (i < javaVariables.length && javaVariables[i].isSynthetic()) {
                                ++argPos;
                                ++i;
                            }
                            if (argPos < javaVariables.length) {
                                JavaVariable javaVariable = javaVariables[argPos];
                                resolvedType = javaVariable.getResolvedType();
                            }
                        }
                    }
                    return resolvedType;
                }
                case 40: {
                    SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, parent);
                    if (sourceMethod != null) {
                        resolvedType = sourceMethod.getReturnType();
                    }
                    return resolvedType;
                }
                case 59: {
                    SourceTypecastExpression sourceTypecastExpression = (SourceTypecastExpression)parent;
                    resolvedType = sourceTypecastExpression.getResolvedType();
                    return resolvedType;
                }
                case 47: 
                case 49: 
                case 51: 
                case 61: {
                    break;
                }
                case 60: {
                    break;
                }
                case 56: {
                    SourceQuestionExpression sourceQuestionExpression = (SourceQuestionExpression)parent;
                    SourceExpression firstOperand = sourceQuestionExpression.getFirstOperand();
                    if (firstOperand == null || !Patch.contains((SourceElement)firstOperand, (SourceElement)expression)) break;
                    PrimitiveType primitiveType = CommonUtilities.getPrimitiveType((String)"boolean");
                    return primitiveType;
                }
                case 50: {
                    SourceInfixExpression sourceInfixExpression = (SourceInfixExpression)parent;
                    int operatorCode = sourceInfixExpression.getOperatorCode();
                    switch (operatorCode) {
                        case 20: {
                            SourceExpression firstOperand = sourceInfixExpression.getFirstOperand();
                            SourceExpression otherOperand = Patch.contains((SourceElement)firstOperand, (SourceElement)expression) ? sourceInfixExpression.getSecondOperand() : firstOperand;
                            if (!otherOperand.getText().equals("null")) {
                                JavaType secondOperandType = otherOperand.getResolvedType();
                                return secondOperandType;
                            }
                            return null;
                        }
                    }
                    return null;
                }
                default: {
                    if (!(parent instanceof SourceExpression)) break;
                    SourceExpression sourceExpression = (SourceExpression)parent;
                    System.out.println(ExpressionUtil.class.getName() + ": " + "Unhandled expression: " + sourceExpression.getClass().getName());
                    System.out.println("Please report");
                    return null;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }
}

