/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.keyword.KeywordCriteria;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ConstructorUsageEvent;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdevimpl.refactoring.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindMemberUsages {
    public ArrayList _members;
    private MultiMap<String, URL> _keywordHits;

    public FindMemberUsages(JavaMember member) {
        this._members = new ArrayList(1);
        this._members.add(member);
    }

    public FindMemberUsages(JavaMember[] members) {
        this._members = new ArrayList<JavaMember>(Arrays.asList(members));
    }

    public void findMemberUsages(Project project, JotUsageListener usageListener) {
        HashSet<JavaMember> memberSet = new HashSet<JavaMember>(this._members.size());
        HashSet notMembersSet = new HashSet();
        HashSet<String> memberNames = new HashSet<String>();
        int i = 0;
        while (i < this._members.size()) {
            JavaMember member = (JavaMember)this._members.get(i);
            memberSet.add(member);
            if (member.getElementKind() == 8) {
                JavaMethod javaMethod = (JavaMethod)member;
                if (javaMethod.isConstructor()) {
                    JavaClass owningClass = member.getOwningClass();
                    String className = owningClass.getName();
                    memberNames.add(className);
                    memberNames.add("this");
                    memberNames.add("super");
                } else {
                    memberNames.add(member.getName());
                }
            } else {
                memberNames.add(member.getName());
            }
            ++i;
        }
        URL[] urls = this.findMemberUsages(project);
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        int i2 = 0;
        while (i2 < urls.length) {
            URL url = urls[i2];
            SourceFile sourceFile = javaManager.getSourceFile(url);
            if (sourceFile != null) {
                1 visitor = new 1(this, memberSet, usageListener, memberNames, notMembersSet);
                visitor.visit((SourceElement)sourceFile);
            }
            ++i2;
        }
    }

    private void verifyHits(Project project, MyUsageListener usageListener) {
        UsageManager usageManager = null;
        JavaManager javaManager = null;
        int i = 0;
        while (i < this._members.size()) {
            boolean useHitVerifier;
            JavaMember member = (JavaMember)this._members.get(i);
            String memberName = FindMemberUsages.getMemberName(member);
            List urlList = this._keywordHits.get((Object)memberName);
            URL[] urls = urlList.toArray(new URL[urlList.size()]);
            JavaClass owningClass = member.getOwningClass();
            String fqClassName = owningClass.getQualifiedName();
            boolean isAnonymous = fqClassName.endsWith(".");
            boolean bl = useHitVerifier = !isAnonymous;
            if (useHitVerifier) {
                JavaField javaField;
                JavaType resolvedType;
                if (usageManager == null) {
                    usageManager = new UsageManager(project);
                }
                UsageQueryTask usageQueryTask = null;
                if (member instanceof JavaMethod) {
                    JavaMethod javaMethod = (JavaMethod)member;
                    String[] fqParamTypes = Util.getFqParamTypes(javaMethod);
                    usageQueryTask = javaMethod.isConstructor() ? usageManager.findConstructorUsages(fqClassName, fqParamTypes, usageListener, urls) : usageManager.findMethodUsages(fqClassName, memberName, fqParamTypes, usageListener, urls);
                } else if (member instanceof JavaField && (resolvedType = (javaField = (JavaField)member).getResolvedType()) != null) {
                    String fqTypeName = resolvedType.getQualifiedName();
                    usageQueryTask = usageManager.findFieldUsages(fqClassName, fqTypeName, memberName, usageListener, urls);
                }
                if (usageQueryTask != null) {
                    Util.waitUntilFinished(usageQueryTask);
                }
            } else {
                if (javaManager == null) {
                    javaManager = JavaManager.getJavaManager((Project)project);
                }
                switch (member.getElementKind()) {
                    case 8: {
                        JavaMethod javaMethod = (JavaMethod)member;
                        if (javaMethod.isConstructor()) {
                            this.findConstuctorUsages(javaManager, javaMethod, urls, usageListener);
                            break;
                        }
                        this.findMethodUsages(javaManager, javaMethod, urls, usageListener);
                        break;
                    }
                    case 5: {
                        JavaField javaField = (JavaField)member;
                        this.findFieldUsages(javaManager, javaField, urls, usageListener);
                        break;
                    }
                }
                usageListener.notifyFinished(new UsageEvent(null, 0));
            }
            ++i;
        }
    }

    private void findConstuctorUsages(JavaManager javaManager, JavaMethod javaMethod, URL[] urls, ConstructorUsageListener usageListener) {
        JavaClass owningClass = javaMethod.getOwningClass();
        String className = owningClass.getName();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            SourceFile sourceFile = javaManager.getSourceFile(url);
            if (sourceFile != null) {
                List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{20, 66});
                int j = 0;
                while (j < sourceElements.size()) {
                    SourceElement sourceElement = (SourceElement)sourceElements.get(j);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 20: {
                            SourceMethodCallExpression sourceMethodCallExpression;
                            SourceElement parent;
                            SourceName sourceName = (SourceName)sourceElement;
                            String name = sourceName.getName();
                            if (className.equals(name)) {
                                SourceElement parent2 = sourceName.getParent();
                                switch (parent2.getSymbolKind()) {
                                    case 55: {
                                        SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)parent2;
                                        if (!javaMethod.equals((Object)sourceClassCreatorExpression)) break block0;
                                        ConstructorUsageEvent event = new ConstructorUsageEvent(null, 304, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                        usageListener.notifyConstructorUsage(event);
                                        break block0;
                                    }
                                    case 6: {
                                        SourceMethod sourceMethod = (SourceMethod)parent2;
                                        if (!javaMethod.equals((Object)sourceMethod)) break block0;
                                        ConstructorUsageEvent event = new ConstructorUsageEvent(null, 301, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                        usageListener.notifyConstructorUsage(event);
                                        break block0;
                                    }
                                }
                                break;
                            }
                            if (!"this".equals(name) && !"super".equals(name) || (parent = sourceName.getParent()).getSymbolKind() != 53 || !javaMethod.equals((Object)(sourceMethodCallExpression = (SourceMethodCallExpression)parent))) break;
                            ConstructorUsageEvent event = new ConstructorUsageEvent(null, "this".equals(name) ? 302 : 303, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                            usageListener.notifyConstructorUsage(event);
                            break;
                        }
                    }
                    ++j;
                }
            } else {
                usageListener.notifySkipped(new UsageEvent(null, 3, url));
            }
            ++i;
        }
    }

    private void findMethodUsages(JavaManager javaManager, JavaMethod javaMethod, URL[] urls, MethodUsageListener usageListener) {
        String methodName = javaMethod.getName();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            SourceFile sourceFile = javaManager.getSourceFile(url);
            if (sourceFile != null) {
                List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{20, 66});
                int j = 0;
                while (j < sourceElements.size()) {
                    SourceElement sourceElement = (SourceElement)sourceElements.get(j);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 20: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String name = sourceName.getName();
                            if (!methodName.equals(name)) break;
                            SourceElement parent = sourceName.getParent();
                            switch (parent.getSymbolKind()) {
                                case 53: {
                                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)parent;
                                    JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                                    if (!javaMethod.equals((Object)resolvedMethod)) break block0;
                                    MethodUsageEvent event = new MethodUsageEvent(null, 402, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    usageListener.notifyMethodUsage(event);
                                    break block0;
                                }
                                case 19: {
                                    SourceMethod sourceMethod = (SourceMethod)parent;
                                    if (!javaMethod.equals((Object)sourceMethod)) break block0;
                                    MethodUsageEvent event = new MethodUsageEvent(null, 401, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    usageListener.notifyMethodUsage(event);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 66: {
                            JavaMember resolvedMember;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            String text = sourceDocReference.getText();
                            if (text.indexOf(methodName) == -1 || !javaMethod.equals((Object)(resolvedMember = sourceDocReference.getResolvedMember()))) break;
                            MethodUsageEvent event = new MethodUsageEvent(null, 4, url, sourceDocReference.getStartOffset(), sourceDocReference.getEndOffset());
                            usageListener.notifyMethodUsage(event);
                            break;
                        }
                    }
                    ++j;
                }
            } else {
                usageListener.notifySkipped(new UsageEvent(null, 3, url));
            }
            ++i;
        }
    }

    private void findFieldUsages(JavaManager javaManager, JavaField javaField, URL[] urls, FieldUsageListener usageListener) {
        String fieldName = javaField.getName();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            SourceFile sourceFile = javaManager.getSourceFile(url);
            if (sourceFile != null) {
                List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{20, 66});
                int j = 0;
                while (j < sourceElements.size()) {
                    SourceElement sourceElement = (SourceElement)sourceElements.get(j);
                    block0 : switch (sourceElement.getSymbolKind()) {
                        case 20: {
                            SourceName sourceName = (SourceName)sourceElement;
                            String name = sourceName.getName();
                            if (!fieldName.equals(name)) break;
                            SourceElement parent = sourceName.getParent();
                            switch (parent.getSymbolKind()) {
                                case 49: 
                                case 57: {
                                    SourceExpression sourceExpression = (SourceExpression)parent;
                                    JavaHasType resolvedObject = sourceExpression.getResolvedObject();
                                    if (!javaField.equals(resolvedObject)) break block0;
                                    FieldUsageEvent event = new FieldUsageEvent(null, 202, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    usageListener.notifyFieldUsage(event);
                                    break block0;
                                }
                                case 10: {
                                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)parent;
                                    if (!javaField.equals(sourceFieldVariable)) break block0;
                                    FieldUsageEvent event = new FieldUsageEvent(null, 201, url, sourceName.getStartOffset(), sourceName.getEndOffset());
                                    usageListener.notifyFieldUsage(event);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 66: {
                            JavaMember resolvedMember;
                            SourceDocReference sourceDocReference = (SourceDocReference)sourceElement;
                            if (!sourceDocReference.getText().endsWith(fieldName) || !javaField.equals(resolvedMember = sourceDocReference.getResolvedMember())) break;
                            FieldUsageEvent event = new FieldUsageEvent(null, 201, url, sourceDocReference.getStartOffset(), sourceDocReference.getEndOffset());
                            usageListener.notifyFieldUsage(event);
                            break;
                        }
                    }
                    ++j;
                }
            } else {
                usageListener.notifySkipped(new UsageEvent(null, 3, url));
            }
            ++i;
        }
    }

    private MultiMap<String, URL> searchKeywords(Project project) {
        String[] keywords = this.getSearchKeywords();
        MultiMap keywordHits = new MultiMap();
        ContentSet content = PathsConfiguration.getInstance((Project)project).getJavaContentSet();
        IndexManager manager = IndexManager.getIndexManager();
        Index index = manager.getIndex(project, content);
        try {
            try {
                index.lock();
                try {
                    String[] stringArray = keywords;
                    int n = 0;
                    while (n < stringArray.length) {
                        String keyword = stringArray[n];
                        QueryCriteria criteria = KeywordCriteria.get((String)keyword);
                        URL[] urls = (URL[])index.query(criteria).get();
                        keywordHits.addAll((Object)keyword, Arrays.asList(urls));
                        ++n;
                    }
                }
                finally {
                    index.unlock();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (RejectedExecutionException ree) {
            }
            catch (ExecutionException ee) {
                Assert.printStackTrace((Throwable)ee);
            }
            catch (LockFailedException lfe) {
                Assert.printStackTrace((Throwable)lfe);
            }
        }
        finally {
            index.release();
        }
        return keywordHits;
    }

    private String[] getSearchKeywords() {
        HashSet<String> nameSet = new HashSet<String>();
        int i = 0;
        while (i < this._members.size()) {
            JavaMember member = (JavaMember)this._members.get(i);
            String name = FindMemberUsages.getMemberName(member);
            nameSet.add(name);
            ++i;
        }
        String[] keywords = nameSet.toArray(new String[nameSet.size()]);
        return keywords;
    }

    private static String getMemberName(JavaMember member) {
        JavaMethod javaMethod;
        if (member.getElementKind() == 8 && (javaMethod = (JavaMethod)member).isConstructor()) {
            JavaClass owningClass = member.getOwningClass();
            String className = owningClass.getName();
            return className;
        }
        String memberName = member.getName();
        return memberName;
    }

    public URL[] findMemberUsages(Project project) {
        this._keywordHits = this.searchKeywords(project);
        MyUsageListener myUsageListener = new MyUsageListener(project);
        this.verifyHits(project, myUsageListener);
        return myUsageListener.getUrls();
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ HashSet v$memberSet;
        private final /* synthetic */ JotUsageListener v$usageListener;
        private final /* synthetic */ HashSet v$memberNames;
        private final /* synthetic */ HashSet v$notMembersSet;
        final /* synthetic */ FindMemberUsages this$0;

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
            JavaMethod resolvedMethod = sourceClassCreatorExpression.getResolvedMethod();
            if (this.v$memberSet.contains(resolvedMethod)) {
                this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceClassCreatorExpression);
            }
        }

        protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
            JavaMethod resolvedMethod;
            String methodName = sourceMethodCallExpression.getName();
            if (this.v$memberNames.contains(methodName) && (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) != null) {
                if (this.v$memberSet.contains(resolvedMethod)) {
                    this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceMethodCallExpression);
                } else if (!this.v$notMembersSet.contains(resolvedMethod)) {
                    if (!resolvedMethod.isStatic()) {
                        boolean isSub = false;
                        Collection overriddenMethods = resolvedMethod.getOverriddenMethods();
                        Iterator iterator = overriddenMethods.iterator();
                        while (!isSub && iterator.hasNext()) {
                            JavaMethod javaMethod = (JavaMethod)iterator.next();
                            if (!this.v$memberSet.contains(javaMethod)) continue;
                            this.v$usageListener.whenMethodUsage((SourceInvokeExpression)sourceMethodCallExpression);
                            isSub = true;
                        }
                        if (isSub) {
                            for (JavaMethod javaMethod : overriddenMethods) {
                                this.v$memberSet.add(javaMethod);
                                if (resolvedMethod != javaMethod) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.v$notMembersSet.addAll(overriddenMethods);
                        }
                    } else {
                        this.v$notMembersSet.add(resolvedMethod);
                    }
                }
            }
        }

        protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
            JavaHasType resolvedObject;
            String name = sourceDotExpression.getName();
            if (this.v$memberNames.contains(name) && this.v$memberSet.contains(resolvedObject = sourceDotExpression.getResolvedObject())) {
                this.v$usageListener.whenFieldUsage((SourceExpression)sourceDotExpression);
            }
        }

        protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
            JavaHasType resolvedObject;
            String name = sourceSimpleNameExpression.getName();
            if (this.v$memberNames.contains(name) && this.v$memberSet.contains(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
                this.v$usageListener.whenFieldUsage((SourceExpression)sourceSimpleNameExpression);
            }
        }

        protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
            JavaClass owningClass;
            String className;
            if (this.v$memberSet.contains(sourceMethod)) {
                this.v$usageListener.whenMethodDeclaration(sourceMethod);
            } else if (!this.v$notMembersSet.contains(sourceMethod) && this.v$memberNames.contains(className = (owningClass = sourceMethod.getOwningClass()).getName())) {
                if (this.v$memberSet.contains(sourceMethod)) {
                    this.v$usageListener.whenMethodDeclaration(sourceMethod);
                } else {
                    this.v$notMembersSet.add(sourceMethod);
                }
            }
        }

        protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
            String methodName;
            if (this.v$memberSet.contains(sourceMethod)) {
                this.v$usageListener.whenMethodDeclaration(sourceMethod);
            } else if (!this.v$notMembersSet.contains(sourceMethod) && this.v$memberNames.contains(methodName = sourceMethod.getName())) {
                Collection overriddenMethods = sourceMethod.getOverriddenMethods();
                if (IdeUtil.containsAny((AbstractCollection)this.v$memberSet, (Collection)overriddenMethods)) {
                    this.v$memberSet.addAll(overriddenMethods);
                    this.v$usageListener.whenMethodDeclaration(sourceMethod);
                } else {
                    this.v$notMembersSet.addAll(overriddenMethods);
                }
            }
        }

        public 1(FindMemberUsages findMemberUsages, HashSet hashSet, JotUsageListener jotUsageListener, HashSet hashSet2, HashSet hashSet3) {
            this.v$notMembersSet = hashSet3;
            this.v$memberNames = hashSet2;
            this.v$usageListener = jotUsageListener;
            this.v$memberSet = hashSet;
            this.this$0 = findMemberUsages;
        }
    }

    public static class JotUsageListener {
        public void whenMethodDeclaration(SourceMethod sourceMethod) {
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
        }

        public void whenFieldUsage(SourceExpression sourceExpression) {
        }
    }

    private static class MyUsageListener
    implements MethodUsageListener,
    FieldUsageListener,
    ConstructorUsageListener {
        private HashSet _verifiedUrls;
        private ContentSet _allContents;

        private void $init$() {
            this._verifiedUrls = new HashSet();
        }

        public MyUsageListener(Project project) {
            this.$init$();
            this._allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        }

        public void notifyMethodUsage(MethodUsageEvent event) {
            URL url = event.getURL();
            if (this._allContents.canHaveMember(url)) {
                this._verifiedUrls.add(url);
            }
        }

        public void notifyConstructorUsage(ConstructorUsageEvent event) {
            URL url = event.getURL();
            if (this._allContents.canHaveMember(url)) {
                this._verifiedUrls.add(url);
            }
        }

        public void notifyFieldUsage(FieldUsageEvent event) {
            URL url;
            int usageCode = event.getUsageCode();
            if (usageCode == 202 && this._allContents.canHaveMember(url = event.getURL())) {
                this._verifiedUrls.add(url);
            }
        }

        public void notifyFinished(UsageEvent event) {
        }

        public void notifySkipped(UsageEvent event) {
        }

        public URL[] getUrls() {
            return this._verifiedUrls.toArray(new URL[this._verifiedUrls.size()]);
        }
    }

    public static class FillListsUsageListener
    extends JotUsageListener {
        private final List _methodDeclarations;
        private final List _sourceInvokeExpressions;
        private final List _sourceExpressions;

        public FillListsUsageListener(List methodDeclarations, List methodCalls, List fieldAccesses) {
            this._methodDeclarations = methodDeclarations;
            this._sourceInvokeExpressions = methodCalls;
            this._sourceExpressions = fieldAccesses;
        }

        public List getSourceExpressions() {
            return this._sourceExpressions;
        }

        public List getSourceInvokeExpressions() {
            return this._sourceInvokeExpressions;
        }

        public List getSourceMethods() {
            return this._methodDeclarations;
        }

        public void whenMethodDeclaration(SourceMethod sourceMethod) {
            if (this._methodDeclarations != null) {
                this._methodDeclarations.add(sourceMethod);
            }
        }

        public void whenMethodUsage(SourceInvokeExpression sourceInvokeExpression) {
            if (this._sourceInvokeExpressions != null) {
                this._sourceInvokeExpressions.add(sourceInvokeExpression);
            }
        }

        public void whenFieldUsage(SourceExpression sourceExpression) {
            if (this._sourceExpressions != null) {
                this._sourceExpressions.add(sourceExpression);
            }
        }
    }
}

