/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;

public class IdenticalElementComparator {
    public static SourceElement[] find(SourceElement elementToFind, SourceElement elementToSearch) {
        ArrayList found = new ArrayList();
        IdenticalElementComparator.find(elementToFind, elementToSearch, found);
        return found.toArray(new SourceElement[found.size()]);
    }

    private static void find(SourceElement elementToFind, SourceElement elementToSearch, ArrayList found) {
        if (IdenticalElementComparator.compare(elementToFind, elementToSearch)) {
            found.add(elementToSearch);
        } else {
            List children = elementToSearch.getChildren();
            int i = 0;
            while (i < children.size()) {
                SourceElement childElement = (SourceElement)children.get(i);
                IdenticalElementComparator.find(elementToFind, childElement, found);
                ++i;
            }
        }
    }

    public static boolean compare(SourceElement sourceElement_1, SourceElement sourceElement_2) {
        int nodeID_2;
        int nodeID;
        boolean ret = false;
        if (sourceElement_1 != null && sourceElement_2 != null && (nodeID = sourceElement_1.getSymbolKind()) == (nodeID_2 = sourceElement_2.getSymbolKind())) {
            switch (nodeID) {
                case 49: 
                case 57: {
                    SourceExpression sourceExpression_1 = (SourceExpression)sourceElement_1;
                    SourceExpression sourceExpression_2 = (SourceExpression)sourceElement_2;
                    ret = IdenticalElementComparator.compareResolvableExpressions(sourceExpression_1, sourceExpression_2);
                    break;
                }
                case 53: 
                case 55: {
                    SourceExpression sourceExpression_1 = (SourceExpression)sourceElement_1;
                    SourceExpression sourceExpression_2 = (SourceExpression)sourceElement_2;
                    if (!IdenticalElementComparator.compareResolvableExpressions(sourceExpression_1, sourceExpression_2)) break;
                    ret = IdenticalElementComparator.compareChildren(sourceElement_1, sourceElement_2);
                    break;
                }
                case 52: {
                    SourceLiteralExpression sourceLiteralExpression_1 = (SourceLiteralExpression)sourceElement_1;
                    SourceLiteralExpression sourceLiteralExpression_2 = (SourceLiteralExpression)sourceElement_2;
                    ret = IdenticalElementComparator.compareLiteralExpressions(sourceLiteralExpression_1, sourceLiteralExpression_2);
                    break;
                }
                case 50: {
                    SourceInfixExpression sourceInfixExpression_1 = (SourceInfixExpression)sourceElement_1;
                    SourceInfixExpression sourceInfixExpression_2 = (SourceInfixExpression)sourceElement_2;
                    if (sourceInfixExpression_1.getOperatorCode() != sourceInfixExpression_2.getOperatorCode()) break;
                    ret = IdenticalElementComparator.compareChildren((SourceElement)sourceInfixExpression_1, (SourceElement)sourceInfixExpression_2);
                    break;
                }
                default: {
                    ret = IdenticalElementComparator.compareChildren(sourceElement_1, sourceElement_2);
                }
            }
        }
        return ret;
    }

    private static boolean compareLiteralExpressions(SourceLiteralExpression sourceLiteralExpression_1, SourceLiteralExpression sourceLiteralExpression_2) {
        String text_1 = sourceLiteralExpression_1.getText();
        String text_2 = sourceLiteralExpression_2.getText();
        boolean ret = text_1.equals(text_2);
        return ret;
    }

    private static boolean compareChildren(SourceElement sourceElement_1, SourceElement sourceElement_2) {
        boolean ret = false;
        List children_1 = sourceElement_1.getChildren();
        List children_2 = sourceElement_2.getChildren();
        int size = children_1.size();
        if (size == children_2.size()) {
            ret = true;
            int i = 0;
            while (ret && i < size) {
                SourceElement child_1 = (SourceElement)children_1.get(i);
                SourceElement child_2 = (SourceElement)children_2.get(i);
                ret = IdenticalElementComparator.compare(child_1, child_2);
                ++i;
            }
        }
        return ret;
    }

    private static boolean compareResolvableExpressions(SourceExpression sourceExpression_1, SourceExpression sourceExpression_2) {
        JavaHasType resolvedObject_2;
        boolean ret = false;
        JavaHasType resolvedObject_1 = sourceExpression_1.getResolvedObject();
        if (resolvedObject_1 != null && (resolvedObject_2 = sourceExpression_2.getResolvedObject()) != null && resolvedObject_1.equals(resolvedObject_2)) {
            ret = true;
        }
        return ret;
    }
}

