/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.refactoring.util.Util;

public class JotListCellRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Pair) {
            Pair pair = (Pair)value;
            return this.getListCellRendererComponent(list, pair.first, index, isSelected, cellHasFocus);
        }
        Icon icon = null;
        if (value instanceof SourceElement) {
            SourceElement sourceElement = (SourceElement)value;
            int nodeID = sourceElement.getSymbolKind();
            switch (nodeID) {
                case 3: {
                    SourceClass sourceClass = (SourceClass)sourceElement;
                    value = sourceClass.getName();
                    if (sourceClass.isInterface()) {
                        icon = OracleIcons.getIcon((String)"interface.png");
                        break;
                    }
                    icon = OracleIcons.getIcon((String)"class.png");
                    break;
                }
                case 19: {
                    SourceMethod sourceMethod = (SourceMethod)sourceElement;
                    value = Util.getFullMethodName((JavaMethod)sourceMethod, false, false, false);
                    icon = OracleIcons.getIcon((String)"method.png");
                    break;
                }
                case 9: {
                    SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    SourceTypeReference sourceType = sourceFieldVariable.getSourceType();
                    String typeName = sourceType.getName();
                    value = sourceFieldVariable.getName() + ":" + typeName;
                    icon = OracleIcons.getIcon((String)"field.png");
                    break;
                }
            }
        }
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setIcon(icon);
        return component;
    }
}

