/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.jdeveloper.refactoring.util.Util;

public class JotTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean _includeClassName;
    private boolean _fqClassName;
    private boolean _fqParamNames;

    private void $init$() {
        this._fqClassName = true;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon = null;
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof JavaMethod) {
                JavaMethod javaMethod = (JavaMethod)userObject;
                value = Util.getFullMethodName(javaMethod, this._includeClassName, this._fqClassName, this._fqParamNames);
                icon = javaMethod.isConstructor() ? OracleIcons.getIcon((String)"constructor.png") : OracleIcons.getIcon((String)"method.png");
            } else if (userObject instanceof JavaField) {
                JavaField javaField = (JavaField)userObject;
                if (this._includeClassName) {
                    JavaClass owningClass = javaField.getOwningClass();
                    String owningClassName = this._fqClassName ? owningClass.getQualifiedName() : owningClass.getName();
                    value = owningClassName + '.' + javaField.getName();
                } else {
                    value = javaField.getName();
                }
                icon = OracleIcons.getIcon((String)"field.png");
            } else if (userObject instanceof JavaClass) {
                JavaClass javaClass = (JavaClass)userObject;
                value = this._fqClassName ? javaClass.getQualifiedName() : javaClass.getName();
                icon = javaClass.isInterface() ? OracleIcons.getIcon((String)"interface.png") : OracleIcons.getIcon((String)"class.png");
            } else if (userObject instanceof JavaPackage) {
                JavaPackage javaPackage = (JavaPackage)userObject;
                value = javaPackage.getName();
                icon = OracleIcons.getIcon((String)"package.png");
            } else if (userObject instanceof JavaLocalVariable) {
                JavaLocalVariable javaLocalVariable = (JavaLocalVariable)userObject;
                value = javaLocalVariable.getName();
                icon = OracleIcons.getIcon((String)"field.png");
            }
        }
        Component rendererComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (icon != null) {
            this.setIcon(icon);
        }
        return rendererComponent;
    }

    public JotTreeCellRenderer() {
        this.$init$();
    }
}

