/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class MemberAccess {
    public static Set getAccessedMembers(SourceElement scope) {
        HashSet<Object> ret = new HashSet<Object>();
        List elements = SourceElementAsList.asList((SourceElement)scope, (int[])new int[]{27, 55, 53, 49, 57});
        int i = 0;
        while (i < elements.size()) {
            SourceElement sourceElement = (SourceElement)elements.get(i);
            int symbolKind = sourceElement.getSymbolKind();
            block0 : switch (symbolKind) {
                case 27: {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
                    JavaType resolvedType = sourceTypeReference.getResolvedType();
                    if (resolvedType == null || resolvedType.isPublic()) break;
                    if (resolvedType.isArray()) {
                        resolvedType = resolvedType.getComponentType();
                    }
                    resolvedType = resolvedType.getTypeErasure();
                    ret.add(resolvedType);
                    break;
                }
                case 53: 
                case 55: {
                    SourceInvokeExpression sourceInvokeExpression = (SourceInvokeExpression)sourceElement;
                    JavaMethod resolvedMethod = sourceInvokeExpression.getResolvedMethod();
                    if (resolvedMethod == null || resolvedMethod.isPublic()) break;
                    ret.add(resolvedMethod);
                    break;
                }
                case 49: 
                case 57: {
                    SourceExpression sourceDotExpression = (SourceExpression)sourceElement;
                    JavaHasType resolvedObject = sourceDotExpression.getResolvedObject();
                    if (resolvedObject == null) break;
                    int elementKind = resolvedObject.getElementKind();
                    switch (elementKind) {
                        case 5: {
                            JavaField javaField = (JavaField)resolvedObject;
                            if (javaField.isPublic()) break block0;
                            ret.add(javaField);
                            break block0;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    public static boolean updateAccessModifiers(RefactoringCommandSupport refactoringCommandSupport, SourceElement scope, SourceClass targetSourceClass) {
        SourceFile targetSourceFile;
        boolean ret = true;
        SourceFile srcSourceFile = scope.getOwningSourceFile();
        boolean isSameFile = srcSourceFile.equals(targetSourceFile = targetSourceClass.getOwningSourceFile());
        if (!isSameFile) {
            Set accessedMembers = MemberAccess.getAccessedMembers(scope);
            String srcPackageName = srcSourceFile.getPackageName();
            String targetPackageName = targetSourceFile.getPackageName();
            boolean isSamePackage = srcPackageName.equals(targetPackageName);
            ArrayList<JavaMember> modifyMembers = new ArrayList<JavaMember>();
            for (JavaMember javaMember : accessedMembers) {
                if (javaMember.isPrivate()) {
                    modifyMembers.add(javaMember);
                    continue;
                }
                if (isSamePackage || !javaMember.isPackagePrivate() && !javaMember.isProtected()) continue;
                modifyMembers.add(javaMember);
            }
            if (modifyMembers.size() > 0) {
                ret = MemberAccess.confirmAndUpdateAccessModifiers(refactoringCommandSupport, modifyMembers);
            }
        }
        return ret;
    }

    public static boolean confirmAndUpdateAccessModifiers(RefactoringCommandSupport refactoringCommandSupport, Collection modifyMembers) {
        boolean ret = false;
        Collection membersToModify = MemberAccess.confirmMembers(modifyMembers);
        if (membersToModify != null) {
            MemberAccess.updateConfirmedMembers(refactoringCommandSupport, membersToModify);
            ret = true;
        }
        return ret;
    }

    public static Collection confirmMembers(Collection modifyMembers) {
        ArrayList<JavaMember> ret = Collections.EMPTY_LIST;
        int size = modifyMembers.size();
        if (size > 0) {
            Object[] columnNames = new String[]{" ", RefactoringArb.getString(148), RefactoringArb.getString(170)};
            Object[][] data = new Object[size][3];
            Iterator iterator = modifyMembers.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String prettyName;
                JavaMember javaMember = (JavaMember)iterator.next();
                int elementKind = javaMember.getElementKind();
                switch (elementKind) {
                    case 3: {
                        JavaClass javaClass = (JavaClass)javaMember;
                        prettyName = javaClass.getQualifiedName();
                        break;
                    }
                    case 5: {
                        JavaField javaField = (JavaField)javaMember;
                        JavaClass owningClass = javaField.getOwningClass();
                        String qualifiedName = owningClass.getQualifiedName();
                        String fieldName = javaField.getName();
                        prettyName = qualifiedName + "." + fieldName;
                        break;
                    }
                    case 8: {
                        JavaMethod javaMethod = (JavaMethod)javaMember;
                        prettyName = Util.getFullMethodName(javaMethod, true, true, false);
                        break;
                    }
                    default: {
                        prettyName = "???";
                        break;
                    }
                }
                data[i][0] = Boolean.TRUE;
                data[i][1] = prettyName;
                data[i][2] = "public";
                ++i;
            }
            1 defaultTableModel = new 1(data, columnNames);
            NiceTable table = new NiceTable((TableModel)defaultTableModel);
            table.setAutoResizeMode(0);
            table.autoSizeColumnsToFit();
            JLabel label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)table, (String)RefactoringArb.getString(371));
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.getViewport().setBackground(table.getBackground());
            JPanel panel = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_jrf_dconfirmaccssbltychng_html");
            JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(259), 7);
            dialog.setContent((Component)panel);
            dialog.setResizable(true);
            if (dialog.runDialog()) {
                ret = new ArrayList<JavaMember>(modifyMembers.size());
                Iterator iterator2 = modifyMembers.iterator();
                int i2 = 0;
                while (iterator2.hasNext()) {
                    JavaMember javaMember = (JavaMember)iterator2.next();
                    Object value = defaultTableModel.getValueAt(i2, 0);
                    if (Boolean.TRUE.equals(value)) {
                        ret.add(javaMember);
                    }
                    ++i2;
                }
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public static void updateConfirmedMembers(RefactoringCommandSupport refactoringCommandSupport, Collection membersToModify) {
        for (JavaMember javaMember : membersToModify) {
            SourceMember sourceMember = (SourceMember)javaMember.getSourceElement();
            if (sourceMember == null) continue;
            refactoringCommandSupport.beginTransaction((SourceElement)sourceMember);
            sourceMember.removeModifiers(6);
            sourceMember.addModifiers(1);
        }
    }

    static final class 1
    extends DefaultTableModel {
        public Class getColumnClass(int columnIndex) {
            if (columnIndex != 0) {
                return super.getColumnClass(columnIndex);
            }
            return Boolean.class;
        }

        public 1(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }
    }
}

