/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class NameValidation {
    private boolean _valid;
    private String _message;

    private NameValidation() {
    }

    private NameValidation(boolean valid, String message) {
        this._valid = valid;
        this._message = message;
    }

    public static NameValidation validateMethodForRename(SourceMethod sourceMethod, String newMethodName) {
        NameValidation validation = NameValidation.validateMethodName(newMethodName, true);
        if (validation.isValid()) {
            SourceClass enclosingClass = sourceMethod.getEnclosingClass();
            Collection methods = enclosingClass.getMethods(newMethodName);
            JavaType[] sourceParameterTypes = sourceMethod.getParameterTypes();
            for (JavaMethod method : methods) {
                if (!CommonUtilities.matchMethod((JavaMethod)method, (JavaType[])sourceParameterTypes)) continue;
                if (enclosingClass.equals((Object)method.getOwningClass())) {
                    validation.setMessage(RefactoringArb.getString(267));
                    validation.setValid(false);
                    return validation;
                }
                int modifiers = method.getModifiers();
                if (BitField.isSet((int)sourceMethod.getModifiers(), (int)2) || BitField.isSet((int)modifiers, (int)2) || !BitField.isSet((int)modifiers, (int)16)) continue;
                validation.setMessage("Cannot override final method " + method.getName() + " declared in " + method.getOwningClass().getName() + ".");
                validation.setValid(false);
                return validation;
            }
        }
        return validation;
    }

    public static NameValidation validateMethod(SourceMethod sourceMethod, String methodName) {
        NameValidation ret = NameValidation.validateMethodName(methodName, true);
        if (ret.isValid() && NameValidation.isMethodAlreadyPresent(sourceMethod, methodName)) {
            ret.setMessage(RefactoringArb.getString(267));
            ret.setValid(false);
        }
        return ret;
    }

    public static NameValidation validateMethodName(String methodName, boolean silentlyRefuseEmptyNames) {
        NameValidation ret = new NameValidation();
        String message = null;
        boolean isValid = true;
        if (methodName.length() == 0) {
            isValid = false;
            if (!silentlyRefuseEmptyNames) {
                message = RefactoringArb.getString(304);
            }
        } else if (!NamingUtil.isJavaIdentifier((String)methodName)) {
            message = RefactoringArb.getString(128);
            isValid = false;
        } else if (NamingUtil.isJavaReservedWord((String)methodName)) {
            message = RefactoringArb.getString(128);
            isValid = false;
        } else if (Character.isUpperCase(methodName.charAt(0))) {
            message = RefactoringArb.getString(96);
        }
        ret.setMessage(message);
        ret.setValid(isValid);
        return ret;
    }

    public static NameValidation validateClassName(SourceClass oldSourceClass, Project project, String packageName, String newClassName, boolean checkExistence) {
        if (oldSourceClass.equals((Object)oldSourceClass.getOwningSourceFile().getPrimaryClass())) {
            URL oldURL = oldSourceClass.getURL();
            URL dirURL = URLFileSystem.getParent((URL)oldURL);
            String newFileName = newClassName + ".java";
            URL newURL = URLFileSystem.canonicalize((URL)URLFactory.newFileURL((String)(dirURL.getPath() + newFileName)));
            if (URLFileSystem.exists((URL)newURL)) {
                NameValidation ret = new NameValidation();
                ret.setMessage(newFileName + " already exists in the same directory.");
                ret.setValid(false);
                return ret;
            }
        }
        return NameValidation.validateClassName(project, packageName, newClassName, checkExistence);
    }

    public static NameValidation validateClassName(Project project, String packageName, String className, boolean checkExistence) {
        NameValidation ret = new NameValidation();
        String message = "";
        boolean isValid = true;
        if (className.length() == 0) {
            isValid = false;
        } else if (!NamingUtil.isJavaIdentifier((String)className)) {
            message = RefactoringArb.getString(164);
            isValid = false;
        } else if (className.lastIndexOf(36) >= 0) {
            message = RefactoringArb.getString(164);
            isValid = false;
        } else if (NamingUtil.isJavaReservedWord((String)className)) {
            message = RefactoringArb.getString(164);
            isValid = false;
        } else if (checkExistence && NameValidation.isClassAlreadyPresent(project, packageName, className)) {
            message = MessageFormat.format(RefactoringArb.getString(163), className);
            isValid = false;
        } else if (!Character.isUpperCase(className.charAt(0))) {
            message = RefactoringArb.getString(23);
        }
        ret.setMessage(message);
        ret.setValid(isValid);
        return ret;
    }

    public static NameValidation validateFieldName(String fieldName, boolean isConstant, SourceElement sourceElement) {
        String message = "";
        boolean isValid = true;
        if (fieldName != null && fieldName.length() == 0) {
            isValid = false;
        } else {
            String canIntroduceField = VariableNaming.canIntroduceField(sourceElement, fieldName);
            if (canIntroduceField != null) {
                message = canIntroduceField;
                isValid = false;
            } else if (!isConstant) {
                if (Character.isUpperCase(fieldName.charAt(0))) {
                    message = RefactoringArb.getString(92);
                }
            } else if (!NameValidation.isGoodConstantName(fieldName)) {
                message = RefactoringArb.getString(113);
            }
        }
        NameValidation ret = new NameValidation(isValid, message);
        return ret;
    }

    public static boolean isGoodConstantName(String fieldName) {
        int length = fieldName.length();
        int i = 0;
        while (i < length) {
            char c = fieldName.charAt(i);
            if (Character.isLetter(c) && Character.isLowerCase(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isClassAlreadyPresent(Project project, String packageName, String className) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        String fqName = packageName.length() == 0 ? className : packageName + "." + className;
        SourceClass newClass = javaManager.getSourceClass(fqName);
        return newClass != null;
    }

    private void setValid(boolean valid) {
        this._valid = valid;
    }

    public boolean isValid() {
        return this._valid;
    }

    private void setMessage(String message) {
        this._message = message;
    }

    public String getMessage() {
        return this._message;
    }

    private static boolean isMethodAlreadyPresent(SourceMethod sourceMethod, String newMethodName) {
        SourceClass sourceClass = sourceMethod.getEnclosingClass();
        Collection parameterTypes = sourceMethod.getParameters();
        JavaHasType[] javaHasTypes = parameterTypes.toArray(new JavaHasType[parameterTypes.size()]);
        return NameValidation.isMethodAlreadyPresent(sourceClass, newMethodName, javaHasTypes);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isMethodAlreadyPresent(SourceClass fromClass, String methodName, JavaHasType[] javaHasTypes) {
        sourceClass = fromClass;
        methods = fromClass.getSourceMethods();
        if (methods.size() == 0) ** GOTO lbl19
        callerContext = CallerContext.createContext((SourceElement)((SourceElement)methods.get(0)));
        tps = new JavaType[javaHasTypes.length];
        i = 0;
        while (i < tps.length) {
            tps[i] = javaHasTypes[i].getResolvedType();
            ++i;
        }
        meth = callerContext.resolveMethod(null, methodName, tps);
        if (meth == null) ** GOTO lbl19
        return true;
lbl-1000:
        // 1 sources

        {
            if (NameValidation.isMethodAlreadyPresent((JavaType)fromClass, (JavaType)sourceClass, methodName, javaHasTypes)) {
                return true;
            }
            if (NameValidation.recIsMethodPresentInItface((JavaType)fromClass, (JavaType)sourceClass, methodName, javaHasTypes)) {
                return true;
            }
            sourceClass = sourceClass.getSuperclass();
lbl19:
            // 3 sources

            ** while (sourceClass != null)
        }
lbl20:
        // 1 sources

        return false;
    }

    private static boolean recIsMethodPresentInItface(JavaType fromClass, JavaType inClass, String methodName, JavaHasType[] javaHasTypes) {
        Collection interfaces = inClass.getInterfaces();
        for (JavaType javaType : interfaces) {
            if (!NameValidation.isMethodAlreadyPresent(fromClass, javaType, methodName, javaHasTypes)) continue;
            return true;
        }
        for (JavaType javaType : interfaces) {
            NameValidation.recIsMethodPresentInItface(fromClass, javaType, methodName, javaHasTypes);
        }
        return false;
    }

    private static boolean isMethodAlreadyPresent(JavaType fromClass, JavaType inClass, String methodName, JavaHasType[] javaHasTypes) {
        JavaType[] javaTypes = Patch.javaHasTypes2JavaTypes(Arrays.asList(javaHasTypes));
        JavaMethod existingMethod = inClass.getMethod(methodName, javaTypes);
        if (existingMethod != null) {
            int modifiers = existingMethod.getModifiers();
            if (BitField.isSet((int)modifiers, (int)1) || BitField.isSet((int)modifiers, (int)4)) {
                return true;
            }
            if (BitField.isSet((int)modifiers, (int)2)) {
                return fromClass == inClass;
            }
            return fromClass.getPackageName().equals(inClass.getPackageName());
        }
        return false;
    }
}

