/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public class ReadOnlyTextBuffer
implements TextBuffer {
    private char[] _text;
    private LineMap _lineMap;

    public ReadOnlyTextBuffer(String text) {
        this._text = text.toCharArray();
    }

    public void beginEdit() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit endEdit() {
        return null;
    }

    public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public LineMap getLineMap() {
        if (this._lineMap == null) {
            this._lineMap = new MyLineMap();
        }
        return this._lineMap;
    }

    public void addTextBufferListener(TextBufferListener listener) {
    }

    public void removeTextBufferListener(TextBufferListener listener) {
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void writeLock() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeUnlock() {
    }

    public OffsetMark addOffsetMark(int offset) {
        return null;
    }

    public OffsetMark addOffsetMark(int offset, boolean bias) {
        return null;
    }

    public void removeOffsetMark(OffsetMark offsetMark) {
    }

    public boolean isModified() {
        return false;
    }

    public void clearModified() {
    }

    public int getChangeId() {
        return 0;
    }

    public void read(Reader reader) throws IOException {
        throw new ReadOnlyException();
    }

    public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void write(Writer writer) throws IOException {
    }

    public void write(Writer writer, boolean clearModified) throws IOException {
    }

    public String getPlatformEOLType() {
        return "\r\n";
    }

    public String getEOLType() {
        return "\n";
    }

    public void setEOLType(String eolType) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public int getLength() {
        return this._text.length;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        return this._text[offset];
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        char[] ret = new char[length];
        System.arraycopy(this._text, offset, ret, 0, length);
        return ret;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        return new String(this._text, offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this._text;
        segment.offset = offset;
        segment.count = length;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public void readUnlock() {
    }

    public int getLockStatus() {
        return 0;
    }

    static char[] ra$_text(ReadOnlyTextBuffer readOnlyTextBuffer) {
        return readOnlyTextBuffer._text;
    }

    private class MyLineMap
    implements LineMap {
        private int[] _offsets;

        public MyLineMap() {
            int[] offsets = new int[ReadOnlyTextBuffer.ra$_text(ReadOnlyTextBuffer.this).length];
            int line = 0;
            offsets[line++] = 0;
            int i = 0;
            while (i < ReadOnlyTextBuffer.ra$_text(ReadOnlyTextBuffer.this).length) {
                char c = ReadOnlyTextBuffer.ra$_text(ReadOnlyTextBuffer.this)[i];
                if (c == '\n') {
                    offsets[line++] = i + 1;
                }
                ++i;
            }
            this._offsets = new int[offsets.length];
            System.arraycopy(offsets, 0, this._offsets, 0, offsets.length);
        }

        public TextBuffer getTextBuffer() {
            return ReadOnlyTextBuffer.this;
        }

        public int getLineCount() {
            return this._offsets.length;
        }

        public int getLineFromOffset(int offset) {
            int pos = Arrays.binarySearch(this._offsets, offset);
            if (pos > 0) {
                return pos;
            }
            return 1 - pos;
        }

        public int getLineStartOffset(int line) {
            return this._offsets[line];
        }

        public int getLineEndOffset(int line) {
            return this._offsets[line + 1];
        }
    }
}

