/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;

public class SourceElementComparator {
    private ArrayList _duplicates;

    private void $init$() {
        this._duplicates = new ArrayList(0);
    }

    public SourceExpression[] getDuplicates() {
        return this._duplicates.toArray(new SourceExpression[this._duplicates.size()]);
    }

    public void findDuplicates(SourceExpression sourceExpression, SourceElement scope) {
        if (this.equals((SourceElement)sourceExpression, scope)) {
            this._duplicates.add(scope);
        } else {
            List children = scope.getChildren();
            int i = 0;
            while (i < children.size()) {
                SourceElement child = (SourceElement)children.get(i);
                this.findDuplicates(sourceExpression, child);
                ++i;
            }
        }
    }

    private boolean equals(SourceElement thisElement, SourceElement thatElement) {
        if (thisElement != thatElement) {
            int thatSymbolKind;
            int thisSymbolKind = thisElement.getSymbolKind();
            if (thisSymbolKind == (thatSymbolKind = thatElement.getSymbolKind())) {
                switch (thisSymbolKind) {
                    case 55: {
                        return false;
                    }
                    case 47: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 61: {
                        break;
                    }
                    case 48: 
                    case 50: 
                    case 60: {
                        SourceExpression thisExpression = (SourceExpression)thisElement;
                        SourceExpression thatExpression = (SourceExpression)thatElement;
                        int thisOperatorCode = thisExpression.getOperatorCode();
                        int thatOperatorCode = thatExpression.getOperatorCode();
                        if (thisOperatorCode != thatOperatorCode) {
                            return false;
                        }
                        switch (thisOperatorCode) {
                            case 1: 
                            case 20: 
                            case 35: {
                                return this.comparePermutationsOfChildren(thisExpression, thatExpression);
                            }
                        }
                        break;
                    }
                    case 52: {
                        SourceLiteralExpression thisLiteralExpression = (SourceLiteralExpression)thisElement;
                        SourceLiteralExpression thatLiteralExpression = (SourceLiteralExpression)thatElement;
                        String thisText = thisLiteralExpression.getText();
                        String thatText = thatLiteralExpression.getText();
                        return thisText.equals(thatText);
                    }
                    case 20: {
                        SourceName thisName = (SourceName)thisElement;
                        SourceName thatName = (SourceName)thatElement;
                        String thisText = thisName.getText();
                        String thatText = thatName.getText();
                        return thisText.equals(thatText);
                    }
                    case 57: {
                        SourceSimpleNameExpression thisSimpleNameExpression = (SourceSimpleNameExpression)thisElement;
                        SourceSimpleNameExpression thatSimpleNameExpression = (SourceSimpleNameExpression)thatElement;
                        String thisName = thisSimpleNameExpression.getName();
                        String thatName = thatSimpleNameExpression.getName();
                        if (!thisName.equals(thatName)) {
                            return false;
                        }
                        JavaHasType thisResolvedObject = thisSimpleNameExpression.getResolvedObject();
                        if (thisResolvedObject == null) {
                            return false;
                        }
                        JavaHasType thatResolvedObject = thatSimpleNameExpression.getResolvedObject();
                        return thisResolvedObject.equals(thatResolvedObject);
                    }
                    case 27: {
                        SourceTypeReference thisType = (SourceTypeReference)thisElement;
                        SourceTypeReference thatType = (SourceTypeReference)thatElement;
                        JavaType thisJavaType = thisType.getResolvedType();
                        if (thisJavaType == null) {
                            return false;
                        }
                        JavaType thatJavaType = thatType.getResolvedType();
                        return thisJavaType.equals((Object)thatJavaType);
                    }
                    default: {
                        System.out.println("Unknown symbol " + thisSymbolKind + " from " + thisElement.getStartOffset() + " to " + thisElement.getEndOffset());
                        break;
                    }
                }
                if (this.areChildrenEqual(thisElement, thatElement)) {
                    return true;
                }
            }
        } else {
            this._duplicates.add(thisElement);
        }
        return false;
    }

    private boolean comparePermutationsOfChildren(SourceExpression thisExpression, SourceExpression thatExpression) {
        int thatSize;
        List thisChildren = thisExpression.getChildren();
        List thatChildren = thatExpression.getChildren();
        int thisSize = thisChildren.size();
        if (thisSize == (thatSize = thatChildren.size())) {
            SourceElement[] thisElementArray = thisChildren.toArray(new SourceElement[thisSize]);
            SourceElement[] thatElementArray = thatChildren.toArray(new SourceElement[thatSize]);
            return this.comparePermutationsOfChildren(thisElementArray, thatElementArray, 0);
        }
        return false;
    }

    private boolean comparePermutationsOfChildren(SourceElement[] thisElementArray, SourceElement[] thatElementArray, int n) {
        if (n < thisElementArray.length) {
            SourceElement thisElement = thisElementArray[n];
            int i = n;
            while (i < thatElementArray.length) {
                SourceElement thatElement = thatElementArray[i];
                if (this.equals(thisElement, thatElement)) {
                    SourceElementComparator.swap(thatElementArray, i, n);
                    if (this.comparePermutationsOfChildren(thisElementArray, thatElementArray, n + 1)) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private static void swap(SourceElement[] elements, int i, int j) {
        SourceElement swapped = elements[i];
        elements[i] = elements[j];
        elements[j] = swapped;
    }

    private boolean areChildrenEqual(SourceElement thisElement, SourceElement thatElement) {
        int thatSize;
        List thisChildren = thisElement.getChildren();
        List thatChildren = thatElement.getChildren();
        int thisSize = thisChildren.size();
        if (thisSize == (thatSize = thatChildren.size())) {
            int i = 0;
            while (i < thisSize) {
                SourceElement thatChild;
                SourceElement thisChild = (SourceElement)thisChildren.get(i);
                if (!this.equals(thisChild, thatChild = (SourceElement)thatChildren.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public SourceElementComparator() {
        this.$init$();
    }
}

