/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.RunMgrArb;

public class DefaultRunnablePanel
extends JPanel {
    private final URLTextField targetTextField;
    private final JCheckBox runActiveFileCheckBox;
    private Context context;
    private URL urlSourcePath;
    private JEWTDialog dlg;

    public DefaultRunnablePanel() {
        this(true, RunMgrArb.getString(63));
    }

    public DefaultRunnablePanel(boolean displayActiveFileCheckbox, String defaultTargetPrompt) {
        JLabel textFieldLabel = new JLabel();
        this.targetTextField = new URLTextField(null, false, true);
        JButton browseButton = new JButton();
        this.runActiveFileCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)textFieldLabel, (Component)this.targetTextField, (String)defaultTargetPrompt);
        ResourceUtils.resButton((AbstractButton)browseButton, (String)RunMgrArb.getString(32));
        this.targetTextField.setDialogTitle(RunMgrArb.getString(4));
        this.targetTextField.setChooserInit((URLChooserInit)new 1());
        browseButton.addActionListener((ActionListener)this.targetTextField);
        ResourceUtils.resButton((AbstractButton)this.runActiveFileCheckBox, (String)RunMgrArb.getString(16));
        this.targetTextField.getDocument().addDocumentListener(new 2());
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)textFieldLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.targetTextField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)browseButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        if (displayActiveFileCheckbox) {
            this.add((Component)this.runActiveFileCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        }
    }

    Component getInitialFocus() {
        return this.targetTextField;
    }

    private URL _getURL() {
        String text = this.targetTextField.getText();
        if (text.trim().length() == 0) {
            return null;
        }
        URL url = this.targetTextField.getURL();
        if (url == null) {
            url = URLFactory.newDirURL((String)this.context.getProject().getBaseDirectory());
            url = URLFactory.newURL((URL)url, (String)text);
            URLFileSystem.canonicalize((URL)url);
        }
        return url;
    }

    public boolean validateDefaultRunTarget(JRunProcess jrunProcess) {
        URL url;
        if (jrunProcess != null && (url = this._getURL()) != null) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            boolean failure = false;
            ArrayList<String> errors = new ArrayList<String>();
            Node node = DefaultRunnablePanel.getNode(url);
            if (node != null) {
                String starterFactoryName = jrunProcess.canGetStarterForTarget(node, null, errors);
                if (starterFactoryName == null) {
                    failure = true;
                }
            } else {
                errors.add(RunMgrArb.format(2, URLFileSystem.getFileName((URL)url)));
                failure = true;
            }
            wc.hide();
            if (failure) {
                String s;
                if (node != null) {
                    s = node.getShortLabel();
                } else if (URLFileSystem.isDirectoryPath((URL)url)) {
                    s = URLFileSystem.getPlatformPathName((URL)url);
                } else {
                    String fn = URLFileSystem.getFileName((URL)url);
                    String ffn = URLFileSystem.getPlatformPathName((URL)url);
                    s = RunMgrArb.format(57, fn, ffn);
                }
                errors.add(0, RunMgrArb.format(45, s));
                errors.add(1, "");
                errors.add("");
                errors.add(RunMgrArb.format(41, s));
                StringBuffer msg = new StringBuffer();
                int i = 0;
                while (i < errors.size()) {
                    msg.append(errors.get(i));
                    if (i < errors.size() - 1) {
                        msg.append("\n");
                    }
                    ++i;
                }
                return MessageDialog.optionalConfirm((String)"jdeveloper.runner.defaultRunnableMessage", (Component)this, (String)msg.toString(), (String)RunMgrArb.getString(62), null);
            }
        }
        return true;
    }

    private void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    public void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    public boolean canOk() {
        return this.targetTextField.getURL() != null;
    }

    public void loadFrom(RunConfiguration runConfiguration, Object sourceForTargets) {
        URL url = runConfiguration.getTargetURL();
        this.targetTextField.setURL(url);
        this.runActiveFileCheckBox.setSelected(runConfiguration.isRunActiveFile());
        this.context = null;
        this.urlSourcePath = null;
        if (sourceForTargets instanceof Project) {
            Project project = (Project)sourceForTargets;
            this.context = Context.newIdeContext((Node)project);
            this.context.setWorkspace(Ide.getActiveWorkspace());
            this.urlSourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath().getFirstEntry();
        }
    }

    public void commitTo(RunConfiguration runConfiguration) {
        URL url = this._getURL();
        runConfiguration.setTargetURL(url);
        runConfiguration.setRunActiveFile(this.runActiveFileCheckBox.isSelected());
    }

    static Node getNode(URL url) {
        try {
            Node node = NodeFactory.find((URL)url);
            if (node == null && URLFileSystem.exists((URL)url)) {
                node = NodeFactory.findOrCreate((URL)url);
            }
            Node node2 = node;
            return node2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Context ra$context(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.context;
    }

    static URL ra$urlSourcePath(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.urlSourcePath;
    }

    static URLTextField ra$targetTextField(DefaultRunnablePanel defaultRunnablePanel) {
        return defaultRunnablePanel.targetTextField;
    }

    static void mav$enableOk(DefaultRunnablePanel defaultRunnablePanel) {
        defaultRunnablePanel.enableOk();
    }

    final class 1
    implements URLChooserInit {
        public void initURLChooser(URLChooser urlChooser) {
            if (DefaultRunnablePanel.ra$context(DefaultRunnablePanel.this) != null) {
                DialogUtil.addShortcutButtons((URLChooser)urlChooser, (Context)DefaultRunnablePanel.ra$context(DefaultRunnablePanel.this));
            }
            if (DefaultRunnablePanel.ra$urlSourcePath(DefaultRunnablePanel.this) != null && DefaultRunnablePanel.ra$targetTextField(DefaultRunnablePanel.this).getURL() == null) {
                urlChooser.setSelectedURL(DefaultRunnablePanel.ra$urlSourcePath(DefaultRunnablePanel.this));
            }
        }
    }

    final class 2
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }

        public void insertUpdate(DocumentEvent e) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }

        public void removeUpdate(DocumentEvent e) {
            DefaultRunnablePanel.mav$enableOk(DefaultRunnablePanel.this);
        }
    }
}

